/*
 * Decompiled with CFR 0.152.
 */
package com.notunanancyowen.spears.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.notunanancyowen.Spears;
import com.notunanancyowen.SpearsClient;
import com.notunanancyowen.components.KineticWeapon;
import com.notunanancyowen.components.SwingAnimation;
import com.notunanancyowen.dataholders.SpearUser;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemInHandRenderer.class})
public abstract class HeldItemRendererMixin {
    @WrapOperation(method={"renderArmWithItem(Lnet/minecraft/client/player/AbstractClientPlayer;FFLnet/minecraft/world/InteractionHand;FLnet/minecraft/world/item/ItemStack;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;translate(FFF)V", ordinal=12)})
    private void suppressNormalSwing(PoseStack instance, float x, float y, float z, Operation<Void> original, @Local(argsOnly=true) ItemStack itemStack) {
        SwingAnimation s;
        Object object = itemStack.get(Spears.SWING_ANIMATION);
        if (object instanceof SwingAnimation && ((s = (SwingAnimation)object).swingType().equals("stab") || s.swingType().equals("none"))) {
            return;
        }
        original.call(new Object[]{instance, Float.valueOf(x), Float.valueOf(y), Float.valueOf(z)});
    }

    @WrapOperation(method={"renderArmWithItem(Lnet/minecraft/client/player/AbstractClientPlayer;FFLnet/minecraft/world/InteractionHand;FLnet/minecraft/world/item/ItemStack;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/ItemInHandRenderer;applyItemArmTransform(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/world/entity/HumanoidArm;F)V", ordinal=8)})
    private void suppressSwapAnimation(ItemInHandRenderer instance, PoseStack matrices, HumanoidArm arm, float equipProgress, Operation<Void> original, @Local(argsOnly=true) AbstractClientPlayer player, @Local(argsOnly=true) ItemStack itemStack) {
        SwingAnimation s;
        Object object = itemStack.get(Spears.SWING_ANIMATION);
        if (object instanceof SwingAnimation && (s = (SwingAnimation)object).swingType().equals("stab") && player.attackAnim > 0.0f) {
            original.call(new Object[]{instance, matrices, arm, Float.valueOf(0.0f)});
        } else {
            original.call(new Object[]{instance, matrices, arm, Float.valueOf(equipProgress)});
        }
    }

    @WrapOperation(method={"renderArmWithItem(Lnet/minecraft/client/player/AbstractClientPlayer;FFLnet/minecraft/world/InteractionHand;FLnet/minecraft/world/item/ItemStack;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/ItemInHandRenderer;applyItemArmAttackTransform(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/world/entity/HumanoidArm;F)V")})
    private void spearAnimation(ItemInHandRenderer instance, PoseStack matrices, HumanoidArm arm, float swingProgress, Operation<Void> original, @Local(argsOnly=true) ItemStack itemStack) {
        Object object = itemStack.get(Spears.SWING_ANIMATION);
        if (object instanceof SwingAnimation) {
            SwingAnimation s = (SwingAnimation)object;
            if (s.swingType().equals("stab")) {
                float g = -(Mth.cos((float)((float)Math.PI * Mth.clamp((float)Mth.inverseLerp((float)swingProgress, (float)0.0f, (float)0.05f), (float)0.0f, (float)1.0f))) - 1.0f) / 2.0f;
                float h = Mth.clamp((float)Mth.inverseLerp((float)swingProgress, (float)0.05f, (float)0.2f), (float)0.0f, (float)1.0f);
                h *= h;
                float j = Mth.clamp((float)Mth.inverseLerp((float)swingProgress, (float)0.4f, (float)1.0f), (float)0.0f, (float)1.0f);
                j = j < 0.5f ? (j == 0.0f ? 0.0f : (float)(Math.pow(2.0, 20.0 * (double)j - 10.0) / 2.0)) : (j == 1.0f ? 1.0f : (float)((2.0 - Math.pow(2.0, -20.0 * (double)j + 10.0)) / 2.0));
                boolean trident = itemStack.is(Items.TRIDENT);
                matrices.translate(j * 0.1f * (g - h), -0.075f * (g - j), (trident ? -0.4f * (g - j) : 0.0f) + 0.65f * (g - h));
                matrices.mulPose(Axis.XP.rotationDegrees(-(trident ? 50.0f : 70.0f) * (g - j)));
                matrices.translate(0.0, 0.0, -0.25 * (double)(j - h));
                return;
            }
            if (s.swingType().equals("none")) {
                return;
            }
        }
        original.call(new Object[]{instance, matrices, arm, Float.valueOf(swingProgress)});
    }

    @Inject(method={"renderArmWithItem(Lnet/minecraft/client/player/AbstractClientPlayer;FFLnet/minecraft/world/InteractionHand;FLnet/minecraft/world/item/ItemStack;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getUseAnimation()Lnet/minecraft/world/item/UseAnim;")})
    private void insertSpearAnimation(AbstractClientPlayer player, float tickDelta, float pitch, InteractionHand hand, float swingProgress, ItemStack item, float equipProgress, PoseStack matrices, MultiBufferSource vertexConsumers, int light, CallbackInfo ci, @Share(value="suppress") LocalBooleanRef suppress) {
        Object object;
        if (player.getUsedItemHand() == hand && (object = item.get(Spears.KINETIC_WEAPON)) instanceof KineticWeapon) {
            KineticWeapon k = (KineticWeapon)object;
            HumanoidArm arm = hand == InteractionHand.MAIN_HAND ? player.getMainArm() : player.getMainArm().getOpposite();
            int i = arm == HumanoidArm.RIGHT ? 1 : -1;
            matrices.translate((float)i * 0.56f, -0.52f, -0.72f);
            SpearsClient.holdUpAnimation lv = SpearsClient.holdUpAnimation.play(k, (float)item.getUseDuration((LivingEntity)player) - ((float)player.getUseItemRemainingTicks() - tickDelta + 1.0f));
            matrices.translate((double)((float)i * (lv.raiseProgress() * 0.15f + lv.raiseProgressEnd() * -0.05f + lv.swayProgress() * -0.1f + lv.swayScaleSlow() * 0.005f)), (double)(lv.raiseProgress() * -0.075f + lv.raiseProgressMiddle() * 0.075f + lv.swayScaleFast() * 0.01f), (double)lv.raiseProgressStart() * 0.05 + (double)lv.raiseProgressEnd() * -0.05 + (double)(lv.swayScaleSlow() * 0.005f));
            float f = lv.raiseProgress();
            if (f < 0.5f) {
                f = 4.0f * f * f * (7.189819f * f - 2.5949094f) / 2.0f;
            } else {
                float g = 2.0f * f - 2.0f;
                f = (g * g * (3.5949094f * g + 2.5949094f) + 2.0f) / 2.0f;
            }
            matrices.rotateAround(Axis.XP.rotationDegrees(-65.0f * f - 35.0f * lv.lowerProgress() + 100.0f * lv.raiseBackProgress() + -0.5f * lv.swayScaleFast()), 0.0f, 0.1f, 0.0f);
            matrices.rotateAround(Axis.YN.rotationDegrees((float)i * (-90.0f * Mth.clamp((float)Mth.inverseLerp((float)lv.raiseProgress(), (float)0.5f, (float)0.55f), (float)0.0f, (float)1.0f) + 60.0f * lv.swayProgress() + 30.0f * lv.raiseBackProgress() + 2.0f * lv.swayScaleSlow())), (float)i * 0.15f, 0.0f, 0.0f);
            float h = 0.0f;
            if (player instanceof SpearUser) {
                SpearUser s = (SpearUser)player;
                h = s.getTimeSinceLastKineticAttack(tickDelta);
            }
            h = 1.0f - Mth.square((float)Mth.square((float)(1.0f - Mth.clamp((float)Mth.inverseLerp((float)h, (float)1.0f, (float)3.0f), (float)0.0f, (float)1.0f)))) + (Mth.cos((float)((float)Math.PI * Mth.clamp((float)Mth.inverseLerp((float)h, (float)3.0f, (float)10.0f), (float)0.0f, (float)1.0f))) - 1.0f) / 2.0f;
            if ((h *= 0.4f) >= 10.0f) {
                h = 0.0f;
            }
            matrices.translate(0.0f, -h, 0.0f);
            suppress.set(true);
        }
    }

    @WrapOperation(method={"renderArmWithItem(Lnet/minecraft/client/player/AbstractClientPlayer;FFLnet/minecraft/world/InteractionHand;FLnet/minecraft/world/item/ItemStack;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/ItemInHandRenderer;applyItemArmTransform(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/world/entity/HumanoidArm;F)V", ordinal=2)})
    private void suppressEquipOffsetForUseAnimation(ItemInHandRenderer instance, PoseStack matrices, HumanoidArm arm, float equipProgress, Operation<Void> original, @Share(value="suppress") LocalBooleanRef suppress) {
        if (!suppress.get()) {
            original.call(new Object[]{instance, matrices, arm, Float.valueOf(equipProgress)});
        }
    }
}

