/*
 * Decompiled with CFR 0.152.
 */
package com.notunanancyowen.spears.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.notunanancyowen.Spears;
import com.notunanancyowen.components.KineticWeapon;
import com.notunanancyowen.components.SwingAnimation;
import com.notunanancyowen.components.UseEffects;
import com.notunanancyowen.dataholders.SpearUser;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
implements SpearUser {
    @Unique
    private long spears$lastKineticAttackTime = Integer.MIN_VALUE;
    @Unique
    @Nullable
    private Object2LongMap<Entity> spears$piercingCooldowns;

    @Shadow
    public abstract ItemStack getMainHandItem();

    @Shadow
    public abstract boolean hasEffect(Holder<MobEffect> var1);

    @Shadow
    @Nullable
    public abstract MobEffectInstance getEffect(Holder<MobEffect> var1);

    @Shadow
    public abstract ItemStack getUseItem();

    @Inject(method={"getCurrentSwingDuration()I"}, at={@At(value="HEAD")}, cancellable=true)
    private void overrideSwingDurationForSpear(CallbackInfoReturnable<Integer> cir) {
        Object object = this.getMainHandItem().get(Spears.SWING_ANIMATION);
        if (object instanceof SwingAnimation) {
            SwingAnimation s = (SwingAnimation)object;
            LivingEntity me = (LivingEntity)this;
            int swing = s.swingTicks();
            if (MobEffectUtil.hasDigSpeed((LivingEntity)me)) {
                cir.setReturnValue((Object)(swing - (1 + MobEffectUtil.getDigSpeedAmplification((LivingEntity)me))));
            } else {
                cir.setReturnValue((Object)(this.hasEffect((Holder<MobEffect>)MobEffects.DIG_SLOWDOWN) ? swing + (1 + Objects.requireNonNull(this.getEffect((Holder<MobEffect>)MobEffects.DIG_SLOWDOWN)).getAmplifier()) * 2 : swing));
            }
        }
    }

    @Inject(method={"startUsingItem(Lnet/minecraft/world/InteractionHand;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;gameEvent(Lnet/minecraft/core/Holder;)V")})
    private void recordPiercingCooldowns(InteractionHand hand, CallbackInfo ci) {
        Object object = this.getUseItem().get(Spears.KINETIC_WEAPON);
        if (object instanceof KineticWeapon) {
            KineticWeapon k = (KineticWeapon)object;
            this.spears$piercingCooldowns = new Object2LongOpenHashMap();
            k.playSound((Entity)((LivingEntity)this));
        }
    }

    @WrapOperation(method={"startUsingItem(Lnet/minecraft/world/InteractionHand;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;gameEvent(Lnet/minecraft/core/Holder;)V")})
    private void suppressSoundOnStart(LivingEntity instance, Holder<GameEvent> registryEntry, Operation<Void> original) {
        UseEffects u;
        Object object = instance.getUseItem().get(Spears.USE_EFFECTS);
        if (object instanceof UseEffects && !(u = (UseEffects)object).interactVibrations()) {
            return;
        }
        original.call(new Object[]{instance, registryEntry});
    }

    @WrapOperation(method={"stopUsingItem()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;gameEvent(Lnet/minecraft/core/Holder;)V")})
    private void suppressSoundOnStop(LivingEntity instance, Holder<GameEvent> registryEntry, Operation<Void> original) {
        UseEffects u;
        Object object = instance.getUseItem().get(Spears.USE_EFFECTS);
        if (object instanceof UseEffects && !(u = (UseEffects)object).interactVibrations()) {
            return;
        }
        original.call(new Object[]{instance, registryEntry});
    }

    @Inject(method={"stopUsingItem()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;setLivingEntityFlag(IZ)V")})
    private void forgetPiercingCooldowns(CallbackInfo ci) {
        this.spears$piercingCooldowns = null;
    }

    @Inject(method={"handleEntityEvent(B)V"}, at={@At(value="HEAD")})
    private void handleKineticAttack(byte status, CallbackInfo ci) {
        if (status == 2) {
            this.spears$lastKineticAttackTime = ((LivingEntity)this).getCommandSenderWorld().getGameTime();
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    private void tickPiercingCooldowns(CallbackInfo ci) {
        if (!((LivingEntity)this).getCommandSenderWorld().isClientSide() && this.spears$piercingCooldowns != null) {
            for (Entity e : this.spears$piercingCooldowns.keySet()) {
                long l = this.spears$piercingCooldowns.getLong((Object)e);
                if (l > 1L) {
                    this.spears$piercingCooldowns.replace((Object)e, l - 1L);
                    continue;
                }
                this.spears$piercingCooldowns.remove((Object)e, l);
            }
        }
    }

    @Override
    public float getTimeSinceLastKineticAttack(float tickProgress) {
        LivingEntity me = (LivingEntity)this;
        return this.spears$lastKineticAttackTime < 0L ? 0.0f : (float)(me.getCommandSenderWorld().getGameTime() - this.spears$lastKineticAttackTime) + tickProgress;
    }

    @Override
    public boolean isInPiercingCooldown(Entity target, int cooldownTicks) {
        if (this.spears$piercingCooldowns == null) {
            return false;
        }
        LivingEntity me = (LivingEntity)this;
        return this.spears$piercingCooldowns.containsKey((Object)target) ? me.getCommandSenderWorld().getGameTime() - this.spears$piercingCooldowns.getLong((Object)target) < (long)cooldownTicks : false;
    }

    @Override
    public void startPiercingCooldown(Entity target) {
        if (this.spears$piercingCooldowns != null) {
            LivingEntity me = (LivingEntity)this;
            this.spears$piercingCooldowns.put((Object)target, me.getCommandSenderWorld().getGameTime());
        }
    }

    @Override
    public int countSpearedMobs() {
        return this.spears$piercingCooldowns == null ? 0 : this.spears$piercingCooldowns.size();
    }

    @Override
    public boolean pierce(EquipmentSlot slot, Entity target, float damage, boolean dealDamage, boolean knockback, boolean dismount) {
        ItemStack itemStack;
        LivingEntity attacker = (LivingEntity)this;
        Level level = attacker.getCommandSenderWorld();
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverWorld = (ServerLevel)level;
        if (attacker instanceof Player) {
            LivingEntity livingEntity;
            boolean bl;
            Projectile projectileEntity;
            Player player = (Player)attacker;
            itemStack = attacker.getItemBySlot(slot);
            DamageSource damageSource = attacker.damageSources().playerAttack(player);
            float halfCD = player.getAttackStrengthScale(0.5f);
            float f = halfCD * (EnchantmentHelper.modifyDamage((ServerLevel)serverWorld, (ItemStack)player.getWeaponItem(), (Entity)target, (DamageSource)damageSource, (float)damage) - damage);
            damage *= 0.2f + halfCD * halfCD * 0.8f;
            if (knockback && target.getType().is(EntityTypeTags.REDIRECTABLE_PROJECTILE) && target instanceof Projectile && (projectileEntity = (Projectile)target).deflect(ProjectileDeflection.AIM_DEFLECT, (Entity)attacker, (Entity)attacker, true)) {
                return true;
            }
            float g = dealDamage ? damage + f : 0.0f;
            float h = 0.0f;
            if (target instanceof LivingEntity) {
                LivingEntity livingEntity2 = (LivingEntity)target;
                h = livingEntity2.getHealth();
            }
            boolean bl2 = bl = dealDamage && target.hurt(damageSource, g);
            if (knockback && target instanceof LivingEntity) {
                LivingEntity knockable = (LivingEntity)target;
                knockable.knockback((double)0.4f, attacker.getX() - target.getX(), attacker.getZ() - target.getZ());
            }
            boolean bl22 = false;
            if (dismount && target.isPassenger()) {
                bl22 = true;
                target.stopRiding();
            }
            if (!(bl || knockback || bl22)) {
                return false;
            }
            if (EnchantmentHelper.modifyDamage((ServerLevel)serverWorld, (ItemStack)itemStack, (Entity)target, (DamageSource)damageSource, (float)f) > f) {
                player.magicCrit(target);
            }
            player.setLastHurtMob(target);
            Entity entity = target;
            if (target instanceof EnderDragonPart) {
                entity = ((EnderDragonPart)target).parentMob;
            }
            boolean runEnchantmentEffects = bl;
            bl = false;
            if (entity instanceof LivingEntity) {
                livingEntity = (LivingEntity)entity;
                bl = itemStack.hurtEnemy(livingEntity, player);
            }
            if (runEnchantmentEffects) {
                EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverWorld, (Entity)target, (DamageSource)damageSource, (ItemStack)itemStack);
            }
            if (!player.getCommandSenderWorld().isClientSide() && !itemStack.isEmpty() && entity instanceof LivingEntity) {
                livingEntity = (LivingEntity)entity;
                if (bl) {
                    itemStack.postHurtEnemy(livingEntity, player);
                }
                if (itemStack.isEmpty()) {
                    if (itemStack == player.getMainHandItem()) {
                        player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
                    } else {
                        player.setItemInHand(InteractionHand.OFF_HAND, ItemStack.EMPTY);
                    }
                }
            }
            if (target instanceof LivingEntity) {
                f = h - ((LivingEntity)target).getHealth();
                player.awardStat(Stats.DAMAGE_DEALT, Math.round(f * 10.0f));
                if (player.getCommandSenderWorld() instanceof ServerLevel && f > 2.0f) {
                    int i = (int)((double)f * 0.5);
                    serverWorld.sendParticles((ParticleOptions)ParticleTypes.DAMAGE_INDICATOR, target.getX(), target.getY(0.5), target.getZ(), i, 0.1, 0.0, 0.1, 0.2);
                }
            }
            player.causeFoodExhaustion(0.1f);
            return true;
        }
        itemStack = attacker.getItemBySlot(slot);
        DamageSource damageSource = attacker.damageSources().mobAttack(attacker);
        float f = EnchantmentHelper.modifyDamage((ServerLevel)serverWorld, (ItemStack)itemStack, (Entity)target, (DamageSource)damageSource, (float)damage);
        boolean bl2 = dealDamage && target.hurt(damageSource, f);
        boolean bl = knockback | bl2;
        if (knockback && target instanceof LivingEntity) {
            LivingEntity knockable = (LivingEntity)target;
            knockable.knockback((double)0.4f, attacker.getX() - target.getX(), attacker.getZ() - target.getZ());
        }
        if (dismount && target.isPassenger()) {
            bl = true;
            target.stopRiding();
        }
        if (bl2) {
            EnchantmentHelper.doPostAttackEffects((ServerLevel)serverWorld, (Entity)target, (DamageSource)damageSource);
        }
        if (!bl) {
            return false;
        }
        if (attacker instanceof LivingEntity) {
            LivingEntity livingEntity = attacker;
            livingEntity.setLastHurtMob(target);
        }
        return true;
    }
}

