/*
 * Decompiled with CFR 0.152.
 */
package com.notunanancyowen.spears.mixin;

import com.notunanancyowen.Spears;
import com.notunanancyowen.SpearsClient;
import com.notunanancyowen.components.PiercingWeapon;
import com.notunanancyowen.packets.PlayerStabC2SPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Minecraft.class})
public abstract class MinecraftClientMixin {
    @Shadow
    @Nullable
    public LocalPlayer player;

    @Shadow
    @Nullable
    public abstract ClientPacketListener getConnection();

    /*
     * Enabled aggressive block sorting
     */
    @Inject(method={"startAttack()Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;getItemInHand(Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/item/ItemStack;", shift=At.Shift.AFTER)}, cancellable=true)
    private void spearAttack(CallbackInfoReturnable<Boolean> cir) {
        if (this.player == null) return;
        Object object = this.player.getMainHandItem().get(Spears.MINIMUM_ATTACK_CHARGE);
        if (object instanceof Float) {
            Float f = (Float)object;
            if (this.player.getAttackStrengthScale(0.0f) < f.floatValue()) {
                cir.setReturnValue((Object)false);
                return;
            }
        }
        if (!((object = this.player.getMainHandItem().get(Spears.PIERCING_WEAPON)) instanceof PiercingWeapon)) return;
        PiercingWeapon p = (PiercingWeapon)object;
        p.playSound((Entity)this.player);
        if (this.getConnection() != null) {
            SpearsClient.sendPacketUniversal.apply(new PlayerStabC2SPacket(this.player.getId()));
        }
        this.player.swing(InteractionHand.MAIN_HAND);
        this.player.resetAttackStrengthTicker();
        cir.setReturnValue((Object)true);
    }
}

