/*
 * Decompiled with CFR 0.152.
 */
package com.notunanancyowen.spears.mixin;

import com.notunanancyowen.Spears;
import com.notunanancyowen.components.AttackRange;
import com.notunanancyowen.components.PiercingWeapon;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Mob.class})
public class MobEntityMixin {
    @Inject(method={"isWithinMeleeAttackRange(Lnet/minecraft/world/entity/LivingEntity;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void canAttackWithSpear(LivingEntity entity, CallbackInfoReturnable<Boolean> cir) {
        Mob me = (Mob)this;
        Object object = me.getMainHandItem().get(Spears.ATTACK_RANGE);
        if (object instanceof AttackRange) {
            float minReach;
            float f;
            AttackRange attackRange = (AttackRange)object;
            try {
                minReach = f = attackRange.minReach();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            float maxReach = f = attackRange.maxReach();
            object = me.getMainHandItem().get(Spears.PIERCING_WEAPON);
            if (object instanceof PiercingWeapon) {
                PiercingWeapon p = (PiercingWeapon)object;
                double d = me.distanceTo((Entity)entity);
                cir.setReturnValue((Object)(d >= (double)minReach && d <= (double)maxReach && me.calculateViewVector(me.getXRot(), me.getVisualRotationYInDegrees()).dot(entity.position().subtract(me.position()).normalize()) > (double)p.hitboxMargin() ? 1 : 0));
            }
        }
    }

    @Inject(method={"doHurtTarget(Lnet/minecraft/world/entity/Entity;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void attackWithSpear(Entity target, CallbackInfoReturnable<Boolean> cir) {
        Mob me = (Mob)this;
        Object object = me.getMainHandItem().get(Spears.PIERCING_WEAPON);
        if (object instanceof PiercingWeapon) {
            PiercingWeapon p = (PiercingWeapon)object;
            me.lookAt(target, 30.0f, 30.0f);
            me.setYBodyRot(me.getYHeadRot());
            cir.setReturnValue((Object)p.stab((LivingEntity)me, EquipmentSlot.MAINHAND));
        }
    }
}

