/*
 * Decompiled with CFR 0.152.
 */
package com.notunanancyowen.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.notunanancyowen.PacketCodecHelper;
import com.notunanancyowen.Spears;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1508;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3468;
import net.minecraft.class_3483;
import net.minecraft.class_3966;
import net.minecraft.class_47;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.minecraft.class_8567;
import net.minecraft.class_9109;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.minecraft.class_9698;
import net.minecraft.class_9699;
import net.minecraft.class_9721;

public record PiercingWeapon(float minReach, float maxReach, float hitboxMargin, boolean dealsKnockback, boolean dismounts, Optional<class_6880<class_3414>> sound, Optional<class_6880<class_3414>> hitSound) {
    public static final Codec<PiercingWeapon> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Spears.rangedInclusiveFloat(0.0f, 128.0f).optionalFieldOf("min_reach", (Object)Float.valueOf(0.0f)).forGetter(PiercingWeapon::minReach), (App)Spears.rangedInclusiveFloat(0.0f, 128.0f).optionalFieldOf("max_reach", (Object)Float.valueOf(3.0f)).forGetter(PiercingWeapon::maxReach), (App)Spears.rangedInclusiveFloat(0.0f, 1.0f).optionalFieldOf("hitbox_margin", (Object)Float.valueOf(0.3f)).forGetter(PiercingWeapon::hitboxMargin), (App)Codec.BOOL.optionalFieldOf("deals_knockback", (Object)true).forGetter(PiercingWeapon::dealsKnockback), (App)Codec.BOOL.optionalFieldOf("dismounts", (Object)false).forGetter(PiercingWeapon::dismounts), (App)class_3414.field_41699.optionalFieldOf("sound").forGetter(PiercingWeapon::sound), (App)class_3414.field_41699.optionalFieldOf("hit_sound").forGetter(PiercingWeapon::hitSound)).apply((Applicative)instance, PiercingWeapon::new));
    public static final class_9139<class_9129, PiercingWeapon> PACKET_CODEC = PacketCodecHelper.tuple(class_9135.field_48552, PiercingWeapon::minReach, class_9135.field_48552, PiercingWeapon::maxReach, class_9135.field_48552, PiercingWeapon::hitboxMargin, class_9135.field_48547, PiercingWeapon::dealsKnockback, class_9135.field_48547, PiercingWeapon::dismounts, class_3414.field_48279.method_56433(class_9135::method_56382), PiercingWeapon::sound, class_3414.field_48279.method_56433(class_9135::method_56382), PiercingWeapon::hitSound, PiercingWeapon::new);

    public void playSound(class_1297 entity) {
        if (entity instanceof class_1657) {
            class_1657 p = (class_1657)entity;
            this.sound.ifPresent(sound -> entity.method_5770().method_60511(p, entity.method_23317(), entity.method_23318(), entity.method_23321(), sound, entity.method_5634(), 1.0f, 1.0f));
        }
    }

    public void playHitSound(class_1297 entity) {
        this.hitSound.ifPresent(sound -> entity.method_5770().method_60511(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), sound, entity.method_5634(), 1.0f, 1.0f));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean canHit(class_1297 attacker, class_1297 target) {
        if (!target.method_49108()) return false;
        if (target.method_5655()) return false;
        if (!target.method_5805()) return false;
        if (target instanceof class_1657) {
            class_1657 playerEntity = (class_1657)target;
            if (attacker instanceof class_1657) {
                class_1657 playerEntity2 = (class_1657)attacker;
                if (!playerEntity2.method_7256(playerEntity)) return false;
            }
        }
        if (attacker.method_5794(target)) return false;
        return true;
    }

    public void stab(class_1309 attacker, class_1304 slot) {
        class_1937 class_19372;
        float f = (float)attacker.method_45325(class_5134.field_23721);
        boolean bl = false;
        for (class_3966 entityHitResult : Spears.collectPiercingCollisions(attacker, this.minReach, this.maxReach, this.hitboxMargin, entity -> PiercingWeapon.canHit((class_1297)attacker, entity))) {
            bl |= this.pierce(attacker, slot, entityHitResult.method_17782(), f, true, this.dealsKnockback, this.dismounts);
        }
        class_1799 stack = attacker.method_6118(slot);
        if (!stack.method_7960() && (class_19372 = attacker.method_37908()) instanceof class_3218) {
            class_3218 server = (class_3218)class_19372;
            class_9304 itemEnchantmentsComponent = (class_9304)stack.method_57824(class_9334.field_49633);
            if (itemEnchantmentsComponent != null && !itemEnchantmentsComponent.method_57543()) {
                class_9699 enchantmentEffectContext = new class_9699(stack, slot, attacker);
                for (Object2IntMap.Entry entry : itemEnchantmentsComponent.method_57539()) {
                    class_6880 registryEntry = (class_6880)entry.getKey();
                    int lvl = class_1890.method_8225((class_6880)registryEntry, (class_1799)stack);
                    if (!((class_1887)registryEntry.comp_349()).method_60026(slot)) continue;
                    for (class_9698 enchantmentEffectEntry : ((class_1887)registryEntry.comp_349()).method_60034(Spears.POST_PIERCING_ATTACK)) {
                        class_8567 lootContextParameterSet;
                        if (!enchantmentEffectEntry.method_60006(new class_47.class_48(lootContextParameterSet = new class_8567.class_8568(server).method_51874(class_181.field_1226, (Object)attacker).method_51874(class_181.field_51805, (Object)lvl).method_51874(class_181.field_24424, (Object)attacker.method_19538()).method_51875(class_173.field_51804)).method_309(Optional.empty()))) continue;
                        ((class_9721)enchantmentEffectEntry.comp_2680()).method_60220(server, lvl, enchantmentEffectContext, (class_1297)attacker, attacker.method_19538());
                    }
                }
            }
        }
        if (bl) {
            this.playHitSound((class_1297)attacker);
        }
        this.playSound((class_1297)attacker);
        attacker.method_23667(class_1268.field_5808, false);
    }

    public boolean pierce(class_1309 attacker, class_1304 slot, class_1297 target, float damage, boolean dealDamage, boolean knockback, boolean dismount) {
        class_1799 itemStack;
        class_1937 class_19372 = attacker.method_5770();
        if (!(class_19372 instanceof class_3218)) {
            return false;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        if (attacker instanceof class_1657) {
            boolean bl;
            class_1676 projectileEntity;
            class_1657 player = (class_1657)attacker;
            itemStack = attacker.method_6118(slot);
            class_1282 damageSource = attacker.method_48923().method_48802(player);
            float halfCD = player.method_7261(0.5f);
            float f = halfCD * (class_1890.method_60120((class_3218)serverWorld, (class_1799)player.method_59958(), (class_1297)target, (class_1282)damageSource, (float)damage) - damage);
            damage *= 0.2f + halfCD * halfCD * 0.2f;
            if (knockback && target.method_5864().method_20210(class_3483.field_51503) && target instanceof class_1676 && (projectileEntity = (class_1676)target).method_59859(class_9109.field_51509, (class_1297)attacker, (class_1297)attacker, true)) {
                return true;
            }
            float g = dealDamage ? damage + f : 0.0f;
            float h = 0.0f;
            if (target instanceof class_1309) {
                class_1309 livingEntity = (class_1309)target;
                h = livingEntity.method_6032();
            }
            boolean bl2 = bl = dealDamage && target.method_5643(damageSource, g);
            if (knockback && target instanceof class_1309) {
                class_1309 knockable = (class_1309)target;
                knockable.method_6005((double)0.4f, attacker.method_23317() - target.method_23317(), attacker.method_23321() - target.method_23321());
            }
            boolean bl22 = false;
            if (dismount && target.method_5765()) {
                bl22 = true;
                target.method_5848();
            }
            if (!(bl || knockback || bl22)) {
                return false;
            }
            if (class_1890.method_60120((class_3218)serverWorld, (class_1799)itemStack, (class_1297)target, (class_1282)damageSource, (float)f) > f) {
                player.method_7304(target);
            }
            player.method_6114(target);
            class_1297 entity = target;
            if (target instanceof class_1508) {
                entity = ((class_1508)target).field_7007;
            }
            boolean runEnchantmentEffects = bl;
            bl = false;
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                bl = itemStack.method_7979(livingEntity, player);
            }
            if (runEnchantmentEffects) {
                class_1890.method_60619((class_3218)serverWorld, (class_1297)target, (class_1282)damageSource, (class_1799)itemStack);
            }
            if (!player.method_5770().method_8608() && !itemStack.method_7960() && entity instanceof class_1309) {
                if (bl) {
                    itemStack.method_59979((class_1309)entity, player);
                }
                if (itemStack.method_7960()) {
                    if (itemStack == player.method_6047()) {
                        player.method_6122(class_1268.field_5808, class_1799.field_8037);
                    } else {
                        player.method_6122(class_1268.field_5810, class_1799.field_8037);
                    }
                }
            }
            if (target instanceof class_1309) {
                f = h - ((class_1309)target).method_6032();
                player.method_7339(class_3468.field_15399, Math.round(f * 10.0f));
                if (player.method_5770() instanceof class_3218 && f > 2.0f) {
                    int i = (int)((double)f * 0.5);
                    ((class_3218)player.method_5770()).method_14199((class_2394)class_2398.field_11209, target.method_23317(), target.method_23323(0.5), target.method_23321(), i, 0.1, 0.0, 0.1, 0.2);
                }
            }
            player.method_7322(0.1f);
            return true;
        }
        itemStack = attacker.method_6118(slot);
        class_1282 damageSource = attacker.method_48923().method_48812(attacker);
        float f = class_1890.method_60120((class_3218)serverWorld, (class_1799)itemStack, (class_1297)target, (class_1282)damageSource, (float)damage);
        boolean bl2 = dealDamage && target.method_5643(damageSource, f);
        boolean bl = knockback | bl2;
        if (knockback && target instanceof class_1309) {
            class_1309 knockable = (class_1309)target;
            knockable.method_6005((double)0.4f, attacker.method_23317() - target.method_23317(), attacker.method_23321() - target.method_23321());
        }
        if (dismount && target.method_5765()) {
            bl = true;
            target.method_5848();
        }
        if (bl2) {
            class_1890.method_60107((class_3218)serverWorld, (class_1297)target, (class_1282)damageSource);
        }
        if (!bl) {
            return false;
        }
        if (attacker instanceof class_1309) {
            class_1309 livingEntity = attacker;
            livingEntity.method_6114(target);
        }
        return true;
    }
}

