/*
 * Decompiled with CFR 0.152.
 */
package com.notunanancyowen.spears.mixin;

import com.notunanancyowen.Spears;
import com.notunanancyowen.components.KineticWeapon;
import com.notunanancyowen.components.SwingAnimation;
import com.notunanancyowen.dataholders.SpearUser;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Objects;
import net.minecraft.class_1268;
import net.minecraft.class_1291;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
implements SpearUser {
    @Unique
    private long lastKineticAttackTime = Integer.MIN_VALUE;
    @Unique
    @Nullable
    private Object2LongMap<class_1297> piercingCooldowns;

    @Shadow
    public abstract class_1799 method_6047();

    @Shadow
    public abstract boolean method_6059(class_6880<class_1291> var1);

    @Shadow
    @Nullable
    public abstract class_1293 method_6112(class_6880<class_1291> var1);

    @Shadow
    public abstract class_1799 method_6030();

    @Inject(method={"method_6028()I"}, at={@At(value="HEAD")}, cancellable=true)
    private void overrideSwingDurationForSpear(CallbackInfoReturnable<Integer> cir) {
        Object object = this.method_6047().method_57824(Spears.SWING_ANIMATION);
        if (object instanceof SwingAnimation) {
            SwingAnimation s = (SwingAnimation)object;
            class_1309 me = (class_1309)this;
            int swing = s.swingTicks();
            if (class_1292.method_5576((class_1309)me)) {
                cir.setReturnValue((Object)(swing - (1 + class_1292.method_5575((class_1309)me))));
            } else {
                cir.setReturnValue((Object)(this.method_6059((class_6880<class_1291>)class_1294.field_5901) ? swing + (1 + Objects.requireNonNull(this.method_6112((class_6880<class_1291>)class_1294.field_5901)).method_5578()) * 2 : swing));
            }
        }
    }

    @Inject(method={"method_6019(Lnet/minecraft/class_1268;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_1309;method_32876(Lnet/minecraft/class_6880;)V")})
    private void recordPiercingCooldowns(class_1268 hand, CallbackInfo ci) {
        Object object;
        if (this.method_6030() != null && (object = this.method_6030().method_57824(Spears.KINETIC_WEAPON)) instanceof KineticWeapon) {
            KineticWeapon k = (KineticWeapon)object;
            this.piercingCooldowns = new Object2LongOpenHashMap();
            k.playSound((class_1297)((class_1309)this));
        }
    }

    @Inject(method={"method_6021()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_1309;method_6085(IZ)V")})
    private void forgetPiercingCooldowns(CallbackInfo ci) {
        this.piercingCooldowns = null;
    }

    @Inject(method={"method_5711(B)V"}, at={@At(value="HEAD")})
    private void handleKineticAttack(byte status, CallbackInfo ci) {
        if (status == 2) {
            this.lastKineticAttackTime = ((class_1309)this).method_5770().method_8510();
        }
    }

    @Inject(method={"method_5773()V"}, at={@At(value="TAIL")})
    private void tickPiercingCooldowns(CallbackInfo ci) {
        if (!((class_1309)this).method_5770().method_8608() && this.piercingCooldowns != null) {
            for (class_1297 e : this.piercingCooldowns.keySet()) {
                long l = this.piercingCooldowns.getLong((Object)e);
                if (l > 1L) {
                    this.piercingCooldowns.replace((Object)e, l - 1L);
                    continue;
                }
                this.piercingCooldowns.remove((Object)e, l);
            }
        }
    }

    @Override
    public float getTimeSinceLastKineticAttack(float tickProgress) {
        class_1309 me = (class_1309)this;
        return this.lastKineticAttackTime < 0L ? 0.0f : (float)(me.method_5770().method_8510() - this.lastKineticAttackTime) + tickProgress;
    }

    @Override
    public boolean isInPiercingCooldown(class_1297 target, int cooldownTicks) {
        if (this.piercingCooldowns == null) {
            return false;
        }
        class_1309 me = (class_1309)this;
        return this.piercingCooldowns.containsKey((Object)target) ? me.method_5770().method_8510() - this.piercingCooldowns.getLong((Object)target) < (long)cooldownTicks : false;
    }

    @Override
    public void startPiercingCooldown(class_1297 target) {
        if (this.piercingCooldowns != null) {
            class_1309 me = (class_1309)this;
            this.piercingCooldowns.put((Object)target, me.method_5770().method_8510());
        }
    }

    @Override
    public int countSpearedMobs() {
        return this.piercingCooldowns == null ? 0 : this.piercingCooldowns.size();
    }
}

