/*
 * Decompiled with CFR 0.152.
 */
package de.meisterah.ahAutoReccon;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_419;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_500;
import net.minecraft.class_642;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AhAutoReccon
implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"ah-autoreconnect");
    private static AhAutoReccon instance;
    private boolean shouldReconnect = false;
    private class_642 lastServer = null;
    private class_642 targetServer = null;
    public int reconnectDelay = 5;
    private final int DEFAULT_RECONNECT_DELAY = 5;
    private int tickCounter = 0;
    private int reconnectTimer = 0;
    private int reconnectAttempts = 0;
    private int maxReconnectAttempts = -1;
    private boolean wasConnected = false;
    private boolean autoStartReconnect = true;
    private class_2561 lastDisconnectReason = null;

    public void onInitializeClient() {
        instance = this;
        LOGGER.info("AH-AutoReconnect Mod initialized");
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            LOGGER.info("Successfully connected to server");
            this.wasConnected = true;
            this.shouldReconnect = false;
            this.reconnectDelay = 5;
            this.reconnectTimer = 0;
            this.reconnectAttempts = 0;
            if (client.method_1558() != null) {
                this.lastServer = client.method_1558();
                this.targetServer = null;
            }
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            LOGGER.info("Disconnected from server");
            if (this.wasConnected && this.autoStartReconnect && this.lastServer != null) {
                LOGGER.info("Auto-Reconnect triggered by disconnect event for: " + this.lastServer.field_3761);
                this.shouldReconnect = true;
                this.reconnectTimer = 0;
                this.reconnectAttempts = 0;
                this.wasConnected = false;
            }
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            class_437 patt0$temp;
            if (client.method_1558() != null) {
                if (client.method_1562() != null) {
                    this.lastServer = client.method_1558();
                    this.targetServer = null;
                } else {
                    this.targetServer = client.method_1558();
                }
            }
            if (client.field_1755 instanceof class_442) {
                if (this.shouldReconnect) {
                    LOGGER.info("Returning to main menu - stopping reconnect");
                }
                this.shouldReconnect = false;
                this.reconnectTimer = 0;
                this.reconnectAttempts = 0;
                this.reconnectDelay = 5;
                this.wasConnected = false;
                this.targetServer = null;
            }
            if ((patt0$temp = client.field_1755) instanceof class_419) {
                class_642 serverToReconnect;
                class_419 disconnectScreen = (class_419)patt0$temp;
                class_642 class_6422 = serverToReconnect = this.targetServer != null ? this.targetServer : this.lastServer;
                if (!this.shouldReconnect && this.autoStartReconnect && serverToReconnect != null) {
                    LOGGER.info("Auto-Reconnect starting for: " + serverToReconnect.field_3761);
                    this.shouldReconnect = true;
                    this.reconnectTimer = 0;
                    this.reconnectAttempts = 0;
                    try {
                        Field reasonField = class_419.class.getDeclaredField("reason");
                        reasonField.setAccessible(true);
                        this.lastDisconnectReason = (class_2561)reasonField.get(disconnectScreen);
                    }
                    catch (Exception reasonField) {
                        // empty catch block
                    }
                }
                if (!this.shouldReconnect && serverToReconnect != null) {
                    LOGGER.info("Force-starting auto-reconnect for: " + serverToReconnect.field_3761);
                    this.shouldReconnect = true;
                    this.reconnectTimer = 0;
                    this.reconnectAttempts = 0;
                }
                if (this.tickCounter % 20 == 0) {
                    try {
                        Method refreshMethod = disconnectScreen.getClass().getDeclaredMethod("init", new Class[0]);
                        refreshMethod.setAccessible(true);
                        refreshMethod.invoke((Object)disconnectScreen, new Object[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (this.shouldReconnect && client.field_1755 instanceof class_419) {
                ++this.tickCounter;
                if (this.tickCounter >= 20) {
                    this.tickCounter = 0;
                    ++this.reconnectTimer;
                    if (this.reconnectTimer >= this.reconnectDelay) {
                        class_642 serverToReconnect;
                        this.reconnectTimer = 0;
                        ++this.reconnectAttempts;
                        if (this.maxReconnectAttempts > 0 && this.reconnectAttempts > this.maxReconnectAttempts) {
                            LOGGER.info("Max reconnect attempts reached - stopping reconnect");
                            this.shouldReconnect = false;
                            return;
                        }
                        class_642 class_6423 = serverToReconnect = this.targetServer != null ? this.targetServer : this.lastServer;
                        if (serverToReconnect != null) {
                            LOGGER.info("Starting reconnect attempt #" + this.reconnectAttempts + " to " + serverToReconnect.field_3761);
                            this.performReconnect(client, serverToReconnect);
                            this.reconnectDelay = Math.min(this.reconnectDelay * 2, 600);
                            LOGGER.info("Reconnect delay increased to: " + this.reconnectDelay + " seconds");
                        }
                    }
                }
            } else if (!this.shouldReconnect) {
                this.tickCounter = 0;
                this.reconnectTimer = 0;
            }
        });
    }

    private void performReconnect(class_310 client, class_642 server) {
        if (server == null) {
            LOGGER.error("Cannot reconnect - no server info available");
            this.shouldReconnect = false;
            return;
        }
        client.execute(() -> {
            LOGGER.info("Starting connection to " + server.field_3761);
            try {
                client.method_1507(null);
                class_500 mpScreen = new class_500((class_437)new class_442());
                client.method_1507((class_437)mpScreen);
                client.execute(() -> {
                    try {
                        boolean methodFound = false;
                        String[] methodNames = new String[]{"connectToServer", "connect", "method_2318"};
                        for (String methodName : methodNames) {
                            try {
                                Method method = class_500.class.getDeclaredMethod(methodName, class_642.class);
                                method.setAccessible(true);
                                method.invoke((Object)mpScreen, server);
                                methodFound = true;
                                LOGGER.info("Connected using method: " + methodName);
                                break;
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                            }
                        }
                        if (!methodFound) {
                            for (Method method : class_500.class.getDeclaredMethods()) {
                                if (method.getParameterCount() != 1 || !method.getParameterTypes()[0].equals(class_642.class)) continue;
                                LOGGER.info("Found fallback method: " + method.getName());
                                method.setAccessible(true);
                                method.invoke((Object)mpScreen, server);
                                methodFound = true;
                                break;
                            }
                        }
                        if (!methodFound) {
                            LOGGER.error("No suitable connection method found");
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Error while connecting: ", (Throwable)e);
                    }
                });
            }
            catch (Exception e) {
                LOGGER.error("Error while opening MultiplayerScreen: ", (Throwable)e);
            }
        });
    }

    public static AhAutoReccon getInstance() {
        return instance;
    }

    public int getMaxReconnectAttempts() {
        return this.maxReconnectAttempts;
    }

    public void startReconnect(class_642 serverInfo) {
        if (serverInfo != null) {
            this.lastServer = serverInfo;
            this.shouldReconnect = true;
            this.reconnectTimer = 0;
            this.reconnectAttempts = 0;
            LOGGER.info("Auto-Reconnect manually started for: " + serverInfo.field_3761);
        }
    }

    public void stopReconnect() {
        this.shouldReconnect = false;
        LOGGER.info("Auto-Reconnect stopped");
    }

    public boolean isReconnecting() {
        return this.shouldReconnect;
    }

    public void setAutoStartReconnect(boolean autoStart) {
        this.autoStartReconnect = autoStart;
        LOGGER.info("Auto-Start Reconnect set to " + autoStart);
    }

    public boolean getAutoStartReconnect() {
        return this.autoStartReconnect;
    }

    public class_642 getLastServer() {
        return this.lastServer;
    }

    public void setReconnectDelay(int seconds) {
        this.reconnectDelay = Math.max(1, seconds);
        LOGGER.info("Reconnect-Delay set to " + this.reconnectDelay + " Seconds");
    }

    public void setMaxReconnectAttempts(int attempts) {
        this.maxReconnectAttempts = attempts;
        LOGGER.info("Maximum Reconnect-Attempts set to " + String.valueOf(attempts < 0 ? "unbegrenzt" : Integer.valueOf(attempts)));
    }

    public int getReconnectTimer() {
        return this.reconnectTimer;
    }

    public void resetReconnectTimer() {
        this.reconnectTimer = 0;
    }

    public void manualReconnect() {
        class_642 serverToReconnect;
        class_642 class_6422 = serverToReconnect = this.targetServer != null ? this.targetServer : this.lastServer;
        if (serverToReconnect != null) {
            this.shouldReconnect = true;
            this.reconnectTimer = 0;
            ++this.reconnectAttempts;
            this.performReconnect(class_310.method_1551(), serverToReconnect);
        }
    }

    public class_642 getTargetServer() {
        return this.targetServer;
    }

    public class_2561 getLastDisconnectReason() {
        return this.lastDisconnectReason;
    }
}

