/*
 * Decompiled with CFR 0.152.
 */
package com.cjcrafter.foliascheduler.bukkit;

import com.cjcrafter.foliascheduler.AsyncSchedulerImplementation;
import com.cjcrafter.foliascheduler.EntitySchedulerImplementation;
import com.cjcrafter.foliascheduler.GlobalSchedulerImplementation;
import com.cjcrafter.foliascheduler.RegionSchedulerImplementation;
import com.cjcrafter.foliascheduler.ServerImplementation;
import com.cjcrafter.foliascheduler.bukkit.BukkitAsyncScheduler;
import com.cjcrafter.foliascheduler.bukkit.BukkitEntityScheduler;
import com.cjcrafter.foliascheduler.bukkit.BukkitRegionScheduler;
import com.cjcrafter.foliascheduler.bukkit.BukkitSyncScheduler;
import com.cjcrafter.foliascheduler.util.MethodInvoker;
import com.cjcrafter.foliascheduler.util.ReflectionUtil;
import com.cjcrafter.foliascheduler.util.WrappedReflectiveOperationException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class BukkitServer
implements ServerImplementation {
    @NotNull
    private final Plugin owningPlugin;
    @NotNull
    private final BukkitSyncScheduler sync;
    @NotNull
    private final BukkitRegionScheduler region;
    @NotNull
    private final BukkitAsyncScheduler async;
    @Nullable
    private MethodInvoker teleportAsyncMethod;

    @ApiStatus.Internal
    public BukkitServer(@NotNull Plugin owningPlugin) {
        this.owningPlugin = owningPlugin;
        this.sync = new BukkitSyncScheduler(owningPlugin);
        this.region = new BukkitRegionScheduler(owningPlugin);
        this.async = new BukkitAsyncScheduler(owningPlugin);
        try {
            this.teleportAsyncMethod = ReflectionUtil.getMethod(Entity.class, "teleportAsync", Location.class, PlayerTeleportEvent.TeleportCause.class);
        }
        catch (WrappedReflectiveOperationException wrappedReflectiveOperationException) {
            // empty catch block
        }
    }

    @Override
    @NotNull
    public Plugin getOwningPlugin() {
        return this.owningPlugin;
    }

    @Override
    public boolean isOwnedByCurrentRegion(@NotNull Location location) {
        return this.owningPlugin.getServer().isPrimaryThread();
    }

    @Override
    public boolean isOwnedByCurrentRegion(@NotNull Location location, int squareRadiusChunks) {
        return this.owningPlugin.getServer().isPrimaryThread();
    }

    @Override
    public boolean isOwnedByCurrentRegion(@NotNull Block block) {
        return this.owningPlugin.getServer().isPrimaryThread();
    }

    @Override
    public boolean isOwnedByCurrentRegion(@NotNull World world, int chunkX, int chunkZ) {
        return this.owningPlugin.getServer().isPrimaryThread();
    }

    @Override
    public boolean isOwnedByCurrentRegion(@NotNull World world, int chunkX, int chunkZ, int squareRadiusChunks) {
        return this.owningPlugin.getServer().isPrimaryThread();
    }

    @Override
    public boolean isOwnedByCurrentRegion(@NotNull Entity entity) {
        return this.owningPlugin.getServer().isPrimaryThread();
    }

    @Override
    @NotNull
    public GlobalSchedulerImplementation global() {
        return this.sync;
    }

    @Override
    @NotNull
    public AsyncSchedulerImplementation async() {
        return this.async;
    }

    @Override
    @NotNull
    public EntitySchedulerImplementation entity(@NotNull Entity entity) {
        return new BukkitEntityScheduler(this.owningPlugin, entity);
    }

    @Override
    @NotNull
    public RegionSchedulerImplementation region(@NotNull World world, int chunkX, int chunkZ) {
        return this.region;
    }

    @Override
    public void cancelTasks() {
        this.owningPlugin.getServer().getScheduler().cancelTasks(this.owningPlugin);
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> teleportAsync(@NotNull Entity entity, @NotNull Location location, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PlayerTeleportEvent.TeleportCause cause) {
        if (this.teleportAsyncMethod != null) {
            Object result = this.teleportAsyncMethod.invoke(entity, location, cause);
            return (CompletableFuture)Objects.requireNonNull(result);
        }
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.entity(entity).run(task -> {
            try {
                entity.teleport(location);
                future.complete(true);
            }
            catch (Throwable ex) {
                this.owningPlugin.getLogger().log(Level.SEVERE, "Failed to teleport entity", ex);
                future.complete(false);
            }
        });
        return future;
    }
}

