/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.XLeaderBoards.commands;

import io.github.InsiderAnh.XLeaderBoards.XLeaderBoard;
import io.github.InsiderAnh.XLeaderBoards.libs.bson.Document;
import io.github.InsiderAnh.XLeaderBoards.utils.CenterMessage;
import io.github.InsiderAnh.XLeaderBoards.utils.LeaderUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;

public class XLeaderboardCMD
implements TabExecutor {
    private final XLeaderBoard plugin = XLeaderBoard.getInstance();

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length < 1) {
            this.sendHelp(sender);
            return false;
        }
        block6 : switch (args[0].toLowerCase()) {
            case "gettop": {
                if (!sender.hasPermission("xleaderboards.gettop")) {
                    sender.sendMessage(this.plugin.getLang().getString("tops.noPermission"));
                    return true;
                }
                if (args.length < 3) {
                    this.sendHelp(sender);
                    return false;
                }
                String timeType = args[1];
                String topName = args[2];
                Document document = this.plugin.getTopManager().getTops().get(timeType + "_" + topName);
                if (document == null) {
                    sender.sendMessage("\u00a7cNo exists " + timeType + " " + topName);
                    return false;
                }
                for (String message : this.plugin.getLang().getString("tops.tops").split("\\n")) {
                    if (message.startsWith("<center>")) {
                        sender.sendMessage(CenterMessage.getCenteredMessage(message.replaceFirst("<center>", "")));
                        continue;
                    }
                    if (message.contains("<tops>")) {
                        for (String index : document.keySet()) {
                            Document topDocument = (Document)document.get(index);
                            String name = topDocument.getString("name");
                            String amount = topDocument.get("amount") instanceof Double ? LeaderUtils.formatNumber(topDocument.getDouble("amount")) : (topDocument.get("amount") instanceof Integer ? String.valueOf(topDocument.getInteger("amount")) : (topDocument.get("amount") instanceof Long ? String.valueOf(topDocument.getLong("amount")) : "0"));
                            sender.sendMessage(this.plugin.getLang().getString("tops.topLine").replace("<#>", index).replace("<name>", name).replace("<value>", amount));
                        }
                        continue;
                    }
                    sender.sendMessage(message);
                }
                break;
            }
            case "forceupdate": {
                String timeType;
                if (!sender.hasPermission("xleaderboards.forceupdate")) {
                    sender.sendMessage(this.plugin.getLang().getString("tops.noPermission"));
                    return true;
                }
                if (args.length < 2) {
                    this.sendHelp(sender);
                    return true;
                }
                sender.sendMessage("\u00a7aForced update of the top.");
                switch (timeType = args[1].toLowerCase()) {
                    case "daily": {
                        this.plugin.getTopManager().updateDailyRankings();
                        break block6;
                    }
                    case "weekly": {
                        this.plugin.getTopManager().updateWeeklyRankings();
                        break block6;
                    }
                    case "monthly": {
                        this.plugin.getTopManager().updateMonthlyRankings();
                        break block6;
                    }
                    case "permanent": {
                        this.plugin.getTopManager().updatePermanentRankings();
                        break block6;
                    }
                }
                sender.sendMessage("\u00a7cInvalid time type.");
                return true;
            }
            case "reload": {
                this.plugin.reload();
                break;
            }
            default: {
                this.sendHelp(sender);
            }
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length <= 1) {
            return Arrays.asList("gettop", "forceupdate", "help", "reload");
        }
        switch (args[0].toLowerCase()) {
            case "gettop": {
                if (args.length > 2) {
                    return this.plugin.getTopManager().getTopData().keySet().stream().filter(s -> s.contains(args[args.length - 1])).collect(Collectors.toList());
                }
                return Arrays.asList("daily", "weekly", "monthly", "permanent");
            }
            case "forceupdate": {
                return Arrays.asList("daily", "weekly", "monthly", "permanent");
            }
        }
        return Collections.emptyList();
    }

    void sendHelp(CommandSender sender) {
        sender.sendMessage(ChatColor.GRAY + "" + ChatColor.STRIKETHROUGH + "+---------------------------------------+");
        sender.sendMessage(ChatColor.DARK_GRAY + "[!] " + ChatColor.RED + "XLeaderBoards " + ChatColor.DARK_GRAY + "[!]");
        sender.sendMessage(ChatColor.GRAY + "" + ChatColor.STRIKETHROUGH + "+---------------------------------------+");
        sender.sendMessage(ChatColor.YELLOW + "/xlb gettop daily/weekly/monthly/permanent <topName> " + ChatColor.GRAY + "- " + ChatColor.WHITE + "Gets the top of the day, week, month or permanent.");
        sender.sendMessage(ChatColor.YELLOW + "/xlb forceupdate daily/weekly/monthly/permanent " + ChatColor.GRAY + "- " + ChatColor.WHITE + "Forces the update of the top.");
        sender.sendMessage(ChatColor.YELLOW + "/xlb reload " + ChatColor.GRAY + "- " + ChatColor.WHITE + "Reload the plugin.");
    }
}

