/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.XLeaderBoards.libs.bson.codecs;

import io.github.InsiderAnh.XLeaderBoards.libs.bson.BsonReader;
import io.github.InsiderAnh.XLeaderBoards.libs.bson.BsonType;
import io.github.InsiderAnh.XLeaderBoards.libs.bson.BsonWriter;
import io.github.InsiderAnh.XLeaderBoards.libs.bson.Transformer;
import io.github.InsiderAnh.XLeaderBoards.libs.bson.UuidRepresentation;
import io.github.InsiderAnh.XLeaderBoards.libs.bson.assertions.Assertions;
import io.github.InsiderAnh.XLeaderBoards.libs.bson.codecs.BsonTypeClassMap;
import io.github.InsiderAnh.XLeaderBoards.libs.bson.codecs.BsonTypeCodecMap;
import io.github.InsiderAnh.XLeaderBoards.libs.bson.codecs.Codec;
import io.github.InsiderAnh.XLeaderBoards.libs.bson.codecs.DecoderContext;
import io.github.InsiderAnh.XLeaderBoards.libs.bson.codecs.EncoderContext;
import io.github.InsiderAnh.XLeaderBoards.libs.bson.codecs.OverridableUuidRepresentationCodec;
import io.github.InsiderAnh.XLeaderBoards.libs.bson.codecs.configuration.CodecRegistry;
import java.util.ArrayList;
import java.util.UUID;

public class IterableCodec
implements Codec<Iterable>,
OverridableUuidRepresentationCodec<Iterable> {
    private final CodecRegistry registry;
    private final BsonTypeCodecMap bsonTypeCodecMap;
    private final Transformer valueTransformer;
    private final UuidRepresentation uuidRepresentation;

    public IterableCodec(CodecRegistry registry, BsonTypeClassMap bsonTypeClassMap) {
        this(registry, bsonTypeClassMap, null);
    }

    public IterableCodec(CodecRegistry registry, BsonTypeClassMap bsonTypeClassMap, Transformer valueTransformer) {
        this(registry, new BsonTypeCodecMap(Assertions.notNull("bsonTypeClassMap", bsonTypeClassMap), registry), valueTransformer, UuidRepresentation.JAVA_LEGACY);
    }

    private IterableCodec(CodecRegistry registry, BsonTypeCodecMap bsonTypeCodecMap, Transformer valueTransformer, UuidRepresentation uuidRepresentation) {
        this.registry = Assertions.notNull("registry", registry);
        this.bsonTypeCodecMap = bsonTypeCodecMap;
        this.valueTransformer = valueTransformer != null ? valueTransformer : new Transformer(){

            @Override
            public Object transform(Object objectToTransform) {
                return objectToTransform;
            }
        };
        this.uuidRepresentation = uuidRepresentation;
    }

    @Override
    public Codec<Iterable> withUuidRepresentation(UuidRepresentation uuidRepresentation) {
        return new IterableCodec(this.registry, this.bsonTypeCodecMap, this.valueTransformer, uuidRepresentation);
    }

    @Override
    public Iterable decode(BsonReader reader, DecoderContext decoderContext) {
        reader.readStartArray();
        ArrayList<Object> list = new ArrayList<Object>();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            list.add(this.readValue(reader, decoderContext));
        }
        reader.readEndArray();
        return list;
    }

    @Override
    public void encode(BsonWriter writer, Iterable value, EncoderContext encoderContext) {
        writer.writeStartArray();
        for (Object cur : value) {
            this.writeValue(writer, encoderContext, cur);
        }
        writer.writeEndArray();
    }

    @Override
    public Class<Iterable> getEncoderClass() {
        return Iterable.class;
    }

    private void writeValue(BsonWriter writer, EncoderContext encoderContext, Object value) {
        if (value == null) {
            writer.writeNull();
        } else {
            Codec<?> codec = this.registry.get(value.getClass());
            encoderContext.encodeWithChildContext(codec, writer, value);
        }
    }

    private Object readValue(BsonReader reader, DecoderContext decoderContext) {
        BsonType bsonType = reader.getCurrentBsonType();
        if (bsonType == BsonType.NULL) {
            reader.readNull();
            return null;
        }
        Codec<Object> codec = this.bsonTypeCodecMap.get(bsonType);
        if (bsonType == BsonType.BINARY && reader.peekBinarySize() == 16) {
            switch (reader.peekBinarySubType()) {
                case 3: {
                    if (this.uuidRepresentation != UuidRepresentation.JAVA_LEGACY && this.uuidRepresentation != UuidRepresentation.C_SHARP_LEGACY && this.uuidRepresentation != UuidRepresentation.PYTHON_LEGACY) break;
                    codec = this.registry.get(UUID.class);
                    break;
                }
                case 4: {
                    if (this.uuidRepresentation != UuidRepresentation.JAVA_LEGACY && this.uuidRepresentation != UuidRepresentation.STANDARD) break;
                    codec = this.registry.get(UUID.class);
                    break;
                }
            }
        }
        return this.valueTransformer.transform(codec.decode(reader, decoderContext));
    }
}

