/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.XLeaderBoards.libs.mongodb;

import io.github.InsiderAnh.XLeaderBoards.libs.bson.BsonDocument;
import io.github.InsiderAnh.XLeaderBoards.libs.bson.BsonDocumentReader;
import io.github.InsiderAnh.XLeaderBoards.libs.bson.codecs.Decoder;
import io.github.InsiderAnh.XLeaderBoards.libs.bson.codecs.DecoderContext;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.AcknowledgedBulkWriteResult;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.BulkWriteError;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.BulkWriteException;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.BulkWriteUpsert;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.DBObject;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.DBObjects;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.MongoBulkWriteException;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.UnacknowledgedBulkWriteResult;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.WriteConcernError;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.bulk.BulkWriteResult;
import java.util.ArrayList;
import java.util.List;

final class BulkWriteHelper {
    static io.github.InsiderAnh.XLeaderBoards.libs.mongodb.BulkWriteResult translateBulkWriteResult(BulkWriteResult bulkWriteResult, Decoder<DBObject> decoder) {
        if (bulkWriteResult.wasAcknowledged()) {
            return new AcknowledgedBulkWriteResult(bulkWriteResult.getInsertedCount(), bulkWriteResult.getMatchedCount(), bulkWriteResult.getDeletedCount(), bulkWriteResult.getModifiedCount(), BulkWriteHelper.translateBulkWriteUpserts(bulkWriteResult.getUpserts(), decoder));
        }
        return new UnacknowledgedBulkWriteResult();
    }

    static List<BulkWriteUpsert> translateBulkWriteUpserts(List<io.github.InsiderAnh.XLeaderBoards.libs.mongodb.bulk.BulkWriteUpsert> upserts, Decoder<DBObject> decoder) {
        ArrayList<BulkWriteUpsert> retVal = new ArrayList<BulkWriteUpsert>(upserts.size());
        for (io.github.InsiderAnh.XLeaderBoards.libs.mongodb.bulk.BulkWriteUpsert cur : upserts) {
            retVal.add(new BulkWriteUpsert(cur.getIndex(), BulkWriteHelper.getUpsertedId(cur, decoder)));
        }
        return retVal;
    }

    private static Object getUpsertedId(io.github.InsiderAnh.XLeaderBoards.libs.mongodb.bulk.BulkWriteUpsert cur, Decoder<DBObject> decoder) {
        return decoder.decode(new BsonDocumentReader(new BsonDocument("_id", cur.getId())), DecoderContext.builder().build()).get("_id");
    }

    static BulkWriteException translateBulkWriteException(MongoBulkWriteException e, Decoder<DBObject> decoder) {
        return new BulkWriteException(BulkWriteHelper.translateBulkWriteResult(e.getWriteResult(), decoder), BulkWriteHelper.translateWriteErrors(e.getWriteErrors()), BulkWriteHelper.translateWriteConcernError(e.getWriteConcernError()), e.getServerAddress());
    }

    static WriteConcernError translateWriteConcernError(io.github.InsiderAnh.XLeaderBoards.libs.mongodb.bulk.WriteConcernError writeConcernError) {
        return writeConcernError == null ? null : new WriteConcernError(writeConcernError.getCode(), writeConcernError.getMessage(), DBObjects.toDBObject(writeConcernError.getDetails()));
    }

    static List<BulkWriteError> translateWriteErrors(List<io.github.InsiderAnh.XLeaderBoards.libs.mongodb.bulk.BulkWriteError> errors) {
        ArrayList<BulkWriteError> retVal = new ArrayList<BulkWriteError>(errors.size());
        for (io.github.InsiderAnh.XLeaderBoards.libs.mongodb.bulk.BulkWriteError cur : errors) {
            retVal.add(new BulkWriteError(cur.getCode(), cur.getMessage(), DBObjects.toDBObject(cur.getDetails()), cur.getIndex()));
        }
        return retVal;
    }

    private BulkWriteHelper() {
    }
}

