/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.XLeaderBoards.libs.mongodb.operation;

import io.github.InsiderAnh.XLeaderBoards.libs.bson.BsonArray;
import io.github.InsiderAnh.XLeaderBoards.libs.bson.BsonDocument;
import io.github.InsiderAnh.XLeaderBoards.libs.bson.BsonInt32;
import io.github.InsiderAnh.XLeaderBoards.libs.bson.BsonString;
import io.github.InsiderAnh.XLeaderBoards.libs.bson.BsonValue;
import io.github.InsiderAnh.XLeaderBoards.libs.bson.codecs.Decoder;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.MongoNamespace;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.ServerAddress;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.assertions.Assertions;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.async.AsyncBatchCursor;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.async.SingleResultCallback;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.binding.AsyncConnectionSource;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.binding.AsyncReadBinding;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.binding.ConnectionSource;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.binding.ReadBinding;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.connection.AsyncConnection;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.connection.Connection;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.connection.ConnectionDescription;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.connection.QueryResult;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.connection.ServerDescription;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.internal.async.ErrorHandlingResultCallback;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.operation.AsyncQueryBatchCursor;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.operation.AsyncReadOperation;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.operation.BatchCursor;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.operation.CommandOperationHelper;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.operation.CommandResultDocumentCodec;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.operation.OperationHelper;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.operation.OperationReadConcernHelper;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.operation.QueryBatchCursor;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.operation.ReadOperation;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.session.SessionContext;
import java.util.ArrayList;
import java.util.List;

@Deprecated
public class ParallelCollectionScanOperation<T>
implements AsyncReadOperation<List<AsyncBatchCursor<T>>>,
ReadOperation<List<BatchCursor<T>>> {
    private final MongoNamespace namespace;
    private final int numCursors;
    private boolean retryReads;
    private int batchSize = 0;
    private final Decoder<T> decoder;

    public ParallelCollectionScanOperation(MongoNamespace namespace, int numCursors, Decoder<T> decoder) {
        this.namespace = Assertions.notNull("namespace", namespace);
        Assertions.isTrue("numCursors >= 1", numCursors >= 1);
        this.numCursors = numCursors;
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    public int getNumCursors() {
        return this.numCursors;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public ParallelCollectionScanOperation<T> batchSize(int batchSize) {
        Assertions.isTrue("batchSize >= 0", batchSize >= 0);
        this.batchSize = batchSize;
        return this;
    }

    public ParallelCollectionScanOperation<T> retryReads(boolean retryReads) {
        this.retryReads = retryReads;
        return this;
    }

    public boolean getRetryReads() {
        return this.retryReads;
    }

    @Override
    public List<BatchCursor<T>> execute(ReadBinding binding) {
        return CommandOperationHelper.executeCommand(binding, this.namespace.getDatabaseName(), this.getCommandCreator(binding.getSessionContext()), CommandResultDocumentCodec.create(this.decoder, "firstBatch"), this.transformer(), this.retryReads);
    }

    @Override
    public void executeAsync(AsyncReadBinding binding, SingleResultCallback<List<AsyncBatchCursor<T>>> callback) {
        CommandOperationHelper.executeCommandAsync(binding, this.namespace.getDatabaseName(), this.getCommandCreator(binding.getSessionContext()), CommandResultDocumentCodec.create(this.decoder, "firstBatch"), this.asyncTransformer(), this.retryReads, ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER));
    }

    private CommandOperationHelper.CommandReadTransformer<BsonDocument, List<BatchCursor<T>>> transformer() {
        return new CommandOperationHelper.CommandReadTransformer<BsonDocument, List<BatchCursor<T>>>(){

            @Override
            public List<BatchCursor<T>> apply(BsonDocument result, ConnectionSource source, Connection connection) {
                ArrayList cursors = new ArrayList();
                for (BsonValue cursorValue : ParallelCollectionScanOperation.this.getCursorDocuments(result)) {
                    cursors.add(new QueryBatchCursor(ParallelCollectionScanOperation.this.createQueryResult(ParallelCollectionScanOperation.this.getCursorDocument(cursorValue.asDocument()), source.getServerDescription().getAddress()), 0, ParallelCollectionScanOperation.this.getBatchSize(), ParallelCollectionScanOperation.this.decoder, source));
                }
                return cursors;
            }
        };
    }

    private CommandOperationHelper.CommandReadTransformerAsync<BsonDocument, List<AsyncBatchCursor<T>>> asyncTransformer() {
        return new CommandOperationHelper.CommandReadTransformerAsync<BsonDocument, List<AsyncBatchCursor<T>>>(){

            @Override
            public List<AsyncBatchCursor<T>> apply(BsonDocument result, AsyncConnectionSource source, AsyncConnection connection) {
                ArrayList cursors = new ArrayList();
                for (BsonValue cursorValue : ParallelCollectionScanOperation.this.getCursorDocuments(result)) {
                    cursors.add(new AsyncQueryBatchCursor(ParallelCollectionScanOperation.this.createQueryResult(ParallelCollectionScanOperation.this.getCursorDocument(cursorValue.asDocument()), source.getServerDescription().getAddress()), 0, ParallelCollectionScanOperation.this.getBatchSize(), 0L, ParallelCollectionScanOperation.this.decoder, source, connection, result));
                }
                return cursors;
            }
        };
    }

    private BsonArray getCursorDocuments(BsonDocument result) {
        return result.getArray("cursors");
    }

    private BsonDocument getCursorDocument(BsonDocument cursorDocument) {
        return cursorDocument.getDocument("cursor");
    }

    private QueryResult<T> createQueryResult(BsonDocument cursorDocument, ServerAddress serverAddress) {
        return OperationHelper.cursorDocumentToQueryResult(cursorDocument, serverAddress);
    }

    private CommandOperationHelper.CommandCreator getCommandCreator(final SessionContext sessionContext) {
        return new CommandOperationHelper.CommandCreator(){

            @Override
            public BsonDocument create(ServerDescription serverDescription, ConnectionDescription connectionDescription) {
                OperationHelper.validateReadConcern(connectionDescription, sessionContext.getReadConcern());
                return ParallelCollectionScanOperation.this.getCommand(sessionContext);
            }
        };
    }

    private BsonDocument getCommand(SessionContext sessionContext) {
        BsonDocument document = new BsonDocument("parallelCollectionScan", new BsonString(this.namespace.getCollectionName())).append("numCursors", new BsonInt32(this.getNumCursors()));
        OperationReadConcernHelper.appendReadConcernToCommand(sessionContext, document);
        return document;
    }
}

