/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.XLeaderBoards.placeholders;

import io.github.InsiderAnh.XLeaderBoards.XLeaderBoard;
import io.github.InsiderAnh.XLeaderBoards.api.LeaderSession;
import io.github.InsiderAnh.XLeaderBoards.data.PlayerRanking;
import io.github.InsiderAnh.XLeaderBoards.data.PlayerTopper;
import io.github.InsiderAnh.XLeaderBoards.libs.bson.Document;
import io.github.InsiderAnh.XLeaderBoards.utils.LeaderUtils;
import java.util.concurrent.atomic.AtomicReference;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TopPlaceholders
extends PlaceholderExpansion {
    private final XLeaderBoard plugin = XLeaderBoard.getInstance();

    @NotNull
    public String getIdentifier() {
        return "xleaderboard";
    }

    @NotNull
    public String getAuthor() {
        return "InsiderAnh";
    }

    @NotNull
    public String getVersion() {
        return "1.0.0";
    }

    public boolean persist() {
        return true;
    }

    @Nullable
    public String onPlaceholderRequest(Player player, @NotNull String placeholder) {
        PlayerTopper playerTopper = this.plugin.getPlayerManager().getPlayerTopper(player.getUniqueId());
        PlayerRanking playerRanking = this.plugin.getPlayerManager().getPlayerRanking(player.getUniqueId());
        if (placeholder.equals("time")) {
            LeaderSession leaderSession = LeaderSession.get(player.getUniqueId());
            if (leaderSession != null) {
                return this.plugin.getLang().getString("tops.hologram." + leaderSession.getTopTime());
            }
            return "";
        }
        if (placeholder.startsWith("amount")) {
            String[] data = placeholder.replaceFirst("amount_", "").split("_", 2);
            AtomicReference<String> timeType = new AtomicReference<String>(data[0]);
            String topName = data[1];
            LeaderSession leaderSession = LeaderSession.get(player.getUniqueId());
            if (timeType.get().equals("placeholder") && leaderSession != null) {
                timeType.set(leaderSession.getTopTime());
            }
            switch (timeType.get()) {
                case "daily": {
                    if (playerTopper != null) {
                        return LeaderUtils.formatNumber(playerTopper.getDaily().getOrDefault(topName, 0.0));
                    }
                    return "0";
                }
                case "weekly": {
                    if (playerTopper != null) {
                        return LeaderUtils.formatNumber(playerTopper.getWeekly().getOrDefault(topName, 0.0));
                    }
                    return "0";
                }
                case "monthly": {
                    if (playerTopper != null) {
                        return LeaderUtils.formatNumber(playerTopper.getMonthly().getOrDefault(topName, 0.0));
                    }
                    return "0";
                }
                case "permanent": {
                    if (playerTopper != null) {
                        return LeaderUtils.formatNumber(playerTopper.getPermanent().getOrDefault(topName, 0.0));
                    }
                    return "0";
                }
            }
            return "0";
        }
        if (placeholder.startsWith("ranking_")) {
            if (playerTopper != null) {
                String totalPlaceholder;
                long ranking;
                String[] data = placeholder.replaceFirst("ranking_", "").split("_", 2);
                AtomicReference<String> timeType = new AtomicReference<String>(data[0]);
                String topName = data[1];
                LeaderSession leaderSession = LeaderSession.get(player.getUniqueId());
                if (timeType.get().equals("placeholder") && leaderSession != null) {
                    timeType.set(leaderSession.getTopTime());
                }
                if ((ranking = playerRanking.getRanking(totalPlaceholder = timeType.get() + "_" + topName)) < 0L) {
                    return this.plugin.getLang().getString("tops.noRanking");
                }
                return String.valueOf(playerRanking.getRanking(totalPlaceholder));
            }
            return "No ranking";
        }
        if (placeholder.startsWith("top_")) {
            Document document;
            String[] data = placeholder.replaceFirst("top_", "").split(";", 4);
            String topName = data[0];
            AtomicReference<String> timeType = new AtomicReference<String>(data[1]);
            String dataType = data[2];
            int index = Integer.parseInt(data[3]);
            LeaderSession leaderSession = LeaderSession.get(player.getUniqueId());
            if (timeType.get().equals("placeholder") && leaderSession != null) {
                timeType.set(leaderSession.getTopTime());
            }
            if ((document = this.plugin.getTopManager().getTops().get(timeType.get() + "_" + topName)) == null) {
                return "No exists " + timeType.get() + " " + topName;
            }
            Document topDocument = (Document)document.get(String.valueOf(index));
            switch (dataType) {
                case "top_name": {
                    if (topDocument == null) {
                        return "Cargando...";
                    }
                    return topDocument.getString("name");
                }
                case "top_value": {
                    if (topDocument == null) {
                        return this.plugin.getLang().getString("tops.noTop");
                    }
                    Object amount = topDocument.get("amount");
                    if (amount instanceof Double) {
                        return LeaderUtils.formatNumber(topDocument.getDouble("amount"));
                    }
                    if (amount instanceof Integer) {
                        return String.valueOf(topDocument.getInteger("amount"));
                    }
                    if (amount instanceof Long) {
                        return String.valueOf(topDocument.getLong("amount"));
                    }
                    return "0";
                }
                case "top_uuid": {
                    if (topDocument == null) {
                        return "3e0195dc-a963-4ede-98bd-b4ab63dfa48a";
                    }
                    return topDocument.getString("uuid");
                }
            }
        }
        return null;
    }
}

