/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.XLeaderBoards.libs.mongodb.client.internal;

import io.github.InsiderAnh.XLeaderBoards.libs.bson.BsonBinary;
import io.github.InsiderAnh.XLeaderBoards.libs.bson.BsonDocument;
import io.github.InsiderAnh.XLeaderBoards.libs.bson.BsonValue;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.ClientEncryptionSettings;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.MongoNamespace;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.WriteConcern;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.client.MongoClient;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.client.MongoClients;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.client.internal.Crypt;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.client.internal.Crypts;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.client.internal.SimpleMongoClients;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.client.model.vault.DataKeyOptions;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.client.model.vault.EncryptOptions;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.client.vault.ClientEncryption;
import java.io.Closeable;

public class ClientEncryptionImpl
implements ClientEncryption,
Closeable {
    private final Crypt crypt;
    private final ClientEncryptionSettings options;
    private final MongoClient keyVaultClient;

    public ClientEncryptionImpl(ClientEncryptionSettings options) {
        this.keyVaultClient = MongoClients.create(options.getKeyVaultMongoClientSettings());
        this.crypt = Crypts.create(SimpleMongoClients.create(this.keyVaultClient), options);
        this.options = options;
    }

    @Override
    public BsonBinary createDataKey(String kmsProvider) {
        return this.createDataKey(kmsProvider, new DataKeyOptions());
    }

    @Override
    public BsonBinary createDataKey(String kmsProvider, DataKeyOptions dataKeyOptions) {
        BsonDocument dataKeyDocument = this.crypt.createDataKey(kmsProvider, dataKeyOptions);
        MongoNamespace namespace = new MongoNamespace(this.options.getKeyVaultNamespace());
        this.keyVaultClient.getDatabase(namespace.getDatabaseName()).getCollection(namespace.getCollectionName(), BsonDocument.class).withWriteConcern(WriteConcern.MAJORITY).insertOne(dataKeyDocument);
        return dataKeyDocument.getBinary("_id");
    }

    @Override
    public BsonBinary encrypt(BsonValue value, EncryptOptions options) {
        return this.crypt.encryptExplicitly(value, options);
    }

    @Override
    public BsonValue decrypt(BsonBinary value) {
        return this.crypt.decryptExplicitly(value);
    }

    @Override
    public void close() {
        this.crypt.close();
        this.keyVaultClient.close();
    }
}

