/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.XLeaderBoards.libs.mongodb.internal.event;

import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.assertions.Assertions;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.diagnostics.logging.Logger;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.diagnostics.logging.Loggers;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.event.ServerHeartbeatFailedEvent;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.event.ServerHeartbeatStartedEvent;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.event.ServerHeartbeatSucceededEvent;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.event.ServerMonitorListener;
import java.util.ArrayList;
import java.util.List;

final class ServerMonitorListenerMulticaster
implements ServerMonitorListener {
    private static final Logger LOGGER = Loggers.getLogger("cluster.event");
    private final List<ServerMonitorListener> serverMonitorListeners;

    ServerMonitorListenerMulticaster(List<ServerMonitorListener> serverMonitorListeners) {
        Assertions.isTrue("All ServerMonitorListener instances are non-null", !serverMonitorListeners.contains(null));
        this.serverMonitorListeners = new ArrayList<ServerMonitorListener>(serverMonitorListeners);
    }

    @Override
    public void serverHearbeatStarted(ServerHeartbeatStartedEvent event) {
        for (ServerMonitorListener cur : this.serverMonitorListeners) {
            try {
                cur.serverHearbeatStarted(event);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising server heartbeat started event to listener %s", cur), e);
            }
        }
    }

    @Override
    public void serverHeartbeatSucceeded(ServerHeartbeatSucceededEvent event) {
        for (ServerMonitorListener cur : this.serverMonitorListeners) {
            try {
                cur.serverHeartbeatSucceeded(event);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising server heartbeat succeeded event to listener %s", cur), e);
            }
        }
    }

    @Override
    public void serverHeartbeatFailed(ServerHeartbeatFailedEvent event) {
        for (ServerMonitorListener cur : this.serverMonitorListeners) {
            try {
                cur.serverHeartbeatFailed(event);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising server heartbeat failed event to listener %s", cur), e);
            }
        }
    }
}

