/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.XLeaderBoards.commands;

import io.github.InsiderAnh.XLeaderBoards.XLeaderBoard;
import io.github.InsiderAnh.XLeaderBoards.tops.CustomTop;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class CustomTopCMD
implements CommandExecutor,
TabCompleter {
    private final XLeaderBoard plugin = XLeaderBoard.getInstance();
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("xleaderboards.admin")) {
            sender.sendMessage(this.plugin.getLang().getString("customTops.noPermission"));
            return true;
        }
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "create": {
                return this.handleCreate(sender, args);
            }
            case "delete": 
            case "remove": {
                return this.handleDelete(sender, args);
            }
            case "list": {
                return this.handleList(sender);
            }
            case "info": {
                return this.handleInfo(sender, args);
            }
            case "update": 
            case "forceupdate": {
                return this.handleForceUpdate(sender, args);
            }
            case "end": 
            case "finish": {
                return this.handleEnd(sender, args);
            }
            case "setresettime": {
                return this.handleSetResetTime(sender, args);
            }
        }
        this.sendHelp(sender);
        return true;
    }

    private boolean handleCreate(CommandSender sender, String[] args) {
        if (args.length < 6) {
            sender.sendMessage(this.plugin.getLang().getString("customTops.create.usage"));
            sender.sendMessage(this.plugin.getLang().getString("customTops.create.timeFormat"));
            sender.sendMessage(this.plugin.getLang().getString("customTops.create.example"));
            return true;
        }
        String id = args[1];
        String topName = args[2];
        String displayName = args[3];
        String startTimeStr = args[4];
        String endTimeStr = args[5];
        int updateInterval = args.length > 6 ? Integer.parseInt(args[6]) : 30;
        try {
            long startTime = this.dateFormat.parse(startTimeStr).getTime();
            long endTime = this.dateFormat.parse(endTimeStr).getTime();
            if (endTime <= startTime) {
                sender.sendMessage(this.plugin.getLang().getString("customTops.create.endBeforeStart"));
                return true;
            }
            this.plugin.getCustomTopManager().createCustomTop(id, topName, displayName, startTime, endTime, updateInterval);
            sender.sendMessage(this.plugin.getLang().getString("customTops.create.success"));
            sender.sendMessage(this.plugin.getLang().getString("customTops.create.idLabel").replace("{id}", id));
            sender.sendMessage(this.plugin.getLang().getString("customTops.create.nameLabel").replace("{name}", topName));
            sender.sendMessage(this.plugin.getLang().getString("customTops.create.displayLabel").replace("{display}", displayName));
            sender.sendMessage(this.plugin.getLang().getString("customTops.create.startLabel").replace("{start}", startTimeStr));
            sender.sendMessage(this.plugin.getLang().getString("customTops.create.endLabel").replace("{end}", endTimeStr));
            sender.sendMessage(this.plugin.getLang().getString("customTops.create.intervalLabel").replace("{interval}", String.valueOf(updateInterval)));
        }
        catch (Exception e) {
            sender.sendMessage(this.plugin.getLang().getString("customTops.create.error").replace("{error}", e.getMessage()));
            sender.sendMessage(this.plugin.getLang().getString("customTops.create.verifyFormat"));
        }
        return true;
    }

    private boolean handleDelete(CommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage(this.plugin.getLang().getString("customTops.delete.usage"));
            return true;
        }
        String id = args[1];
        CustomTop customTop = this.plugin.getCustomTopManager().getCustomTops().get(id);
        if (customTop == null) {
            sender.sendMessage(this.plugin.getLang().getString("customTops.notFound").replace("{id}", id));
            return true;
        }
        this.plugin.getCustomTopManager().deleteCustomTop(id);
        sender.sendMessage(this.plugin.getLang().getString("customTops.delete.success").replace("{id}", id));
        return true;
    }

    private boolean handleList(CommandSender sender) {
        if (this.plugin.getCustomTopManager().getCustomTops().isEmpty()) {
            sender.sendMessage(this.plugin.getLang().getString("customTops.list.empty"));
            return true;
        }
        sender.sendMessage(this.plugin.getLang().getString("customTops.list.header"));
        for (CustomTop customTop : this.plugin.getCustomTopManager().getCustomTops().values()) {
            String status = customTop.isActive() ? this.plugin.getLang().getString("customTops.active") : (customTop.hasFinished() ? this.plugin.getLang().getString("customTops.finished") : this.plugin.getLang().getString("customTops.upcoming"));
            String message = this.plugin.getLang().getString("customTops.list.format").replace("{id}", customTop.getId()).replace("{display}", customTop.getDisplayName()).replace("{status}", status);
            sender.sendMessage(message);
        }
        sender.sendMessage(this.plugin.getLang().getString("customTops.list.footer"));
        return true;
    }

    private boolean handleInfo(CommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage(this.plugin.getLang().getString("customTops.info.usage"));
            return true;
        }
        String id = args[1];
        CustomTop customTop = this.plugin.getCustomTopManager().getCustomTops().get(id);
        if (customTop == null) {
            sender.sendMessage(this.plugin.getLang().getString("customTops.notFound").replace("{id}", id));
            return true;
        }
        sender.sendMessage(this.plugin.getLang().getString("customTops.info.header").replace("{id}", customTop.getId()));
        sender.sendMessage(this.plugin.getLang().getString("customTops.info.name").replace("{name}", customTop.getName()));
        sender.sendMessage(this.plugin.getLang().getString("customTops.info.display").replace("{display}", customTop.getDisplayName()));
        sender.sendMessage(this.plugin.getLang().getString("customTops.info.start").replace("{start}", this.dateFormat.format(customTop.getStartTime())));
        sender.sendMessage(this.plugin.getLang().getString("customTops.info.end").replace("{end}", this.dateFormat.format(customTop.getEndTime())));
        String activeStr = customTop.isActive() ? this.plugin.getLang().getString("customTops.info.yes") : this.plugin.getLang().getString("customTops.info.no");
        String finishedStr = customTop.hasFinished() ? this.plugin.getLang().getString("customTops.info.yes") : this.plugin.getLang().getString("customTops.info.no");
        String rewardsStr = customTop.isRewardsGiven() ? this.plugin.getLang().getString("customTops.info.yes") : this.plugin.getLang().getString("customTops.info.no");
        sender.sendMessage(this.plugin.getLang().getString("customTops.info.active").replace("{active}", activeStr));
        sender.sendMessage(this.plugin.getLang().getString("customTops.info.finished").replace("{finished}", finishedStr));
        sender.sendMessage(this.plugin.getLang().getString("customTops.info.rewardsGiven").replace("{rewards}", rewardsStr));
        sender.sendMessage(this.plugin.getLang().getString("customTops.info.interval").replace("{interval}", String.valueOf(customTop.getUpdateIntervalMinutes())));
        if (customTop.isActive()) {
            long remaining = customTop.getRemainingTime();
            sender.sendMessage(this.plugin.getLang().getString("customTops.info.remaining").replace("{time}", this.formatTime(remaining)));
        } else if (!customTop.hasFinished()) {
            long until = customTop.getTimeUntilStart();
            sender.sendMessage(this.plugin.getLang().getString("customTops.info.untilStart").replace("{time}", this.formatTime(until)));
        }
        return true;
    }

    private boolean handleForceUpdate(CommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage(this.plugin.getLang().getString("customTops.update.usage"));
            return true;
        }
        String id = args[1];
        CustomTop customTop = this.plugin.getCustomTopManager().getCustomTops().get(id);
        if (customTop == null) {
            sender.sendMessage(this.plugin.getLang().getString("customTops.notFound").replace("{id}", id));
            return true;
        }
        if (!customTop.isActive()) {
            sender.sendMessage(this.plugin.getLang().getString("customTops.update.notActive"));
            return true;
        }
        this.plugin.getCustomTopManager().forceUpdateCustomTop(id);
        sender.sendMessage(this.plugin.getLang().getString("customTops.update.success").replace("{id}", id));
        return true;
    }

    private boolean handleEnd(CommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage(this.plugin.getLang().getString("customTops.end.usage"));
            return true;
        }
        String id = args[1];
        boolean giveRewards = args.length > 2 && args[2].equalsIgnoreCase("true");
        CustomTop customTop = this.plugin.getCustomTopManager().getCustomTops().get(id);
        if (customTop == null) {
            sender.sendMessage(this.plugin.getLang().getString("customTops.notFound").replace("{id}", id));
            return true;
        }
        if (!customTop.isActive()) {
            sender.sendMessage(this.plugin.getLang().getString("customTops.update.notActive"));
            return true;
        }
        this.plugin.getCustomTopManager().forceEndCustomTop(id, giveRewards);
        sender.sendMessage(this.plugin.getLang().getString("customTops.end.success").replace("{id}", id));
        sender.sendMessage(giveRewards ? this.plugin.getLang().getString("customTops.end.rewardsGiven") : this.plugin.getLang().getString("customTops.end.rewardsNotGiven"));
        return true;
    }

    private boolean handleSetResetTime(CommandSender sender, String[] args) {
        if (args.length < 3) {
            sender.sendMessage(this.plugin.getLang().getString("resetTime.setResetTime.usage"));
            sender.sendMessage(this.plugin.getLang().getString("resetTime.setResetTime.timeFormat"));
            sender.sendMessage(this.plugin.getLang().getString("resetTime.setResetTime.example"));
            return true;
        }
        String period = args[1].toLowerCase();
        String time = args[2];
        if (!(period.equals("daily") || period.equals("weekly") || period.equals("monthly"))) {
            sender.sendMessage(this.plugin.getLang().getString("resetTime.setResetTime.invalidPeriod"));
            return true;
        }
        if (!time.matches("\\d{2}:\\d{2}:\\d{2}")) {
            sender.sendMessage(this.plugin.getLang().getString("resetTime.setResetTime.invalidFormat"));
            return true;
        }
        this.plugin.getConfig().set("topResets." + period + ".time", (Object)time);
        this.plugin.saveConfig();
        this.plugin.getConfigManager().load();
        sender.sendMessage(this.plugin.getLang().getString("resetTime.setResetTime.success"));
        sender.sendMessage(this.plugin.getLang().getString("resetTime.setResetTime.periodLabel").replace("{period}", period));
        sender.sendMessage(this.plugin.getLang().getString("resetTime.setResetTime.newTimeLabel").replace("{time}", time));
        sender.sendMessage(this.plugin.getLang().getString("resetTime.setResetTime.nextCycle"));
        return true;
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage(this.plugin.getLang().getString("customTops.help.header"));
        sender.sendMessage(this.plugin.getLang().getString("customTops.help.create"));
        sender.sendMessage(this.plugin.getLang().getString("customTops.help.delete"));
        sender.sendMessage(this.plugin.getLang().getString("customTops.help.list"));
        sender.sendMessage(this.plugin.getLang().getString("customTops.help.info"));
        sender.sendMessage(this.plugin.getLang().getString("customTops.help.update"));
        sender.sendMessage(this.plugin.getLang().getString("customTops.help.end"));
    }

    private String formatTime(long millis) {
        long days = millis / 86400000L;
        long hours = millis % 86400000L / 3600000L;
        long minutes = millis % 3600000L / 60000L;
        if (days > 0L) {
            return days + "d " + hours + "h " + minutes + "m";
        }
        if (hours > 0L) {
            return hours + "h " + minutes + "m";
        }
        return minutes + "m";
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!sender.hasPermission("xleaderboards.admin")) {
            return new ArrayList<String>();
        }
        if (args.length == 1) {
            return Arrays.asList("create", "delete", "list", "info", "update", "end", "setresettime").stream().filter(s -> s.startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("delete") || args[0].equalsIgnoreCase("info") || args[0].equalsIgnoreCase("update") || args[0].equalsIgnoreCase("end")) {
                return new ArrayList<String>(this.plugin.getCustomTopManager().getCustomTops().keySet());
            }
            if (args[0].equalsIgnoreCase("setresettime")) {
                return Arrays.asList("daily", "weekly", "monthly");
            }
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("end")) {
            return Arrays.asList("true", "false");
        }
        return new ArrayList<String>();
    }
}

