/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.XLeaderBoards.commands;

import io.github.InsiderAnh.XLeaderBoards.XLeaderBoard;
import io.github.InsiderAnh.XLeaderBoards.commands.StellarArgument;
import io.github.InsiderAnh.XLeaderBoards.commands.StellarCompleter;
import io.github.InsiderAnh.XLeaderBoards.commands.arguments.ForceResetArgument;
import io.github.InsiderAnh.XLeaderBoards.commands.arguments.ForceUpdateArgument;
import io.github.InsiderAnh.XLeaderBoards.commands.arguments.GetTopArgument;
import io.github.InsiderAnh.XLeaderBoards.commands.arguments.ReloadArgument;
import io.github.InsiderAnh.XLeaderBoards.commands.arguments.SetResetTimeArgument;
import io.github.InsiderAnh.XLeaderBoards.commands.arguments.VersionArgument;
import io.github.InsiderAnh.XLeaderBoards.commands.completers.ForceResetCompleter;
import io.github.InsiderAnh.XLeaderBoards.commands.completers.ForceUpdateCompleter;
import io.github.InsiderAnh.XLeaderBoards.commands.completers.GetTopCompleter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;

public class XLeaderboardCMD
implements TabExecutor {
    private final XLeaderBoard plugin = XLeaderBoard.getInstance();
    private final HashMap<String, StellarArgument> arguments = new HashMap();
    private final HashMap<String, StellarCompleter> completes = new HashMap();

    public XLeaderboardCMD() {
        this.arguments.put("gettop", new GetTopArgument());
        this.arguments.put("forceupdate", new ForceUpdateArgument());
        this.arguments.put("forcereset", new ForceResetArgument());
        this.arguments.put("reload", new ReloadArgument());
        this.arguments.put("version", new VersionArgument());
        this.arguments.put("setresettime", new SetResetTimeArgument());
        this.completes.put("gettop", new GetTopCompleter());
        this.completes.put("forceupdate", new ForceUpdateCompleter());
        this.completes.put("forcereset", new ForceResetCompleter());
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!sender.hasPermission("xleaderboards.use")) {
            sender.sendMessage(this.plugin.getLang().getString("tops.noPermission"));
            return true;
        }
        if (args.length < 1) {
            this.sendHelp(sender);
            return false;
        }
        switch (args[0].toLowerCase()) {
            case "gettop": {
                this.arguments.get("gettop").onCommand(sender, Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            case "forcereset": {
                this.arguments.get("forcereset").onCommand(sender, Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            case "forceupdate": {
                this.arguments.get("forceupdate").onCommand(sender, Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            case "version": {
                this.arguments.get("version").onCommand(sender, Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            case "reload": {
                this.arguments.get("reload").onCommand(sender, Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            case "setresettime": {
                this.arguments.get("setresettime").onCommand(sender, Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            default: {
                this.sendHelp(sender);
            }
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length <= 1) {
            return Arrays.asList("gettop", "forceupdate", "forcereset", "help", "reload", "setresettime");
        }
        switch (args[0].toLowerCase()) {
            case "gettop": {
                return this.completes.get("gettop").onTabComplete(sender, Arrays.copyOfRange(args, 1, args.length));
            }
            case "forcereset": {
                return this.completes.get("forcereset").onTabComplete(sender, Arrays.copyOfRange(args, 1, args.length));
            }
            case "forceupdate": {
                return this.completes.get("forceupdate").onTabComplete(sender, Arrays.copyOfRange(args, 1, args.length));
            }
            case "setresettime": {
                if (args.length != 2) break;
                return Arrays.asList("daily", "weekly", "monthly");
            }
        }
        return Collections.emptyList();
    }

    void sendHelp(CommandSender sender) {
        sender.sendMessage(ChatColor.GRAY + "" + ChatColor.STRIKETHROUGH + "+---------------------------------------+");
        sender.sendMessage(ChatColor.DARK_GRAY + "[!] " + ChatColor.RED + "XLeaderBoards " + ChatColor.DARK_GRAY + "[!]");
        sender.sendMessage(ChatColor.GRAY + "" + ChatColor.STRIKETHROUGH + "+---------------------------------------+");
        if (sender.hasPermission("xleaderboards.forcereset")) {
            sender.sendMessage(ChatColor.YELLOW + "/xlb forcereset daily/weekly/monthly " + ChatColor.GRAY + "- " + ChatColor.WHITE + "Forces the reset of the top.");
        }
        if (sender.hasPermission("xleaderboards.gettop")) {
            sender.sendMessage(ChatColor.YELLOW + "/xlb gettop daily/weekly/monthly/permanent <topName> " + ChatColor.GRAY + "- " + ChatColor.WHITE + "Gets the top of the day, week, month or permanent.");
        }
        if (sender.hasPermission("xleaderboards.forceupdate")) {
            sender.sendMessage(ChatColor.YELLOW + "/xlb forceupdate daily/weekly/monthly/permanent " + ChatColor.GRAY + "- " + ChatColor.WHITE + "Forces the update of the top.");
        }
        if (sender.hasPermission("xleaderboards.setresettime")) {
            sender.sendMessage(ChatColor.YELLOW + "/xlb setresettime <period> <time> " + ChatColor.GRAY + "- " + ChatColor.WHITE + "Change reset time for tops.");
        }
        if (sender.hasPermission("xleaderboards.reload")) {
            sender.sendMessage(ChatColor.YELLOW + "/xlb reload " + ChatColor.GRAY + "- " + ChatColor.WHITE + "Reload the plugin.");
        }
        sender.sendMessage(ChatColor.YELLOW + "/xlb version " + ChatColor.GRAY + "- " + ChatColor.WHITE + "Show the plugin version.");
        sender.sendMessage(ChatColor.YELLOW + "/xlb help " + ChatColor.GRAY + "- " + ChatColor.WHITE + "Show this help.");
    }
}

