/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.XLeaderBoards.commands.arguments;

import io.github.InsiderAnh.XLeaderBoards.XLeaderBoard;
import io.github.InsiderAnh.XLeaderBoards.commands.StellarArgument;
import org.bukkit.command.CommandSender;

public class SetResetTimeArgument
extends StellarArgument {
    private final XLeaderBoard plugin = XLeaderBoard.getInstance();

    @Override
    public void onCommand(CommandSender sender, String[] args) {
        if (!sender.hasPermission("xleaderboards.setresettime")) {
            sender.sendMessage(this.plugin.getLang().getString("messages.noPermission"));
            return;
        }
        if (args.length < 2) {
            sender.sendMessage(this.plugin.getLang().getString("resetTime.setResetTime.usage"));
            sender.sendMessage(this.plugin.getLang().getString("resetTime.setResetTime.timeFormat"));
            sender.sendMessage(this.plugin.getLang().getString("resetTime.setResetTime.example"));
            return;
        }
        String period = args[0].toLowerCase();
        String time = args[1];
        if (!(period.equals("daily") || period.equals("weekly") || period.equals("monthly"))) {
            sender.sendMessage(this.plugin.getLang().getString("resetTime.setResetTime.invalidPeriod"));
            return;
        }
        if (!time.matches("\\d{2}:\\d{2}:\\d{2}")) {
            sender.sendMessage(this.plugin.getLang().getString("resetTime.setResetTime.invalidFormat"));
            return;
        }
        this.plugin.getConfig().set("topResets." + period + ".time", (Object)time);
        this.plugin.saveConfig();
        this.plugin.getConfigManager().load();
        sender.sendMessage(this.plugin.getLang().getString("resetTime.setResetTime.success"));
        sender.sendMessage(this.plugin.getLang().getString("resetTime.setResetTime.periodLabel").replace("{period}", period));
        sender.sendMessage(this.plugin.getLang().getString("resetTime.setResetTime.newTimeLabel").replace("{time}", time));
        sender.sendMessage(this.plugin.getLang().getString("resetTime.setResetTime.nextCycle"));
    }
}

