/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.XLeaderBoards.libs.mongodb.connection;

import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.ServerAddress;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.assertions.Assertions;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.connection.BufferProvider;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.connection.SocketSettings;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.connection.SslSettings;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.connection.Stream;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.connection.StreamFactory;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.internal.connection.AsynchronousSocketChannelStream;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.internal.connection.PowerOfTwoBufferPool;
import java.nio.channels.AsynchronousChannelGroup;

public class AsynchronousSocketChannelStreamFactory
implements StreamFactory {
    private final BufferProvider bufferProvider = new PowerOfTwoBufferPool();
    private final SocketSettings settings;
    private final AsynchronousChannelGroup group;

    public AsynchronousSocketChannelStreamFactory(SocketSettings settings, SslSettings sslSettings) {
        this(settings, sslSettings, null);
    }

    public AsynchronousSocketChannelStreamFactory(SocketSettings settings, SslSettings sslSettings, AsynchronousChannelGroup group) {
        if (sslSettings.isEnabled()) {
            throw new UnsupportedOperationException("No SSL support in java.nio.channels.AsynchronousSocketChannel. For SSL support use com.mongodb.connection.netty.NettyStreamFactoryFactory");
        }
        this.settings = Assertions.notNull("settings", settings);
        this.group = group;
    }

    @Override
    public Stream create(ServerAddress serverAddress) {
        return new AsynchronousSocketChannelStream(serverAddress, this.settings, this.bufferProvider, this.group);
    }
}

