/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.XLeaderBoards.managers;

import io.github.InsiderAnh.XLeaderBoards.XLeaderBoard;
import lombok.Generated;

public class ConfigManager {
    private boolean debug;
    private int maxBulkSize;
    private int maxCachedTopEntries;
    private int ticksBetweenUpdates;
    private int maxResetBulkSize;
    private int dailyMinutes;
    private int weeklyMinutes;
    private int monthlyHours;
    private int permanentHours;
    private boolean checkUpdates;
    private String databaseType;
    private boolean saveTopOnUpdate;
    private String dailyResetTime;
    private String weeklyResetTime;
    private String monthlyResetTime;
    private String weeklyResetDay;
    private Integer monthlyResetDay;
    private String dailyResetTimezone;
    private String weeklyResetTimezone;
    private String monthlyResetTimezone;

    public void load() {
        XLeaderBoard plugin = XLeaderBoard.getInstance();
        this.checkUpdates = plugin.getConfig().getBoolean("check-updates");
        this.debug = plugin.getConfig().getBoolean("debug");
        this.maxBulkSize = plugin.getConfig().getInt("optimizations.max-bulk-size");
        this.maxCachedTopEntries = plugin.getConfig().getInt("optimizations.cached-top-entries");
        this.ticksBetweenUpdates = plugin.getConfig().getInt("optimizations.ticks-between-updates");
        this.maxResetBulkSize = plugin.getConfig().getInt("optimizations.max-reset-bulk-size");
        this.dailyMinutes = plugin.getConfig().getInt("topUpdates.daily.minutes");
        this.weeklyMinutes = plugin.getConfig().getInt("topUpdates.weekly.minutes");
        this.monthlyHours = plugin.getConfig().getInt("topUpdates.monthly.hours");
        this.permanentHours = plugin.getConfig().getInt("topUpdates.permanent.hours");
        this.saveTopOnUpdate = plugin.getConfig().getBoolean("optimizations.save-top-on-update");
        this.databaseType = plugin.getConfig().getString("databases.type");
        this.dailyResetTime = plugin.getConfig().getString("topResets.daily.time", "17:00:00");
        this.weeklyResetTime = plugin.getConfig().getString("topResets.weekly.time", "17:00:00");
        this.monthlyResetTime = plugin.getConfig().getString("topResets.monthly.time", "17:00:00");
        this.weeklyResetDay = plugin.getConfig().getString("topResets.weekly.day", null);
        this.monthlyResetDay = plugin.getConfig().isSet("topResets.monthly.day") ? Integer.valueOf(plugin.getConfig().getInt("topResets.monthly.day")) : null;
        this.dailyResetTimezone = plugin.getConfig().getString("topResets.daily.timezone", null);
        this.weeklyResetTimezone = plugin.getConfig().getString("topResets.weekly.timezone", null);
        this.monthlyResetTimezone = plugin.getConfig().getString("topResets.monthly.timezone", null);
    }

    @Generated
    public boolean isDebug() {
        return this.debug;
    }

    @Generated
    public int getMaxBulkSize() {
        return this.maxBulkSize;
    }

    @Generated
    public int getMaxCachedTopEntries() {
        return this.maxCachedTopEntries;
    }

    @Generated
    public int getTicksBetweenUpdates() {
        return this.ticksBetweenUpdates;
    }

    @Generated
    public int getMaxResetBulkSize() {
        return this.maxResetBulkSize;
    }

    @Generated
    public int getDailyMinutes() {
        return this.dailyMinutes;
    }

    @Generated
    public int getWeeklyMinutes() {
        return this.weeklyMinutes;
    }

    @Generated
    public int getMonthlyHours() {
        return this.monthlyHours;
    }

    @Generated
    public int getPermanentHours() {
        return this.permanentHours;
    }

    @Generated
    public boolean isCheckUpdates() {
        return this.checkUpdates;
    }

    @Generated
    public String getDatabaseType() {
        return this.databaseType;
    }

    @Generated
    public boolean isSaveTopOnUpdate() {
        return this.saveTopOnUpdate;
    }

    @Generated
    public String getDailyResetTime() {
        return this.dailyResetTime;
    }

    @Generated
    public String getWeeklyResetTime() {
        return this.weeklyResetTime;
    }

    @Generated
    public String getMonthlyResetTime() {
        return this.monthlyResetTime;
    }

    @Generated
    public String getWeeklyResetDay() {
        return this.weeklyResetDay;
    }

    @Generated
    public Integer getMonthlyResetDay() {
        return this.monthlyResetDay;
    }

    @Generated
    public String getDailyResetTimezone() {
        return this.dailyResetTimezone;
    }

    @Generated
    public String getWeeklyResetTimezone() {
        return this.weeklyResetTimezone;
    }

    @Generated
    public String getMonthlyResetTimezone() {
        return this.monthlyResetTimezone;
    }
}

