/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.XLeaderBoards.managers;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.github.InsiderAnh.XLeaderBoards.XLeaderBoard;
import io.github.InsiderAnh.XLeaderBoards.hooks.tasks.TaskCanceller;
import io.github.InsiderAnh.XLeaderBoards.libs.bson.Document;
import io.github.InsiderAnh.XLeaderBoards.settings.InsiderConfig;
import io.github.InsiderAnh.XLeaderBoards.tops.CustomTop;
import io.github.InsiderAnh.XLeaderBoards.tops.TopData;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class CustomTopManager {
    private final XLeaderBoard plugin = XLeaderBoard.getInstance();
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    private final HashMap<String, CustomTop> customTops = new HashMap();
    private final HashMap<String, Document> customTopData = new HashMap();
    private InsiderConfig customTopsConfig;
    private ListeningExecutorService customTopExecutor;
    private TaskCanceller updateTask;

    public void load() {
        if (this.updateTask != null) {
            this.updateTask.cancel();
        }
        if (this.customTopsConfig == null) {
            this.customTopsConfig = new InsiderConfig(this.plugin, "custom_tops", false, false);
        } else {
            this.customTopsConfig.reload();
        }
        this.customTops.clear();
        this.loadCustomTops();
        this.customTopExecutor = MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(2, 4, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1024)));
        this.updateTask = this.plugin.getStellarTaskHook(this::checkAndUpdateCustomTops).runTaskTimerAsynchronously(20L, 1200L);
    }

    private void loadCustomTops() {
        if (!this.customTopsConfig.getConfig().isConfigurationSection("custom_tops")) {
            return;
        }
        for (String customTopId : this.customTopsConfig.getConfig().getConfigurationSection("custom_tops").getKeys(false)) {
            try {
                String path = "custom_tops." + customTopId;
                String name = this.customTopsConfig.getConfig().getString(path + ".name");
                String displayName = this.customTopsConfig.getConfig().getString(path + ".display_name", name);
                String startTimeStr = this.customTopsConfig.getConfig().getString(path + ".start_time");
                String endTimeStr = this.customTopsConfig.getConfig().getString(path + ".end_time");
                long startTime = this.dateFormat.parse(startTimeStr).getTime();
                long endTime = this.dateFormat.parse(endTimeStr).getTime();
                int updateInterval = this.customTopsConfig.getConfig().getInt(path + ".update_interval_minutes", 30);
                boolean active = this.customTopsConfig.getBoolean(path + ".active", false);
                boolean rewardsGiven = this.customTopsConfig.getBoolean(path + ".rewards_given", false);
                long lastUpdate = this.customTopsConfig.getLong(path + ".last_update", 0L);
                long nextUpdate = this.customTopsConfig.getLong(path + ".next_update", 0L);
                CustomTop customTop = new CustomTop(customTopId, name, displayName, startTime, endTime);
                customTop.setUpdateIntervalMinutes(updateInterval);
                customTop.setActive(active);
                customTop.setRewardsGiven(rewardsGiven);
                customTop.setLastUpdate(lastUpdate);
                customTop.setNextUpdate(nextUpdate);
                this.customTops.put(customTopId, customTop);
                this.plugin.getLogger().info("Loaded custom top: " + customTopId + " (" + displayName + ")");
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to load custom top: " + customTopId);
                e.printStackTrace();
            }
        }
    }

    private void checkAndUpdateCustomTops() {
        for (CustomTop customTop : this.customTops.values()) {
            long now = System.currentTimeMillis();
            if (!customTop.isActive() && customTop.isCurrentlyActive()) {
                this.activateCustomTop(customTop);
            }
            if (customTop.isActive() && customTop.shouldUpdate()) {
                this.updateCustomTopRankings(customTop);
            }
            if (!customTop.isActive() || !customTop.hasFinished() || customTop.isRewardsGiven()) continue;
            this.finalizeCustomTop(customTop);
        }
    }

    private void activateCustomTop(CustomTop customTop) {
        customTop.setActive(true);
        customTop.setNextUpdate(System.currentTimeMillis() + (long)customTop.getUpdateIntervalMinutes() * 60000L);
        this.saveCustomTop(customTop);
        this.plugin.getLogger().info("Activated custom top: " + customTop.getId());
        this.updateCustomTopRankings(customTop);
    }

    private void updateCustomTopRankings(CustomTop customTop) {
        this.customTopExecutor.execute(() -> {
            this.plugin.getPlayerManager().forceSave();
            int maxEntries = this.plugin.getConfigManager().getMaxCachedTopEntries();
            TopData topData = this.plugin.getTopManager().getTopData().get(customTop.getName());
            if (topData != null) {
                String key = "custom_" + customTop.getId();
                String path = "data.custom." + customTop.getName();
                Document topDocument = this.plugin.getLeaderDatabase().getTopRepository().getTop(path, maxEntries);
                this.customTopData.put(key, topDocument);
                String rankingPath = "data.ranking.custom_" + customTop.getId();
                this.plugin.getLeaderDatabase().getTopRepository().updateRanking("custom_tops", path, rankingPath);
                this.plugin.sendDebugMessage("Updated custom top rankings: " + customTop.getId());
            }
            customTop.setLastUpdate(System.currentTimeMillis());
            customTop.setNextUpdate(System.currentTimeMillis() + (long)customTop.getUpdateIntervalMinutes() * 60000L);
            this.saveCustomTop(customTop);
        });
    }

    private void finalizeCustomTop(CustomTop customTop) {
        customTop.setActive(false);
        customTop.setRewardsGiven(true);
        this.saveCustomTop(customTop);
        this.plugin.getLogger().info("Finalizing custom top: " + customTop.getId());
        this.customTopExecutor.execute(() -> {
            String key = "custom_" + customTop.getId();
            Document topDocument = this.customTopData.get(key);
            if (topDocument != null) {
                this.plugin.getRewardManager().checkTopRewards(customTop.getName(), "custom_" + customTop.getId(), topDocument);
            }
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.isOnline()) continue;
                this.plugin.getPlayerManager().loadPlayerRanking(player);
            }
        });
    }

    private void saveCustomTop(CustomTop customTop) {
        String path = "custom_tops." + customTop.getId();
        this.customTopsConfig.set(path + ".active", customTop.isActive());
        this.customTopsConfig.set(path + ".rewards_given", customTop.isRewardsGiven());
        this.customTopsConfig.set(path + ".last_update", customTop.getLastUpdate());
        this.customTopsConfig.set(path + ".next_update", customTop.getNextUpdate());
        this.customTopsConfig.save();
    }

    public void createCustomTop(String id, String name, String displayName, long startTime, long endTime, int updateIntervalMinutes) {
        String path = "custom_tops." + id;
        this.customTopsConfig.set(path + ".name", name);
        this.customTopsConfig.set(path + ".display_name", displayName);
        this.customTopsConfig.set(path + ".start_time", this.dateFormat.format(startTime));
        this.customTopsConfig.set(path + ".end_time", this.dateFormat.format(endTime));
        this.customTopsConfig.set(path + ".update_interval_minutes", updateIntervalMinutes);
        this.customTopsConfig.set(path + ".active", false);
        this.customTopsConfig.set(path + ".rewards_given", false);
        this.customTopsConfig.set(path + ".last_update", 0);
        this.customTopsConfig.set(path + ".next_update", 0);
        this.customTopsConfig.save();
        CustomTop customTop = new CustomTop(id, name, displayName, startTime, endTime);
        customTop.setUpdateIntervalMinutes(updateIntervalMinutes);
        this.customTops.put(id, customTop);
        this.plugin.getLogger().info("Created custom top: " + id);
    }

    public void deleteCustomTop(String id) {
        this.customTops.remove(id);
        this.customTopData.remove("custom_" + id);
        this.customTopsConfig.set("custom_tops." + id, null);
        this.customTopsConfig.save();
        this.plugin.getLogger().info("Deleted custom top: " + id);
    }

    public void forceUpdateCustomTop(String id) {
        CustomTop customTop = this.customTops.get(id);
        if (customTop != null && customTop.isActive()) {
            this.updateCustomTopRankings(customTop);
        }
    }

    public void forceEndCustomTop(String id, boolean giveRewards) {
        CustomTop customTop = this.customTops.get(id);
        if (customTop != null && customTop.isActive()) {
            if (giveRewards) {
                this.finalizeCustomTop(customTop);
            } else {
                customTop.setActive(false);
                customTop.setRewardsGiven(true);
                this.saveCustomTop(customTop);
            }
        }
    }

    public void shutdown() {
        if (this.updateTask != null) {
            this.updateTask.cancel();
        }
        if (this.customTopExecutor != null) {
            this.customTopExecutor.shutdown();
        }
    }

    @Generated
    public HashMap<String, CustomTop> getCustomTops() {
        return this.customTops;
    }

    @Generated
    public HashMap<String, Document> getCustomTopData() {
        return this.customTopData;
    }
}

