/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.XLeaderBoards.managers;

import io.github.InsiderAnh.XLeaderBoards.XLeaderBoard;
import io.github.InsiderAnh.XLeaderBoards.data.PlayerReward;
import io.github.InsiderAnh.XLeaderBoards.enums.MessageType;
import io.github.InsiderAnh.XLeaderBoards.libs.bson.Document;
import io.github.InsiderAnh.XLeaderBoards.placeholders.Placeholder;
import io.github.InsiderAnh.XLeaderBoards.rewards.Execution;
import io.github.InsiderAnh.XLeaderBoards.rewards.executions.ExecuteCommand;
import io.github.InsiderAnh.XLeaderBoards.rewards.executions.ExecuteMessage;
import io.github.InsiderAnh.XLeaderBoards.settings.InsiderConfig;
import io.github.InsiderAnh.XLeaderBoards.tops.RewardChange;
import io.github.InsiderAnh.XLeaderBoards.tops.TopData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class RewardManager {
    private final XLeaderBoard plugin = XLeaderBoard.getInstance();
    private InsiderConfig rewardsConfig;
    private boolean isRewardsEnabled;

    public void load() {
        if (this.rewardsConfig == null) {
            this.rewardsConfig = new InsiderConfig(this.plugin, "rewards", false, false);
        } else {
            this.rewardsConfig.reload();
        }
        this.isRewardsEnabled = this.rewardsConfig.getBoolean("enabled");
        if (!this.isRewardsEnabled) {
            return;
        }
        for (String timeType : this.rewardsConfig.getConfig().getConfigurationSection("rewards").getKeys(false)) {
            this.loadTopTime(timeType);
        }
    }

    void loadTopTime(String timeType) {
        if (!(timeType.equals("permanent") || timeType.equals("monthly") || timeType.equals("weekly") || timeType.equals("daily") || timeType.startsWith("custom_"))) {
            return;
        }
        if (!this.rewardsConfig.getConfig().isConfigurationSection("rewards." + timeType)) {
            this.plugin.sendDebugMessage("No rewards section found for timeType: " + timeType);
            return;
        }
        for (String topKey : this.rewardsConfig.getConfig().getConfigurationSection("rewards." + timeType).getKeys(false)) {
            TopData topData = this.plugin.getTopManager().getTopData().get(topKey);
            if (topData == null) {
                this.plugin.getLogger().warning("TopData not found for key: " + topKey + " in timeType: " + timeType);
                continue;
            }
            String path = "rewards." + timeType + "." + topKey;
            if (!this.rewardsConfig.getConfig().isConfigurationSection(path)) {
                this.plugin.sendDebugMessage("No configuration section at path: " + path);
                continue;
            }
            for (String key : this.rewardsConfig.getConfig().getConfigurationSection(path).getKeys(false)) {
                try {
                    int topNumber = this.rewardsConfig.getConfig().getInt(path + "." + key + ".top");
                    if (!this.rewardsConfig.getConfig().isList(path + "." + key + ".rewards")) {
                        this.plugin.getLogger().warning("No rewards list found at: " + path + "." + key + ".rewards");
                        continue;
                    }
                    LinkedList<Execution> executions = new LinkedList<Execution>();
                    for (String executionKey : this.rewardsConfig.getList(path + "." + key + ".rewards")) {
                        Execution execution = this.getExecution(executionKey);
                        if (execution != null) {
                            executions.add(execution);
                            continue;
                        }
                        this.plugin.getLogger().warning("Failed to parse execution: " + executionKey);
                    }
                    if (!executions.isEmpty()) {
                        topData.getExecutions().computeIfAbsent(timeType, k -> new HashMap()).put(topNumber, executions);
                        this.plugin.sendDebugMessage("Added " + executions.size() + " reward(s) for top " + topKey + " position " + topNumber + " in " + timeType);
                        continue;
                    }
                    this.plugin.getLogger().warning("No valid executions for reward key " + key + " at top " + topKey);
                }
                catch (Exception exception) {
                    this.plugin.getLogger().warning("Invalid reward configuration at " + path + "." + key);
                    exception.printStackTrace();
                }
            }
        }
    }

    public void checkPlayerRewards(Player player) {
        if (!this.isRewardsEnabled) {
            return;
        }
        PlayerReward playerReward = this.plugin.getLeaderDatabase().getPlayerRepository().loadPlayerReward(player);
        if (playerReward == null) {
            return;
        }
        this.plugin.getLeaderDatabase().getPlayerRepository().deleteReward(player);
        this.plugin.getStellarTaskHook(() -> {
            for (Map.Entry<String, String> entry : new HashSet<Map.Entry<String, String>>(playerReward.getRewards().entrySet())) {
                this.giveTopRewards(player, entry.getValue());
            }
        }).runTask();
    }

    void giveTopRewards(Player player, String reward) {
        String[] rewardData = reward.split(":", 4);
        String topKey = rewardData[2];
        TopData topData = this.plugin.getTopManager().getTopData().get(topKey);
        if (topData == null) {
            return;
        }
        String timeType = rewardData[3];
        int topNumber = Integer.parseInt(rewardData[0]);
        long amount = Long.parseLong(rewardData[1]);
        List executions = (List)topData.getExecutions().getOrDefault(timeType, new HashMap()).get(topNumber);
        if (executions == null) {
            return;
        }
        for (Execution execution : executions) {
            execution.execute(player, new Placeholder("<player>", player.getName()), new Placeholder("<top>", String.valueOf(topNumber)), new Placeholder("<amount>", String.valueOf(amount)));
        }
    }

    public void checkTopRewards(String topKey, String timeType, Document document) {
        if (!this.isRewardsEnabled) {
            return;
        }
        if (document == null || document.isEmpty()) {
            this.plugin.sendDebugMessage("No top data available for " + topKey + " (" + timeType + "), skipping rewards");
            return;
        }
        ArrayList<RewardChange> rewards = new ArrayList<RewardChange>();
        for (Map.Entry<String, Object> entry : document.entrySet()) {
            String topNumber = entry.getKey();
            Document topDocument = (Document)document.get(topNumber);
            UUID playerId = UUID.fromString(topDocument.getString("uuid"));
            String playerName = topDocument.getString("name");
            long amount = topDocument.get("amount") instanceof Long ? topDocument.getLong("amount") : (long)topDocument.getInteger("amount").intValue();
            Player online = Bukkit.getPlayer((UUID)playerId);
            if (online != null) {
                this.giveTopRewards(online, topNumber + ":" + amount + ":" + topKey + ":" + timeType);
                continue;
            }
            rewards.add(new RewardChange(playerId, playerName, UUID.randomUUID().toString(), topNumber + ":" + amount + ":" + topKey + ":" + timeType));
        }
        this.plugin.getLeaderDatabase().getPlayerRepository().saveReward(rewards);
    }

    public Execution getExecution(String action) {
        if (action.startsWith("message:")) {
            return new ExecuteMessage(MessageType.NORMAL, action.replace("message: ", ""));
        }
        if (action.startsWith("center_message:")) {
            return new ExecuteMessage(MessageType.CENTERED, action.replace("center_message: ", ""));
        }
        if (action.startsWith("mini_message:")) {
            return new ExecuteMessage(MessageType.MINI_MESSAGE, action.replace("mini_message: ", ""));
        }
        if (action.startsWith("broadcast:")) {
            return new ExecuteMessage(MessageType.BROADCAST, action.replace("broadcast: ", ""));
        }
        if (action.startsWith("command:") || action.startsWith("player_command:")) {
            return new ExecuteCommand("player", action.replace("command: ", "").replace("player_command: ", ""));
        }
        if (action.startsWith("console_command:")) {
            return new ExecuteCommand("console", action.replace("console_command: ", ""));
        }
        return null;
    }

    @Generated
    public boolean isRewardsEnabled() {
        return this.isRewardsEnabled;
    }
}

