/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.XLeaderBoards.managers;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.github.InsiderAnh.XLeaderBoards.XLeaderBoard;
import io.github.InsiderAnh.XLeaderBoards.hooks.tasks.TaskCanceller;
import io.github.InsiderAnh.XLeaderBoards.libs.bson.Document;
import io.github.InsiderAnh.XLeaderBoards.settings.InsiderConfig;
import io.github.InsiderAnh.XLeaderBoards.tops.Ranking;
import io.github.InsiderAnh.XLeaderBoards.tops.TopData;
import io.github.InsiderAnh.XLeaderBoards.tops.TopDate;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class TopManager {
    private final XLeaderBoard plugin = XLeaderBoard.getInstance();
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy kk:mm:ss");
    private final HashMap<String, TopData> topData = new HashMap();
    private final HashMap<String, Document> tops = new HashMap();
    private InsiderConfig topsConfig;
    private TopDate topDate;
    private ListeningExecutorService topExecutor;
    private TaskCanceller updateTask;

    public void load() {
        if (this.updateTask != null) {
            this.updateTask.cancel();
        }
        if (this.topsConfig == null) {
            this.topsConfig = new InsiderConfig(this.plugin, "tops", false, false);
        } else {
            this.topsConfig.reload();
        }
        try {
            long nextDaily = this.topsConfig.getLongOrDefault("topDate.nextDaily", 0L);
            long nextWeekly = this.topsConfig.getLongOrDefault("topDate.nextWeekly", 0L);
            long nextMonthly = this.topsConfig.getLongOrDefault("topDate.nextMonthly", 0L);
            long nextDailyTop = this.topsConfig.getLongOrDefault("topDate.nextDailyTop", 0L);
            long nextWeeklyTop = this.topsConfig.getLongOrDefault("topDate.nextWeeklyTop", 0L);
            long nextMonthlyTop = this.topsConfig.getLongOrDefault("topDate.nextMonthlyTop", 0L);
            long nextPermanentTop = this.topsConfig.getLongOrDefault("topDate.nextPermanentTop", 0L);
            long lastDailyReset = this.topsConfig.getLongOrDefault("topDate.lastDailyReset", 0L);
            long lastWeeklyReset = this.topsConfig.getLongOrDefault("topDate.lastWeeklyReset", 0L);
            long lastMonthlyReset = this.topsConfig.getLongOrDefault("topDate.lastMonthlyReset", 0L);
            this.topDate = new TopDate(lastDailyReset, lastWeeklyReset, lastMonthlyReset, nextDaily, nextWeekly, nextMonthly, nextDailyTop, nextWeeklyTop, nextMonthlyTop, nextPermanentTop);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            try {
                long topTime = this.dateFormat.parse("06/09/2024 17:00:00").getTime();
                this.topDate = new TopDate(topTime, topTime, topTime, topTime, topTime, topTime, topTime, topTime, topTime, topTime);
            }
            catch (Exception exception1) {
                exception1.printStackTrace();
                this.topDate = new TopDate(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
            }
        }
        if (this.plugin.getConfig().isSet("tops")) {
            for (String key : this.plugin.getConfig().getConfigurationSection("tops").getKeys(false)) {
                String path = "tops." + key;
                String placeholder = this.plugin.getConfig().getString(path + ".placeholder");
                String name = this.plugin.getConfig().getString(path + ".name");
                boolean parseTime = this.plugin.getConfig().getBoolean(path + ".parse_time", false);
                String timeUnit = this.plugin.getConfig().getString(path + ".time_unit", "seconds");
                String timeFormat = this.plugin.getConfig().getString(path + ".time_format", "short");
                TopData data = new TopData(key, placeholder, name, parseTime, timeUnit, timeFormat);
                this.topData.put(key, data);
                this.plugin.sendDebugMessage("Loaded top: " + key + " (parseTime: " + parseTime + ", unit: " + timeUnit + ")");
            }
        }
        this.topExecutor = MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(2, 2, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1024)));
        this.initializeOrRecalculateResetDates();
        this.updateTask = this.plugin.getStellarTaskHook(() -> {
            this.updateTops();
            this.update();
        }).runTaskTimerAsynchronously(10L, this.plugin.getConfigManager().getTicksBetweenUpdates());
    }

    public void updateTops() {
        this.plugin.getPlayerManager().forceSave();
        int maxCachedTopEntries = this.plugin.getConfigManager().getMaxCachedTopEntries();
        this.topExecutor.execute(() -> {
            for (TopData data : this.topData.values()) {
                String topName = data.getName();
                this.updateTop("daily_" + topName, "data.daily." + topName, maxCachedTopEntries);
                this.updateTop("weekly_" + topName, "data.weekly." + topName, maxCachedTopEntries);
                this.updateTop("monthly_" + topName, "data.monthly." + topName, maxCachedTopEntries);
                this.updateTop("permanent_" + topName, "data.permanent." + topName, maxCachedTopEntries);
            }
        });
    }

    public void updateTop(String key, String path, int entries) {
        this.getTops().put(key, this.getTop(path, entries));
    }

    public void updateDailyRankings() {
        LinkedList<Ranking> rankings = new LinkedList<Ranking>();
        this.fillDailyRankings(rankings);
        ListeningExecutorService rankingExecutor = MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(1, 2, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1024)));
        if (this.plugin.getConfigManager().isSaveTopOnUpdate()) {
            rankingExecutor.execute(() -> this.plugin.getPlayerManager().forceSaveSync());
        }
        for (Ranking ranking : rankings) {
            rankingExecutor.execute(() -> {
                this.updateRanking("tops", ranking.getSortKey(), ranking.getKeyword());
                this.updateTop("daily_" + ranking.getTopKey(), "data.daily." + ranking.getTopKey(), this.plugin.getConfigManager().getMaxCachedTopEntries());
            });
        }
        rankingExecutor.execute(() -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.isOnline()) continue;
                this.plugin.getPlayerManager().loadPlayer(player);
            }
        });
        rankingExecutor.shutdown();
    }

    public void updateWeeklyRankings() {
        LinkedList<Ranking> rankings = new LinkedList<Ranking>();
        this.fillWeeklyRankings(rankings);
        ListeningExecutorService rankingExecutor = MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(1, 2, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1024)));
        if (this.plugin.getConfigManager().isSaveTopOnUpdate()) {
            rankingExecutor.execute(() -> this.plugin.getPlayerManager().forceSaveSync());
        }
        for (Ranking ranking : rankings) {
            rankingExecutor.execute(() -> {
                this.updateRanking("tops", ranking.getSortKey(), ranking.getKeyword());
                this.updateTop("weekly_" + ranking.getTopKey(), "data.weekly." + ranking.getTopKey(), this.plugin.getConfigManager().getMaxCachedTopEntries());
            });
        }
        rankingExecutor.execute(() -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.isOnline()) continue;
                this.plugin.getPlayerManager().loadPlayer(player);
            }
        });
        rankingExecutor.shutdown();
    }

    public void updateMonthlyRankings() {
        LinkedList<Ranking> rankings = new LinkedList<Ranking>();
        this.fillMonthlyRankings(rankings);
        ListeningExecutorService rankingExecutor = MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(1, 2, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1024)));
        if (this.plugin.getConfigManager().isSaveTopOnUpdate()) {
            rankingExecutor.execute(() -> this.plugin.getPlayerManager().forceSaveSync());
        }
        for (Ranking ranking : rankings) {
            rankingExecutor.execute(() -> {
                this.updateRanking("tops", ranking.getSortKey(), ranking.getKeyword());
                this.updateTop("monthly_" + ranking.getTopKey(), "data.monthly." + ranking.getTopKey(), this.plugin.getConfigManager().getMaxCachedTopEntries());
            });
        }
        rankingExecutor.execute(() -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.isOnline()) continue;
                this.plugin.getPlayerManager().loadPlayer(player);
            }
        });
        rankingExecutor.shutdown();
    }

    public void updatePermanentRankings() {
        LinkedList<Ranking> rankings = new LinkedList<Ranking>();
        this.fillPermanentRankings(rankings);
        ListeningExecutorService rankingExecutor = MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(2, 2, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1024)));
        for (Ranking ranking : rankings) {
            rankingExecutor.execute(() -> {
                this.updateRanking("tops", ranking.getSortKey(), ranking.getKeyword());
                this.updateTop("permanent_" + ranking.getTopKey(), "data.permanent." + ranking.getTopKey(), this.plugin.getConfigManager().getMaxCachedTopEntries());
            });
        }
        rankingExecutor.execute(() -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.isOnline()) continue;
                this.plugin.getPlayerManager().loadPlayerRanking(player);
            }
        });
        rankingExecutor.shutdown();
    }

    void fillDailyRankings(LinkedList<Ranking> rankings) {
        for (TopData data : this.topData.values()) {
            String topName = data.getName();
            rankings.add(new Ranking("data.daily." + topName, "data.ranking.daily_" + topName, "daily", topName));
        }
    }

    void fillWeeklyRankings(LinkedList<Ranking> rankings) {
        for (TopData data : this.topData.values()) {
            String topName = data.getName();
            rankings.add(new Ranking("data.weekly." + topName, "data.ranking.weekly_" + topName, "weekly", topName));
        }
    }

    void fillMonthlyRankings(LinkedList<Ranking> rankings) {
        for (TopData data : this.topData.values()) {
            String topName = data.getName();
            rankings.add(new Ranking("data.monthly." + topName, "data.ranking.monthly_" + topName, "monthly", topName));
        }
    }

    void fillPermanentRankings(LinkedList<Ranking> rankings) {
        for (TopData data : this.topData.values()) {
            String topName = data.getName();
            rankings.add(new Ranking("data.permanent." + topName, "data.ranking.permanent_" + topName, "permanent", topName));
        }
    }

    public Document getTop(String pathData, int entries) {
        return this.plugin.getLeaderDatabase().getTopRepository().getTop(pathData, entries);
    }

    private void initializeOrRecalculateResetDates() {
        boolean monthlyDayChanged;
        boolean needsRecalculation = false;
        long currentTime = System.currentTimeMillis();
        if (this.topDate.getNextDaily() == 0L || this.topDate.getNextDaily() < currentTime) {
            needsRecalculation = true;
            this.plugin.sendDebugMessage("Daily reset time needs initialization or has passed");
        }
        if (this.topDate.getNextWeekly() == 0L || this.topDate.getNextWeekly() < currentTime) {
            needsRecalculation = true;
            this.plugin.sendDebugMessage("Weekly reset time needs initialization or has passed");
        }
        if (this.topDate.getNextMonthly() == 0L || this.topDate.getNextMonthly() < currentTime) {
            needsRecalculation = true;
            this.plugin.sendDebugMessage("Monthly reset time needs initialization or has passed");
        }
        String storedWeeklyDay = this.topsConfig.getString("config.weeklyDay", null);
        Integer storedMonthlyDay = this.topsConfig.isSet("config.monthlyDay") ? Integer.valueOf(this.topsConfig.getInt("config.monthlyDay")) : null;
        String currentWeeklyDay = this.plugin.getConfigManager().getWeeklyResetDay();
        Integer currentMonthlyDay = this.plugin.getConfigManager().getMonthlyResetDay();
        boolean weeklyDayChanged = !Objects.equals(storedWeeklyDay, currentWeeklyDay);
        boolean bl = monthlyDayChanged = !Objects.equals(storedMonthlyDay, currentMonthlyDay);
        if (weeklyDayChanged || monthlyDayChanged) {
            this.plugin.getLogger().info("===== RESET CONFIGURATION CHANGED =====");
            this.plugin.sendDebugMessage("Reset configuration changed, recalculating dates...");
            if (weeklyDayChanged) {
                this.plugin.getLogger().info("Weekly reset day changed from '" + storedWeeklyDay + "' to '" + currentWeeklyDay + "'");
                this.plugin.sendDebugMessage("Weekly day changed from " + storedWeeklyDay + " to " + currentWeeklyDay);
            }
            if (monthlyDayChanged) {
                this.plugin.getLogger().info("Monthly reset day changed from '" + storedMonthlyDay + "' to '" + currentMonthlyDay + "'");
                this.plugin.sendDebugMessage("Monthly day changed from " + storedMonthlyDay + " to " + currentMonthlyDay);
            }
            this.plugin.getLogger().info("Rewards will be given at the new reset time");
            this.plugin.getLogger().info("=======================================");
            needsRecalculation = true;
            if (currentWeeklyDay != null) {
                this.topsConfig.set("config.weeklyDay", currentWeeklyDay);
            }
            if (currentMonthlyDay != null) {
                this.topsConfig.set("config.monthlyDay", currentMonthlyDay);
            }
            this.topsConfig.save();
        }
        if (needsRecalculation) {
            try {
                if (this.topDate.getNextDaily() == 0L || this.topDate.getNextDaily() < currentTime) {
                    long nextDaily = this.calculateNextResetTime("daily");
                    this.topDate.setNextDaily(nextDaily);
                    this.plugin.sendDebugMessage("Calculated next daily reset: " + new Date(nextDaily));
                }
                if (this.topDate.getNextWeekly() == 0L || this.topDate.getNextWeekly() < currentTime || weeklyDayChanged) {
                    long nextWeekly = this.calculateNextResetTime("weekly");
                    this.topDate.setNextWeekly(nextWeekly);
                    this.plugin.sendDebugMessage("Calculated next weekly reset: " + new Date(nextWeekly));
                }
                if (this.topDate.getNextMonthly() == 0L || this.topDate.getNextMonthly() < currentTime || monthlyDayChanged) {
                    long nextMonthly = this.calculateNextResetTime("monthly");
                    this.topDate.setNextMonthly(nextMonthly);
                    this.plugin.sendDebugMessage("Calculated next monthly reset: " + new Date(nextMonthly));
                }
                if (this.topDate.getNextDailyTop() == 0L) {
                    Calendar cal = Calendar.getInstance();
                    cal.add(12, this.plugin.getConfigManager().getDailyMinutes());
                    this.topDate.setNextDailyTop(cal.getTimeInMillis());
                }
                if (this.topDate.getNextWeeklyTop() == 0L) {
                    Calendar cal = Calendar.getInstance();
                    cal.add(12, this.plugin.getConfigManager().getWeeklyMinutes());
                    this.topDate.setNextWeeklyTop(cal.getTimeInMillis());
                }
                if (this.topDate.getNextMonthlyTop() == 0L) {
                    Calendar cal = Calendar.getInstance();
                    cal.add(11, this.plugin.getConfigManager().getMonthlyHours());
                    this.topDate.setNextMonthlyTop(cal.getTimeInMillis());
                }
                if (this.topDate.getNextPermanentTop() == 0L) {
                    Calendar cal = Calendar.getInstance();
                    cal.add(11, this.plugin.getConfigManager().getPermanentHours());
                    this.topDate.setNextPermanentTop(cal.getTimeInMillis());
                }
                this.saveDateTop();
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Error initializing reset dates: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private void updateRanking(String database, String sortKey, String keyword) {
        this.plugin.getLeaderDatabase().getTopRepository().updateRanking(database, sortKey, keyword);
    }

    public void resetDateTop(String key, String top, boolean giveReward) {
        if (giveReward) {
            for (TopData data : this.topData.values()) {
                this.plugin.getRewardManager().checkTopRewards(data.getName(), top, this.getTops().get(top + "_" + data.getName()));
            }
        }
        this.plugin.getLeaderDatabase().getTopRepository().resetDateTop(key, top, this.topDate);
    }

    public void forceResetTop(String key, String top, boolean giveReward) {
        this.resetDateTop(key, top, giveReward);
        switch (top) {
            case "daily": {
                this.updateDailyRankings();
                break;
            }
            case "weekly": {
                this.updateWeeklyRankings();
                break;
            }
            case "monthly": {
                this.updateMonthlyRankings();
            }
        }
    }

    public void update() {
        this.checkAndUpdateReset("daily", this.topDate.getNextDaily(), () -> {
            this.saveDateTop();
            this.resetDateTop("data.daily", "daily", true);
        });
        this.checkAndUpdateReset("weekly", this.topDate.getNextWeekly(), () -> {
            this.saveDateTop();
            this.resetDateTop("data.weekly", "weekly", true);
        });
        this.checkAndUpdateReset("monthly", this.topDate.getNextMonthly(), () -> {
            this.saveDateTop();
            this.resetDateTop("data.monthly", "monthly", true);
        });
        this.checkAndUpdateTop("daily", this.plugin.getConfigManager().getDailyMinutes(), 12, this.topDate.getNextDailyTop(), this::updateDailyRankings);
        this.checkAndUpdateTop("weekly", this.plugin.getConfigManager().getWeeklyMinutes(), 12, this.topDate.getNextWeeklyTop(), this::updateWeeklyRankings);
        this.checkAndUpdateTop("monthly", this.plugin.getConfigManager().getMonthlyHours(), 11, this.topDate.getNextMonthlyTop(), this::updateMonthlyRankings);
        this.checkAndUpdateTop("permanent", this.plugin.getConfigManager().getPermanentHours(), 11, this.topDate.getNextPermanentTop(), this::updatePermanentRankings);
    }

    private void checkAndUpdateReset(String period, long nextResetTime, Runnable task) {
        if (nextResetTime < System.currentTimeMillis()) {
            this.updateLastReset(period);
            try {
                long calculatedNextReset = this.calculateNextResetTime(period);
                this.setNextReset(period, calculatedNextReset);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.topExecutor.execute(task);
        }
    }

    private long calculateNextResetTime(String period) throws Exception {
        String resetTime;
        TimeZone targetTimeZone = this.getTimeZoneForPeriod(period);
        Calendar calendar = Calendar.getInstance(targetTimeZone);
        calendar.setTime(new Date());
        SimpleDateFormat timezoneFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        timezoneFormat.setTimeZone(targetTimeZone);
        switch (period) {
            case "daily": {
                resetTime = this.plugin.getConfigManager().getDailyResetTime();
                String todayDateStr = calendar.get(5) + "/" + (calendar.get(2) + 1) + "/" + calendar.get(1) + " " + resetTime;
                Date todayReset = timezoneFormat.parse(todayDateStr);
                if (todayReset.getTime() > System.currentTimeMillis()) {
                    this.plugin.sendDebugMessage("Daily reset scheduled for today at " + todayReset + " (" + targetTimeZone.getID() + ")");
                    return todayReset.getTime();
                }
                calendar.add(5, 1);
                break;
            }
            case "weekly": {
                resetTime = this.plugin.getConfigManager().getWeeklyResetTime();
                String weeklyDay = this.plugin.getConfigManager().getWeeklyResetDay();
                if (weeklyDay != null && !weeklyDay.isEmpty()) {
                    int currentDayOfWeek;
                    int targetDayOfWeek = this.getDayOfWeekFromString(weeklyDay);
                    int daysUntilNext = (targetDayOfWeek - (currentDayOfWeek = calendar.get(7)) + 7) % 7;
                    if (daysUntilNext == 0) {
                        String todayWeeklyDateStr = calendar.get(5) + "/" + (calendar.get(2) + 1) + "/" + calendar.get(1) + " " + resetTime;
                        Date todayWeeklyReset = timezoneFormat.parse(todayWeeklyDateStr);
                        if (todayWeeklyReset.getTime() > System.currentTimeMillis()) {
                            this.plugin.sendDebugMessage("Weekly reset scheduled for today at " + todayWeeklyReset + " (" + targetTimeZone.getID() + ")");
                            return todayWeeklyReset.getTime();
                        }
                        daysUntilNext = 7;
                    }
                    calendar.add(5, daysUntilNext);
                    break;
                }
                calendar.add(5, 7);
                break;
            }
            case "monthly": {
                resetTime = this.plugin.getConfigManager().getMonthlyResetTime();
                Integer monthlyDay = this.plugin.getConfigManager().getMonthlyResetDay();
                if (monthlyDay != null) {
                    int currentDay = calendar.get(5);
                    int currentMonth = calendar.get(2);
                    int currentYear = calendar.get(1);
                    int maxDayOfCurrentMonth = calendar.getActualMaximum(5);
                    int targetDay = Math.min(monthlyDay, maxDayOfCurrentMonth);
                    if (currentDay < targetDay || currentDay == targetDay && this.isResetTimeInFuture(currentDay, currentMonth, currentYear, resetTime, targetTimeZone)) {
                        calendar.set(5, targetDay);
                        break;
                    }
                    calendar.add(2, 1);
                    int maxDayOfNextMonth = calendar.getActualMaximum(5);
                    targetDay = Math.min(monthlyDay, maxDayOfNextMonth);
                    calendar.set(5, targetDay);
                    break;
                }
                calendar.add(2, 1);
                break;
            }
            default: {
                resetTime = "17:00:00";
                calendar.add(5, 1);
            }
        }
        String nextDateStr = calendar.get(5) + "/" + (calendar.get(2) + 1) + "/" + calendar.get(1) + " " + resetTime;
        Date nextResetDate = timezoneFormat.parse(nextDateStr);
        this.plugin.sendDebugMessage(period + " reset scheduled for " + nextResetDate + " (" + targetTimeZone.getID() + ")");
        this.plugin.sendDebugMessage("Server time will be: " + new Date(nextResetDate.getTime()));
        return nextResetDate.getTime();
    }

    private TimeZone getTimeZoneForPeriod(String period) {
        String timezoneId = null;
        switch (period) {
            case "daily": {
                timezoneId = this.plugin.getConfigManager().getDailyResetTimezone();
                break;
            }
            case "weekly": {
                timezoneId = this.plugin.getConfigManager().getWeeklyResetTimezone();
                break;
            }
            case "monthly": {
                timezoneId = this.plugin.getConfigManager().getMonthlyResetTimezone();
            }
        }
        if (timezoneId != null && !timezoneId.isEmpty()) {
            try {
                TimeZone tz = TimeZone.getTimeZone(timezoneId);
                if (tz.getID().equals("GMT") && !timezoneId.equals("GMT")) {
                    this.plugin.getLogger().warning("Invalid timezone '" + timezoneId + "' for " + period + " reset. Using server timezone.");
                    return TimeZone.getDefault();
                }
                this.plugin.sendDebugMessage("Using timezone " + tz.getID() + " (offset: " + tz.getRawOffset() / 3600000 + "h) for " + period + " reset");
                return tz;
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Error parsing timezone '" + timezoneId + "' for " + period + " reset: " + e.getMessage());
            }
        }
        TimeZone defaultTz = TimeZone.getDefault();
        this.plugin.sendDebugMessage("Using server timezone " + defaultTz.getID() + " for " + period + " reset");
        return defaultTz;
    }

    private boolean isResetTimeInFuture(int day, int month, int year, String resetTime, TimeZone timeZone) {
        try {
            SimpleDateFormat timezoneFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
            timezoneFormat.setTimeZone(timeZone);
            String dateStr = day + "/" + (month + 1) + "/" + year + " " + resetTime;
            Date resetDate = timezoneFormat.parse(dateStr);
            return resetDate.getTime() > System.currentTimeMillis();
        }
        catch (Exception e) {
            return false;
        }
    }

    private int getDayOfWeekFromString(String dayName) {
        switch (dayName.toUpperCase()) {
            case "SUNDAY": {
                return 1;
            }
            case "MONDAY": {
                return 2;
            }
            case "TUESDAY": {
                return 3;
            }
            case "WEDNESDAY": {
                return 4;
            }
            case "THURSDAY": {
                return 5;
            }
            case "FRIDAY": {
                return 6;
            }
            case "SATURDAY": {
                return 7;
            }
        }
        return 2;
    }

    private void checkAndUpdateTop(String period, int amount, int calendarField, long nextTopTime, Runnable rankingTask) {
        if (nextTopTime < System.currentTimeMillis()) {
            Calendar calendar = this.dateFormat.getCalendar();
            calendar.setTime(new Date());
            try {
                calendar.add(calendarField, amount);
                Date nextTopDate = this.dateFormat.parse(calendar.get(5) + "/" + (calendar.get(2) + 1) + "/" + calendar.get(1) + " " + calendar.get(11) + ":" + calendar.get(12) + ":00");
                this.setNextTop(period, nextTopDate.getTime());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.topExecutor.execute(() -> {
                this.saveDateTop();
                rankingTask.run();
            });
        }
    }

    private void updateLastReset(String period) {
        switch (period) {
            case "daily": {
                this.topDate.setLastDailyReset(this.topDate.getNextDaily());
                break;
            }
            case "weekly": {
                this.topDate.setLastWeeklyReset(this.topDate.getNextWeekly());
                break;
            }
            case "monthly": {
                this.topDate.setLastMonthlyReset(this.topDate.getNextMonthly());
            }
        }
    }

    private void setNextReset(String period, long time) {
        switch (period) {
            case "daily": {
                this.topDate.setNextDaily(time);
                break;
            }
            case "weekly": {
                this.topDate.setNextWeekly(time);
                break;
            }
            case "monthly": {
                this.topDate.setNextMonthly(time);
            }
        }
    }

    private void setNextTop(String period, long time) {
        switch (period) {
            case "daily": {
                this.topDate.setNextDailyTop(time);
                break;
            }
            case "weekly": {
                this.topDate.setNextWeeklyTop(time);
                break;
            }
            case "monthly": {
                this.topDate.setNextMonthlyTop(time);
                break;
            }
            case "permanent": {
                this.topDate.setNextPermanentTop(time);
            }
        }
    }

    public void saveDateTop() {
        this.topsConfig.set("topDate.nextDaily", this.topDate.getNextDaily());
        this.topsConfig.set("topDate.nextWeekly", this.topDate.getNextWeekly());
        this.topsConfig.set("topDate.nextMonthly", this.topDate.getNextMonthly());
        this.topsConfig.set("topDate.nextDailyTop", this.topDate.getNextDailyTop());
        this.topsConfig.set("topDate.nextWeeklyTop", this.topDate.getNextWeeklyTop());
        this.topsConfig.set("topDate.nextMonthlyTop", this.topDate.getNextMonthlyTop());
        this.topsConfig.set("topDate.nextPermanentTop", this.topDate.getNextPermanentTop());
        this.topsConfig.set("topDate.lastDailyReset", this.topDate.getLastDailyReset());
        this.topsConfig.set("topDate.lastWeeklyReset", this.topDate.getLastWeeklyReset());
        this.topsConfig.set("topDate.lastMonthlyReset", this.topDate.getLastMonthlyReset());
        this.topsConfig.save();
    }

    @Generated
    public HashMap<String, TopData> getTopData() {
        return this.topData;
    }

    @Generated
    public HashMap<String, Document> getTops() {
        return this.tops;
    }

    @Generated
    public TopDate getTopDate() {
        return this.topDate;
    }
}

