/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.XLeaderBoards.utils;

import io.github.InsiderAnh.XLeaderBoards.XLeaderBoard;
import io.github.InsiderAnh.XLeaderBoards.placeholders.Placeholder;
import java.text.DecimalFormat;

public class LeaderUtils {
    private static final XLeaderBoard plugin = XLeaderBoard.getInstance();
    private static final DecimalFormat formatDouble = new DecimalFormat("#,##0.##");

    public static String formatNumber(double number) {
        return formatDouble.format(number);
    }

    public static String millisToLongDHMS(long millis) {
        if (millis < 1000L) {
            return "0";
        }
        long days = millis / 86400000L;
        long hours = (millis %= 86400000L) / 3600000L;
        long minutes = (millis %= 3600000L) / 60000L;
        long seconds = (millis %= 60000L) / 1000L;
        StringBuilder time = new StringBuilder();
        if (days > 0L) {
            time.append(days).append("d ");
        }
        if (hours > 0L) {
            time.append(hours).append("h ");
        }
        if (minutes > 0L) {
            time.append(minutes).append("m ");
        }
        if (seconds > 0L) {
            time.append(seconds).append("s");
        }
        return time.toString().trim();
    }

    public static String replacePlaceholders(String message, Placeholder ... placeholders) {
        StringBuilder messageBuilder = new StringBuilder(message);
        for (Placeholder placeholder : placeholders) {
            int index;
            String placeholderStr = placeholder.getPlaceholder();
            String value = placeholder.getValue();
            while ((index = messageBuilder.indexOf(placeholderStr)) != -1) {
                messageBuilder.replace(index, index + placeholderStr.length(), value);
            }
        }
        return messageBuilder.toString();
    }
}

