/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.XLeaderBoards.utils;

import io.github.InsiderAnh.XLeaderBoards.XLeaderBoard;

public class TimeFormatter {
    public static String millisToFormattedTime(long millis, XLeaderBoard plugin) {
        if (millis < 1000L) {
            return "0";
        }
        TimeComponents time = TimeFormatter.calculateTimeComponents(millis);
        String formatKey = TimeFormatter.determineFormatKey(time);
        String format = plugin.getLang().getString("timeFormats." + formatKey);
        return TimeFormatter.applyTimeFormat(format, time);
    }

    private static TimeComponents calculateTimeComponents(long millis) {
        long days = millis / 86400000L;
        long hours = (millis %= 86400000L) / 3600000L;
        long minutes = (millis %= 3600000L) / 60000L;
        long seconds = (millis %= 60000L) / 1000L;
        return new TimeComponents(days, hours, minutes, seconds);
    }

    private static String determineFormatKey(TimeComponents time) {
        if (time.days > 0L) {
            return "withDays";
        }
        if (time.hours > 0L) {
            return "withHours";
        }
        if (time.minutes > 0L) {
            return "withMinutes";
        }
        return "withSeconds";
    }

    private static String applyTimeFormat(String format, TimeComponents time) {
        if (format == null || format.isEmpty()) {
            return TimeFormatter.buildFallbackFormat(time);
        }
        return format.replace("<days>", String.valueOf(time.days)).replace("<hours>", String.valueOf(time.hours)).replace("<minutes>", String.valueOf(time.minutes)).replace("<seconds>", String.valueOf(time.seconds));
    }

    private static String buildFallbackFormat(TimeComponents time) {
        StringBuilder result = new StringBuilder();
        if (time.days > 0L) {
            result.append(time.days).append("d ");
        }
        if (time.hours > 0L) {
            result.append(time.hours).append("h ");
        }
        if (time.minutes > 0L) {
            result.append(time.minutes).append("m ");
        }
        if (time.seconds > 0L) {
            result.append(time.seconds).append("s");
        }
        return result.toString().trim();
    }

    private static class TimeComponents {
        final long days;
        final long hours;
        final long minutes;
        final long seconds;

        TimeComponents(long days, long hours, long minutes, long seconds) {
            this.days = days;
            this.hours = hours;
            this.minutes = minutes;
            this.seconds = seconds;
        }
    }
}

