/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.XLeaderBoards.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeParser {
    private static final Pattern SPACE_FORMAT = Pattern.compile("(?:(\\d+)d)?\\s*(?:(\\d+)h)?\\s*(?:(\\d+)m)?\\s*(?:(\\d+)s)?", 2);
    private static final Pattern COLON_FORMAT = Pattern.compile("(?:(\\d+):)?(\\d+):(\\d+):(\\d+)", 2);
    private static final Pattern COMPACT_FORMAT = Pattern.compile("(?:(\\d+)d)?(?:(\\d+)h)?(?:(\\d+)m)?(?:(\\d+)s)?", 2);

    public static long parseTime(String timeString, String targetUnit) {
        if (timeString == null || timeString.isEmpty()) {
            return -1L;
        }
        try {
            return Long.parseLong(timeString.trim());
        }
        catch (NumberFormatException numberFormatException) {
            long totalSeconds = TimeParser.parseToSeconds(timeString);
            if (totalSeconds < 0L) {
                return -1L;
            }
            return TimeParser.convertFromSeconds(totalSeconds, targetUnit);
        }
    }

    private static long parseToSeconds(String timeString) {
        Matcher spaceMatcher = SPACE_FORMAT.matcher(timeString = timeString.trim().toLowerCase());
        if (spaceMatcher.matches() && !spaceMatcher.group(0).isEmpty()) {
            return TimeParser.extractTimeFromMatcher(spaceMatcher, false);
        }
        Matcher colonMatcher = COLON_FORMAT.matcher(timeString);
        if (colonMatcher.matches()) {
            return TimeParser.extractTimeFromColonFormat(colonMatcher);
        }
        Matcher compactMatcher = COMPACT_FORMAT.matcher(timeString);
        if (compactMatcher.matches() && !compactMatcher.group(0).isEmpty()) {
            return TimeParser.extractTimeFromMatcher(compactMatcher, true);
        }
        return -1L;
    }

    private static long extractTimeFromMatcher(Matcher matcher, boolean isCompact) {
        long days = 0L;
        long hours = 0L;
        long minutes = 0L;
        long seconds = 0L;
        String daysStr = matcher.group(1);
        String hoursStr = matcher.group(2);
        String minutesStr = matcher.group(3);
        String secondsStr = matcher.group(4);
        if (daysStr != null && !daysStr.isEmpty()) {
            days = Long.parseLong(daysStr);
        }
        if (hoursStr != null && !hoursStr.isEmpty()) {
            hours = Long.parseLong(hoursStr);
        }
        if (minutesStr != null && !minutesStr.isEmpty()) {
            minutes = Long.parseLong(minutesStr);
        }
        if (secondsStr != null && !secondsStr.isEmpty()) {
            seconds = Long.parseLong(secondsStr);
        }
        return days * 86400L + hours * 3600L + minutes * 60L + seconds;
    }

    private static long extractTimeFromColonFormat(Matcher matcher) {
        long days = 0L;
        if (matcher.group(1) != null) {
            days = Long.parseLong(matcher.group(1));
        }
        long hours = Long.parseLong(matcher.group(2));
        long minutes = Long.parseLong(matcher.group(3));
        long seconds = Long.parseLong(matcher.group(4));
        return days * 86400L + hours * 3600L + minutes * 60L + seconds;
    }

    private static long convertFromSeconds(long seconds, String targetUnit) {
        switch (targetUnit.toLowerCase()) {
            case "milliseconds": 
            case "millis": 
            case "ms": {
                return seconds * 1000L;
            }
            case "seconds": 
            case "second": 
            case "s": {
                return seconds;
            }
            case "minutes": 
            case "minute": 
            case "m": {
                return seconds / 60L;
            }
            case "hours": 
            case "hour": 
            case "h": {
                return seconds / 3600L;
            }
            case "days": 
            case "day": 
            case "d": {
                return seconds / 86400L;
            }
        }
        return seconds;
    }

    public static String formatTime(long value, String unit, String outputFormat) {
        long totalSeconds = TimeParser.convertToSeconds(value, unit);
        return TimeParser.formatSeconds(totalSeconds, outputFormat);
    }

    private static long convertToSeconds(long value, String unit) {
        switch (unit.toLowerCase()) {
            case "milliseconds": 
            case "millis": 
            case "ms": {
                return value / 1000L;
            }
            case "seconds": 
            case "second": 
            case "s": {
                return value;
            }
            case "minutes": 
            case "minute": 
            case "m": {
                return value * 60L;
            }
            case "hours": 
            case "hour": 
            case "h": {
                return value * 3600L;
            }
            case "days": 
            case "day": 
            case "d": {
                return value * 86400L;
            }
        }
        return value;
    }

    private static String formatSeconds(long totalSeconds, String outputFormat) {
        String separator;
        if (totalSeconds < 0L) {
            return "0s";
        }
        long days = totalSeconds / 86400L;
        long hours = totalSeconds % 86400L / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        StringBuilder result = new StringBuilder();
        String string = separator = outputFormat.equalsIgnoreCase("compact") ? "" : " ";
        if (days > 0L) {
            result.append(days).append("d").append(separator);
        }
        if (hours > 0L) {
            result.append(hours).append("h").append(separator);
        }
        if (minutes > 0L) {
            result.append(minutes).append("m").append(separator);
        }
        if (seconds > 0L || result.length() == 0) {
            result.append(seconds).append("s");
        }
        return result.toString().trim();
    }
}

