/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.XLeaderBoards.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public abstract class ItemUtils {
    public final ItemMeta itemMeta;
    public ItemStack item;

    public ItemUtils(Material material) {
        this(material, 1);
    }

    public ItemUtils(Material material, int amount) {
        this.item = new ItemStack(material, amount);
        this.itemMeta = this.item.getItemMeta();
    }

    public ItemUtils(ItemStack item) {
        this.item = item.clone();
        if (item.getType().equals((Object)Material.AIR)) {
            item.setType(Material.STONE);
        }
        this.itemMeta = item.getItemMeta();
    }

    public ItemUtils type(Material material) {
        this.item.setType(material);
        return this;
    }

    public ItemUtils data(short data) {
        this.item = new ItemStack(this.item.getType(), this.item.getAmount(), data);
        return this;
    }

    public ItemUtils displayName(String displayName) {
        this.itemMeta.setDisplayName(displayName);
        this.item.setItemMeta(this.itemMeta);
        return this;
    }

    public int enchantLevel(Enchantment enchantment) {
        return this.item.getEnchantments().getOrDefault(enchantment, 0);
    }

    public ItemUtils unEnchant(Enchantment enchantment) {
        this.itemMeta.removeEnchant(enchantment);
        return this;
    }

    public ItemUtils durability(int damage) {
        this.item.setDurability((short)Math.max(this.item.getType().getMaxDurability() - Math.max(damage, 1), 0));
        return this;
    }

    public abstract ItemUtils customModelData(int var1);

    public int durability() {
        return this.item.getType().getMaxDurability() - this.item.getDurability();
    }

    public int maxDurability() {
        return this.item.getType().getMaxDurability();
    }

    public ItemUtils amount(int amount) {
        this.item.setAmount(amount);
        return this;
    }

    public int amount() {
        return this.item.getAmount();
    }

    public ItemUtils lore(String lore) {
        return this.lore(null, lore, false);
    }

    public ItemUtils lore(Player player, String lore, boolean placeholders) {
        if (placeholders) {
            this.itemMeta.setLore(lore.isEmpty() ? new ArrayList() : Arrays.asList(PlaceholderAPI.setPlaceholders((Player)player, (String)lore).split("\\n")));
        } else {
            this.itemMeta.setLore(lore.isEmpty() ? new ArrayList() : Arrays.asList(lore.split("\\n")));
        }
        return this;
    }

    public ItemUtils setLoreList(List<String> lore) {
        this.itemMeta.setLore(lore);
        return this;
    }

    public ItemUtils setLoreList(Player player, List<String> lore) {
        this.itemMeta.setLore(PlaceholderAPI.setPlaceholders((Player)player, lore));
        return this;
    }

    public ItemUtils owner(String owner) {
        if (!this.item.getType().name().contains("SKULL_ITEM") && !this.item.getType().name().contains("PLAYER_HEAD")) {
            return this;
        }
        if (owner.isEmpty()) {
            return this;
        }
        SkullMeta headMeta = (SkullMeta)this.itemMeta;
        headMeta.setOwner(owner);
        return this;
    }

    public ItemUtils item(ItemStack item) {
        this.item = item;
        return this;
    }

    public abstract ItemUtils value(String var1);

    public ItemUtils glowing() {
        this.itemMeta.addEnchant(Enchantment.ARROW_DAMAGE, 1, true);
        this.itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        return this;
    }

    public abstract ItemUtils unbreakable(boolean var1);

    public ItemUtils enchant(Enchantment enchantment, int level) {
        this.itemMeta.addEnchant(enchantment, level, true);
        return this;
    }

    public abstract ItemUtils hideAttributes();

    public ItemStack build() {
        this.item.setItemMeta(this.itemMeta);
        return this.item;
    }
}

