/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.XLeaderBoards.commands.arguments;

import io.github.InsiderAnh.XLeaderBoards.XLeaderBoard;
import io.github.InsiderAnh.XLeaderBoards.commands.StellarArgument;
import io.github.InsiderAnh.XLeaderBoards.libs.bson.Document;
import io.github.InsiderAnh.XLeaderBoards.tops.TopData;
import io.github.InsiderAnh.XLeaderBoards.utils.CenterMessage;
import io.github.InsiderAnh.XLeaderBoards.utils.LeaderUtils;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class GetTopArgument
extends StellarArgument {
    private final XLeaderBoard plugin = XLeaderBoard.getInstance();

    @Override
    public void onCommand(@NotNull CommandSender sender, String[] arguments) {
        if (!sender.hasPermission("xleaderboards.gettop")) {
            sender.sendMessage(this.plugin.getLang().getString("tops.noPermission"));
            return;
        }
        if (arguments.length < 2) {
            this.sendHelp(sender);
            return;
        }
        String timeType = arguments[0];
        String topName = arguments[1];
        Document document = this.plugin.getTopManager().getTops().get(timeType + "_" + topName);
        if (document == null) {
            sender.sendMessage("\u00a7cNo exists " + timeType + " " + topName);
            return;
        }
        TopData topData = this.plugin.getTopManager().getTopData().get(topName);
        if (topData == null) {
            sender.sendMessage("\u00a7cNo exists " + topName);
            return;
        }
        for (String message : this.plugin.getLang().getString("tops.tops").replace("<name>", topData.getTopName()).split("\\n")) {
            if (message.startsWith("<center>")) {
                sender.sendMessage(CenterMessage.getCenteredMessage(message.replaceFirst("<center>", "")));
                continue;
            }
            if (message.contains("<tops>")) {
                for (String index : document.keySet()) {
                    Document topDocument = (Document)document.get(index);
                    String name = topDocument.getString("name");
                    String amount = topDocument.get("amount") instanceof Double ? LeaderUtils.formatNumber(topDocument.getDouble("amount")) : (topDocument.get("amount") instanceof Integer ? String.valueOf(topDocument.getInteger("amount")) : (topDocument.get("amount") instanceof Long ? String.valueOf(topDocument.getLong("amount")) : "0"));
                    sender.sendMessage(this.plugin.getLang().getString("tops.topLine").replace("<#>", index).replace("<name>", name).replace("<value>", amount));
                }
                continue;
            }
            sender.sendMessage(message);
        }
    }
}

