/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.XLeaderBoards.database.types.mongo;

import io.github.InsiderAnh.XLeaderBoards.XLeaderBoard;
import io.github.InsiderAnh.XLeaderBoards.database.repositories.TopRepository;
import io.github.InsiderAnh.XLeaderBoards.libs.bson.Document;
import io.github.InsiderAnh.XLeaderBoards.libs.bson.conversions.Bson;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.client.AggregateIterable;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.client.MongoCollection;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.client.MongoCursor;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.client.MongoDatabase;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.client.model.UpdateOneModel;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.client.model.UpdateOptions;
import io.github.InsiderAnh.XLeaderBoards.tops.TopDate;
import io.github.InsiderAnh.XLeaderBoards.utils.LeaderUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;

public class TopRepositoryMongo
implements TopRepository {
    private final XLeaderBoard leaderBoard = XLeaderBoard.getInstance();
    private final MongoCollection<Document> tops;
    private final MongoCollection<Document> topsRanking;

    public TopRepositoryMongo(MongoDatabase database) {
        String databaseId = this.leaderBoard.getConfig().getString("databaseId");
        this.tops = database.getCollection(databaseId);
        this.topsRanking = database.getCollection(databaseId + "_ranking");
    }

    @Override
    public Document getTop(String pathData, int entries) {
        Document totalTop = new Document();
        Document projection = new Document("name", 1).append("uuid", 1).append(pathData, 1);
        AtomicInteger index = new AtomicInteger(1);
        AggregateIterable<Document> result = this.tops.aggregate(Arrays.asList(new Document("$match", new Document(pathData, new Document("$exists", true))), new Document("$sort", new Document(pathData, -1)), new Document("$limit", entries), new Document("$project", projection)));
        try (MongoCursor cursor = result.cursor();){
            while (cursor.hasNext()) {
                Document document = (Document)cursor.next();
                Number numberValue = (Number)((Object)document.getEmbedded((List<?>)Arrays.asList(pathData.split("\\.")), Number.class));
                if (numberValue != null) {
                    if (numberValue instanceof Double) {
                        document.put("amount", (Object)numberValue.doubleValue());
                    } else if (numberValue instanceof Integer) {
                        document.put("amount", (Object)numberValue.intValue());
                    } else if (numberValue instanceof Long) {
                        document.put("amount", (Object)numberValue.longValue());
                    }
                } else {
                    document.put("amount", (Object)0.0);
                }
                document.remove("_id");
                document.remove("data");
                totalTop.put(String.valueOf(index.getAndIncrement()), (Object)document);
            }
        }
        return totalTop;
    }

    @Override
    public void updateRanking(String database, String sortKey, String keyword) {
        AggregateIterable<Document> result = this.tops.aggregate(Arrays.asList(new Document("$match", new Document(sortKey, new Document("$exists", true).append("$ne", 0))), new Document("$sort", new Document(sortKey, -1)))).allowDiskUse(true);
        try (MongoCursor cursor = result.cursor();){
            int rank = 0;
            long start = System.currentTimeMillis();
            ArrayList bulkOperations = new ArrayList();
            int BATCH_SIZE = this.leaderBoard.getConfigManager().getMaxBulkSize();
            while (cursor.hasNext()) {
                ++rank;
                Document document = (Document)cursor.next();
                if (!document.containsKey("uuid")) continue;
                Document filter = new Document("uuid", document.getString("uuid"));
                Document update = new Document("$set", new Document(keyword, rank));
                bulkOperations.add(new UpdateOneModel((Bson)filter, update, new UpdateOptions().upsert(true)));
                if (bulkOperations.size() != BATCH_SIZE) continue;
                this.topsRanking.bulkWrite(bulkOperations);
                bulkOperations.clear();
            }
            if (!bulkOperations.isEmpty()) {
                this.topsRanking.bulkWrite(bulkOperations);
            }
            long end = System.currentTimeMillis();
            this.leaderBoard.sendDebugMessage("Updated ranking " + sortKey + " in keyword " + keyword + " " + LeaderUtils.millisToLongDHMS(end - start) + " total ranking " + rank + " in database " + database);
        }
    }

    @Override
    public void resetDateTop(String key, String top, TopDate topDate) {
        ArrayList bulkOperations = new ArrayList();
        int batchSize = this.leaderBoard.getConfigManager().getMaxResetBulkSize();
        Document resetDoc = new Document(key, new HashMap());
        if (top.equals("daily")) {
            resetDoc.append("lastDailyReset", System.currentTimeMillis()).append("nextDailyReset", topDate.getNextDaily());
        } else if (top.equals("weekly")) {
            resetDoc.append("lastWeeklyReset", System.currentTimeMillis()).append("nextWeeklyReset", topDate.getNextWeekly());
        } else {
            resetDoc.append("lastMonthlyReset", System.currentTimeMillis()).append("nextMonthlyReset", topDate.getNextMonthly());
        }
        try (MongoCursor cursor = this.tops.find().cursor();){
            while (cursor.hasNext()) {
                Document document = (Document)cursor.next();
                Document update = new Document("$set", resetDoc);
                bulkOperations.add(new UpdateOneModel((Bson)new Document("uuid", document.getString("uuid")), update));
                if (bulkOperations.size() != batchSize) continue;
                this.tops.bulkWrite(bulkOperations);
                bulkOperations.clear();
            }
            if (!bulkOperations.isEmpty()) {
                this.tops.bulkWrite(bulkOperations);
            }
        }
    }

    @Generated
    public MongoCollection<Document> getTops() {
        return this.tops;
    }

    @Generated
    public MongoCollection<Document> getTopsRanking() {
        return this.topsRanking;
    }
}

