/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.XLeaderBoards.libs.bson.codecs.pojo;

import io.github.InsiderAnh.XLeaderBoards.libs.bson.BsonReader;
import io.github.InsiderAnh.XLeaderBoards.libs.bson.BsonWriter;
import io.github.InsiderAnh.XLeaderBoards.libs.bson.codecs.Codec;
import io.github.InsiderAnh.XLeaderBoards.libs.bson.codecs.DecoderContext;
import io.github.InsiderAnh.XLeaderBoards.libs.bson.codecs.EncoderContext;
import io.github.InsiderAnh.XLeaderBoards.libs.bson.codecs.configuration.CodecConfigurationException;
import io.github.InsiderAnh.XLeaderBoards.libs.bson.codecs.configuration.CodecRegistry;
import io.github.InsiderAnh.XLeaderBoards.libs.bson.codecs.pojo.PropertyCodecProvider;
import io.github.InsiderAnh.XLeaderBoards.libs.bson.codecs.pojo.PropertyCodecRegistry;
import io.github.InsiderAnh.XLeaderBoards.libs.bson.codecs.pojo.TypeWithTypeParameters;

final class EnumPropertyCodecProvider
implements PropertyCodecProvider {
    private final CodecRegistry codecRegistry;

    EnumPropertyCodecProvider(CodecRegistry codecRegistry) {
        this.codecRegistry = codecRegistry;
    }

    @Override
    public <T> Codec<T> get(TypeWithTypeParameters<T> type, PropertyCodecRegistry propertyCodecRegistry) {
        Class<T> clazz = type.getType();
        if (Enum.class.isAssignableFrom(clazz)) {
            try {
                return this.codecRegistry.get(clazz);
            }
            catch (CodecConfigurationException e) {
                return new EnumCodec<T>(clazz);
            }
        }
        return null;
    }

    private static class EnumCodec<T extends Enum<T>>
    implements Codec<T> {
        private final Class<T> clazz;

        EnumCodec(Class<T> clazz) {
            this.clazz = clazz;
        }

        @Override
        public void encode(BsonWriter writer, T value, EncoderContext encoderContext) {
            writer.writeString(((Enum)value).name());
        }

        @Override
        public Class<T> getEncoderClass() {
            return this.clazz;
        }

        @Override
        public T decode(BsonReader reader, DecoderContext decoderContext) {
            return Enum.valueOf(this.clazz, reader.readString());
        }
    }
}

