/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.XLeaderBoards.libs.mongodb.internal.event;

import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.assertions.Assertions;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.diagnostics.logging.Logger;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.diagnostics.logging.Loggers;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.event.ConnectionAddedEvent;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.event.ConnectionCheckedInEvent;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.event.ConnectionCheckedOutEvent;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.event.ConnectionPoolClosedEvent;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.event.ConnectionPoolListener;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.event.ConnectionPoolOpenedEvent;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.event.ConnectionPoolWaitQueueEnteredEvent;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.event.ConnectionPoolWaitQueueExitedEvent;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.event.ConnectionRemovedEvent;
import java.util.ArrayList;
import java.util.List;

final class ConnectionPoolListenerMulticaster
implements ConnectionPoolListener {
    private static final Logger LOGGER = Loggers.getLogger("protocol.event");
    private final List<ConnectionPoolListener> connectionPoolListeners;

    ConnectionPoolListenerMulticaster(List<ConnectionPoolListener> connectionPoolListeners) {
        Assertions.isTrue("All ConnectionPoolListener instances are non-null", !connectionPoolListeners.contains(null));
        this.connectionPoolListeners = new ArrayList<ConnectionPoolListener>(connectionPoolListeners);
    }

    @Override
    public void connectionPoolOpened(ConnectionPoolOpenedEvent event) {
        for (ConnectionPoolListener cur : this.connectionPoolListeners) {
            try {
                cur.connectionPoolOpened(event);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising connection pool opened event to listener %s", cur), e);
            }
        }
    }

    @Override
    public void connectionPoolClosed(ConnectionPoolClosedEvent event) {
        for (ConnectionPoolListener cur : this.connectionPoolListeners) {
            try {
                cur.connectionPoolClosed(event);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising connection pool closed event to listener %s", cur), e);
            }
        }
    }

    @Override
    public void connectionCheckedOut(ConnectionCheckedOutEvent event) {
        for (ConnectionPoolListener cur : this.connectionPoolListeners) {
            try {
                cur.connectionCheckedOut(event);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising connection pool checked out event to listener %s", cur), e);
            }
        }
    }

    @Override
    public void connectionCheckedIn(ConnectionCheckedInEvent event) {
        for (ConnectionPoolListener cur : this.connectionPoolListeners) {
            try {
                cur.connectionCheckedIn(event);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising connection pool checked in event to listener %s", cur), e);
            }
        }
    }

    @Override
    public void waitQueueEntered(ConnectionPoolWaitQueueEnteredEvent event) {
        for (ConnectionPoolListener cur : this.connectionPoolListeners) {
            try {
                cur.waitQueueEntered(event);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising connection pool wait queue entered event to listener %s", cur), e);
            }
        }
    }

    @Override
    public void waitQueueExited(ConnectionPoolWaitQueueExitedEvent event) {
        for (ConnectionPoolListener cur : this.connectionPoolListeners) {
            try {
                cur.waitQueueExited(event);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising connection pool wait queue exited event to listener %s", cur), e);
            }
        }
    }

    @Override
    public void connectionAdded(ConnectionAddedEvent event) {
        for (ConnectionPoolListener cur : this.connectionPoolListeners) {
            try {
                cur.connectionAdded(event);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising connection pool connection added event to listener %s", cur), e);
            }
        }
    }

    @Override
    public void connectionRemoved(ConnectionRemovedEvent event) {
        for (ConnectionPoolListener cur : this.connectionPoolListeners) {
            try {
                cur.connectionRemoved(event);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising connection pool connection removed event to listener %s", cur), e);
            }
        }
    }
}

