/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.XLeaderBoards.rewards.executions;

import io.github.InsiderAnh.XLeaderBoards.XLeaderBoard;
import io.github.InsiderAnh.XLeaderBoards.api.nms.NMS;
import io.github.InsiderAnh.XLeaderBoards.enums.MessageType;
import io.github.InsiderAnh.XLeaderBoards.placeholders.Placeholder;
import io.github.InsiderAnh.XLeaderBoards.rewards.Execution;
import io.github.InsiderAnh.XLeaderBoards.utils.CenterMessage;
import io.github.InsiderAnh.XLeaderBoards.utils.LeaderUtils;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class ExecuteMessage
extends Execution {
    private final MessageType messageType;
    private final String message;

    public ExecuteMessage(MessageType messageType, String message) {
        this.messageType = messageType;
        this.message = message;
    }

    @Override
    public void execute(Player player, Placeholder ... placeholders) {
        NMS nms = XLeaderBoard.getInstance().getNms();
        String replacedPlaceholders = PlaceholderAPI.setPlaceholders((Player)player, (String)LeaderUtils.replacePlaceholders(this.message, placeholders));
        String msg = XLeaderBoard.getInstance().getColorUtils().color(replacedPlaceholders);
        if (this.messageType.equals((Object)MessageType.NORMAL)) {
            player.sendMessage(msg);
        } else if (this.messageType.equals((Object)MessageType.CENTERED)) {
            player.sendMessage(CenterMessage.getCenteredMessage(msg));
        } else if (this.messageType.equals((Object)MessageType.MINI_MESSAGE)) {
            nms.sendMiniMessage(player, replacedPlaceholders);
        } else if (this.messageType.equals((Object)MessageType.ACTION)) {
            nms.sendActionBar(player, msg);
        } else if (this.messageType.equals((Object)MessageType.ACTION_MINI_MESSAGE)) {
            nms.sendActionBarMiniMessage(player, replacedPlaceholders);
        } else if (this.messageType.equals((Object)MessageType.BROADCAST)) {
            for (Player online : Bukkit.getOnlinePlayers()) {
                nms.sendMiniMessage(online, msg);
            }
        } else if (this.messageType.equals((Object)MessageType.BROADCAST_MINI_MESSAGE)) {
            nms.sendBroadcast(replacedPlaceholders);
        }
    }
}

