/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.XLeaderBoards.settings;

import io.github.InsiderAnh.XLeaderBoards.XLeaderBoard;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import lombok.Generated;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class InsiderConfig {
    private final YamlConfiguration config;
    private final File file;
    private final JavaPlugin javaPlugin;
    private final boolean comments;

    public InsiderConfig(JavaPlugin javaPlugin, String s, boolean defaults, boolean comments) {
        this(javaPlugin, s, defaults, comments, false);
    }

    public InsiderConfig(JavaPlugin javaPlugin, String s, boolean defaults, boolean comments, boolean reset) {
        this.javaPlugin = javaPlugin;
        this.comments = comments;
        this.file = new File(javaPlugin.getDataFolder(), s + ".yml");
        if (reset) {
            this.file.delete();
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        try {
            if (!this.file.exists()) {
                this.file.createNewFile();
                InputStreamReader reader = comments ? new InputStreamReader(this.getConfigContent(new InputStreamReader(javaPlugin.getResource(s + ".yml"), StandardCharsets.UTF_8))) : new InputStreamReader(javaPlugin.getResource(s + ".yml"), StandardCharsets.UTF_8);
                YamlConfiguration loadConfiguration = YamlConfiguration.loadConfiguration((Reader)reader);
                this.config.addDefaults((Configuration)loadConfiguration);
                this.config.options().copyDefaults(true);
                if (comments) {
                    this.save();
                } else {
                    this.config.save(this.file);
                }
            } else {
                if (defaults) {
                    InputStreamReader reader = comments ? new InputStreamReader(this.getConfigContent(new InputStreamReader(javaPlugin.getResource(s + ".yml"), StandardCharsets.UTF_8))) : new InputStreamReader(javaPlugin.getResource(s + ".yml"), StandardCharsets.UTF_8);
                    YamlConfiguration loadConfiguration = YamlConfiguration.loadConfiguration((Reader)reader);
                    this.config.addDefaults((Configuration)loadConfiguration);
                    this.config.options().copyDefaults(true);
                    if (comments) {
                        this.save();
                    } else {
                        this.config.save(this.file);
                    }
                }
                this.config.load(this.file);
            }
        }
        catch (IOException | InvalidConfigurationException throwable) {
            // empty catch block
        }
    }

    public void reload() {
        try {
            this.config.load(this.file);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }

    public InputStream getConfigContent(Reader reader) {
        try {
            String currentLine;
            String pluginName = this.javaPlugin.getDescription().getName();
            int commentNum = 0;
            StringBuilder whole = new StringBuilder();
            BufferedReader bufferedReader = new BufferedReader(reader);
            while ((currentLine = bufferedReader.readLine()) != null) {
                if (currentLine.startsWith("#")) {
                    String addLine = currentLine.replaceFirst("#", pluginName + "_COMMENT_" + commentNum + ":");
                    whole.append(addLine).append("\n");
                    ++commentNum;
                    continue;
                }
                whole.append(currentLine).append("\n");
            }
            String config = whole.toString();
            ByteArrayInputStream configStream = new ByteArrayInputStream(config.getBytes(StandardCharsets.UTF_8));
            bufferedReader.close();
            return configStream;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String prepareConfigString(String configString) {
        String[] lines = configString.split("\n");
        StringBuilder config = new StringBuilder();
        for (String line : lines) {
            if (line.startsWith(this.javaPlugin.getDescription().getName() + "_COMMENT")) {
                String comment = "#" + line.trim().substring(line.indexOf(":") + 1);
                String normalComment = comment.startsWith("# ' ") ? comment.substring(0, comment.length() - 1).replaceFirst("# ' ", "# ") : comment;
                config.append(normalComment).append("\n");
                continue;
            }
            config.append(line).append("\n");
        }
        return config.toString();
    }

    public void save() {
        if (this.comments) {
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(this.file));
                writer.write(this.prepareConfigString(this.config.saveToString()));
                writer.flush();
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                this.config.save(this.file);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public String getString(String path) {
        if (this.config.getString(path) == null) {
            return "No path found " + path;
        }
        return XLeaderBoard.getInstance().getColorUtils().color(this.config.getString(path));
    }

    public String getStringOrDefault(String path, String def) {
        if (this.config.isSet(path)) {
            return this.getString(path);
        }
        this.set(path, def);
        this.save();
        return def;
    }

    public int getInt(String path) {
        return this.config.getInt(path);
    }

    public int getIntOrDefault(String path, int def) {
        if (this.config.isSet(path)) {
            return this.getInt(path);
        }
        this.set(path, def);
        this.save();
        return def;
    }

    public long getLong(String path) {
        return this.config.getLong(path);
    }

    public long getLongOrDefault(String path, long def) {
        if (this.config.isSet(path)) {
            return this.getLong(path);
        }
        this.set(path, def);
        this.save();
        return def;
    }

    public double getDouble(String path) {
        return this.config.getInt(path);
    }

    public double getDoubleOrDefault(String path, double def) {
        if (this.config.isSet(path)) {
            return this.getDouble(path);
        }
        this.set(path, def);
        this.save();
        return def;
    }

    public List<String> getList(String path) {
        return this.config.getStringList(path);
    }

    public List<String> getListOrDefault(String path, List<String> def) {
        if (this.config.isSet(path)) {
            return this.getList(path);
        }
        this.set(path, def);
        this.save();
        return def;
    }

    public boolean isSet(String path) {
        return this.config.isSet(path);
    }

    public void set(String path, Object o) {
        this.config.set(path, o);
    }

    public boolean getBoolean(String path) {
        return this.config.getBoolean(path);
    }

    public boolean getBooleanOrDefault(String path, boolean def) {
        if (this.config.isSet(path)) {
            return this.getBoolean(path);
        }
        this.set(path, def);
        this.save();
        return def;
    }

    @Generated
    public YamlConfiguration getConfig() {
        return this.config;
    }
}

