/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.XLeaderBoards;

import com.cjcrafter.foliascheduler.util.MinecraftVersions;
import com.cjcrafter.foliascheduler.util.ServerVersions;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.github.InsiderAnh.XLeaderBoards.api.ColorUtils;
import io.github.InsiderAnh.XLeaderBoards.api.nms.NMS;
import io.github.InsiderAnh.XLeaderBoards.bstats.MetricsLite;
import io.github.InsiderAnh.XLeaderBoards.commands.XLeaderboardCMD;
import io.github.InsiderAnh.XLeaderBoards.database.LeaderDatabase;
import io.github.InsiderAnh.XLeaderBoards.enums.MinecraftVersion;
import io.github.InsiderAnh.XLeaderBoards.hooks.StellarTaskHook;
import io.github.InsiderAnh.XLeaderBoards.hooks.tasks.BukkitTaskHook;
import io.github.InsiderAnh.XLeaderBoards.hooks.tasks.FoliaTaskHook;
import io.github.InsiderAnh.XLeaderBoards.listeners.TopListener;
import io.github.InsiderAnh.XLeaderBoards.managers.ConfigManager;
import io.github.InsiderAnh.XLeaderBoards.managers.PlayerManager;
import io.github.InsiderAnh.XLeaderBoards.managers.RewardManager;
import io.github.InsiderAnh.XLeaderBoards.managers.TopManager;
import io.github.InsiderAnh.XLeaderBoards.placeholders.TopPlaceholders;
import io.github.InsiderAnh.XLeaderBoards.settings.InsiderConfig;
import io.github.InsiderAnh.XLeaderBoards.utils.UpdateChecker;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class XLeaderBoard
extends JavaPlugin {
    private static XLeaderBoard instance;
    private final ListeningExecutorService executor;
    private final TopManager topManager;
    private final ConfigManager configManager;
    private final TopListener topListener;
    private final PlayerManager playerManager;
    private final RewardManager rewardManager;
    private final LeaderDatabase leaderDatabase;
    private InsiderConfig lang;
    private NMS nms;
    private ColorUtils colorUtils;
    private MetricsLite metrics;
    private UpdateChecker updateChecker;
    private String version;
    private MinecraftVersion localVersion;
    private String completer;

    public XLeaderBoard() {
        instance = this;
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(2, 2, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1024)));
        this.topManager = new TopManager();
        this.configManager = new ConfigManager();
        this.leaderDatabase = new LeaderDatabase();
        this.topListener = new TopListener();
        this.playerManager = new PlayerManager();
        this.rewardManager = new RewardManager();
    }

    public void onEnable() {
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        this.loadNMS();
        this.lang = new InsiderConfig(this, "lang", true, false);
        this.configManager.load();
        this.leaderDatabase.connect();
        this.topManager.load();
        this.rewardManager.load();
        this.getServer().getPluginManager().registerEvents((Listener)this.topListener, (Plugin)this);
        if (this.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            new TopPlaceholders().register();
        }
        this.getCommand("xleaderboards").setExecutor((CommandExecutor)new XLeaderboardCMD());
        try {
            this.metrics = new MetricsLite((Plugin)this, 23638);
        }
        catch (Exception exception) {
            this.getLogger().info("Failed to load bStats.");
        }
        if (!this.configManager.isCheckUpdates()) {
            return;
        }
        this.updateChecker = new UpdateChecker();
    }

    public void reload() {
        this.lang.reload();
        this.reloadConfig();
        this.configManager.load();
        this.topManager.load();
        this.rewardManager.load();
    }

    public void onDisable() {
        this.leaderDatabase.close();
    }

    public StellarTaskHook getStellarTaskHook(Runnable runnable) {
        if (MinecraftVersions.WILD_UPDATE.isAtLeast() && ServerVersions.isFolia()) {
            return new FoliaTaskHook(runnable);
        }
        return new BukkitTaskHook(runnable);
    }

    public void loadNMS() {
        String cbPackage = Bukkit.getServer().getClass().getPackage().getName();
        String detectedVersion = cbPackage.substring(cbPackage.lastIndexOf(46) + 1);
        if (!detectedVersion.startsWith("v")) {
            detectedVersion = Bukkit.getServer().getBukkitVersion();
        }
        this.version = detectedVersion;
        this.localVersion = MinecraftVersion.get(this.version);
        if (this.localVersion == null) {
            Bukkit.getLogger().warning("[XLeaderBoards] No found Minecraft version " + this.version + ". If you want to support this version, contact InsiderAnh.");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.completer = this.localVersion.equals((Object)MinecraftVersion.v1_8) ? "1_8_R3" : (this.localVersion.equals((Object)MinecraftVersion.v1_9) ? "1_9_R4" : (this.localVersion.equals((Object)MinecraftVersion.v1_12) ? "1_12_R2" : (this.localVersion.equals((Object)MinecraftVersion.v1_13) ? "1_13_R2" : (this.localVersion.equals((Object)MinecraftVersion.v1_16) ? "1_16_R5" : (this.localVersion.equals((Object)MinecraftVersion.v1_17) ? "1_17_R1" : this.localVersion.name().substring(1))))));
        this.nms = Class.forName("io.github.InsiderAnh.XLeaderBoards.nms.v" + this.completer + ".NMS_" + this.completer).asSubclass(NMS.class).getConstructor(new Class[0]).newInstance(new Object[0]);
        this.colorUtils = Class.forName("io.github.InsiderAnh.XLeaderBoards.nms.v" + this.completer + ".ColorUtils_" + this.completer).asSubclass(ColorUtils.class).getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public void sendDebugMessage(String ... messages) {
        if (!this.getConfigManager().isDebug()) {
            return;
        }
        for (String message : messages) {
            this.getServer().getConsoleSender().sendMessage("\u00a7a[XLeaderBoards] \u00a7f" + message.replaceAll("&", "\u00a7"));
        }
    }

    @Generated
    public ListeningExecutorService getExecutor() {
        return this.executor;
    }

    @Generated
    public TopManager getTopManager() {
        return this.topManager;
    }

    @Generated
    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    @Generated
    public TopListener getTopListener() {
        return this.topListener;
    }

    @Generated
    public PlayerManager getPlayerManager() {
        return this.playerManager;
    }

    @Generated
    public RewardManager getRewardManager() {
        return this.rewardManager;
    }

    @Generated
    public LeaderDatabase getLeaderDatabase() {
        return this.leaderDatabase;
    }

    @Generated
    public InsiderConfig getLang() {
        return this.lang;
    }

    @Generated
    public NMS getNms() {
        return this.nms;
    }

    @Generated
    public ColorUtils getColorUtils() {
        return this.colorUtils;
    }

    @Generated
    public MetricsLite getMetrics() {
        return this.metrics;
    }

    @Generated
    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public MinecraftVersion getLocalVersion() {
        return this.localVersion;
    }

    @Generated
    public String getCompleter() {
        return this.completer;
    }

    @Generated
    public static XLeaderBoard getInstance() {
        return instance;
    }
}

