/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.XLeaderBoards.database.types;

import io.github.InsiderAnh.XLeaderBoards.XLeaderBoard;
import io.github.InsiderAnh.XLeaderBoards.database.repositories.DatabaseConnection;
import io.github.InsiderAnh.XLeaderBoards.database.repositories.PlayerRepository;
import io.github.InsiderAnh.XLeaderBoards.database.repositories.TopRepository;
import io.github.InsiderAnh.XLeaderBoards.database.types.mongo.PlayerRepositoryMongo;
import io.github.InsiderAnh.XLeaderBoards.database.types.mongo.TopRepositoryMongo;
import io.github.InsiderAnh.XLeaderBoards.libs.bson.Document;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.ConnectionString;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.client.MongoClient;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.client.MongoClients;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.client.MongoCollection;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.client.MongoDatabase;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.client.model.IndexOptions;
import lombok.Generated;

public class MongoConnection
implements DatabaseConnection {
    private final XLeaderBoard leaderBoard = XLeaderBoard.getInstance();
    private PlayerRepository playerRepository;
    private TopRepository topRepository;
    private MongoClient mongoClient;
    private MongoCollection<Document> tops;
    private MongoCollection<Document> topsRanking;

    @Override
    public void connect() {
        if (this.mongoClient != null) {
            this.mongoClient.close();
        }
        String databaseId = this.leaderBoard.getConfig().getString("databaseId");
        String connectionString = "mongodb://" + this.leaderBoard.getConfig().getString("databases.mongodb.user") + ":" + this.leaderBoard.getConfig().getString("databases.mongodb.password") + "@" + this.leaderBoard.getConfig().getString("databases.mongodb.host") + ":" + this.leaderBoard.getConfig().getInt("databases.mongodb.port");
        try {
            this.mongoClient = MongoClients.create(new ConnectionString(connectionString));
            MongoDatabase mongoDatabase = this.mongoClient.getDatabase(this.leaderBoard.getConfig().getString("databases.mongodb.database", "leaderboards"));
            this.tops = mongoDatabase.getCollection(databaseId);
            this.topsRanking = mongoDatabase.getCollection(databaseId + "_ranking");
            this.playerRepository = new PlayerRepositoryMongo(mongoDatabase);
            this.topRepository = new TopRepositoryMongo(mongoDatabase);
            this.leaderBoard.getLogger().info("Connected to Mongo database correctly.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.leaderBoard.getLogger().warning("Error on connect to Mongo database.");
        }
    }

    @Override
    public void createIndexes() {
        this.tops.createIndex(new Document("uuid", 1), new IndexOptions().unique(true));
        this.topsRanking.createIndex(new Document("uuid", 1), new IndexOptions().unique(true));
    }

    @Override
    public void close() {
        if (this.mongoClient != null) {
            this.mongoClient.close();
        }
    }

    @Override
    public PlayerRepository getPlayerRepository() {
        return this.playerRepository;
    }

    @Override
    public TopRepository getTopRepository() {
        return this.topRepository;
    }

    @Generated
    public MongoCollection<Document> getTops() {
        return this.tops;
    }

    @Generated
    public MongoCollection<Document> getTopsRanking() {
        return this.topsRanking;
    }
}

