/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.XLeaderBoards.database.types;

import io.github.InsiderAnh.XLeaderBoards.XLeaderBoard;
import io.github.InsiderAnh.XLeaderBoards.database.repositories.DatabaseConnection;
import io.github.InsiderAnh.XLeaderBoards.database.repositories.PlayerRepository;
import io.github.InsiderAnh.XLeaderBoards.database.repositories.TopRepository;
import io.github.InsiderAnh.XLeaderBoards.database.types.mysql.PlayerRepositoryMySQL;
import io.github.InsiderAnh.XLeaderBoards.database.types.mysql.TopRepositoryMySQL;
import io.github.InsiderAnh.XLeaderBoards.libs.hikaricp.HikariConfig;
import io.github.InsiderAnh.XLeaderBoards.libs.hikaricp.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class MySQLConnection
implements DatabaseConnection {
    private final XLeaderBoard leaderBoard = XLeaderBoard.getInstance();
    private PlayerRepository playerRepository;
    private TopRepository topRepository;
    private HikariDataSource dataSource;

    @Override
    public void connect() {
        try {
            HikariConfig config = new HikariConfig();
            config.setJdbcUrl("jdbc:mysql://" + this.leaderBoard.getConfig().getString("databases.mysql.host") + ":" + this.leaderBoard.getConfig().getInt("databases.mysql.port") + "/" + this.leaderBoard.getConfig().getString("databases.mysql.database"));
            config.setUsername(this.leaderBoard.getConfig().getString("databases.mysql.user"));
            config.setPassword(this.leaderBoard.getConfig().getString("databases.mysql.password"));
            config.addDataSourceProperty("cachePrepStmts", "true");
            config.addDataSourceProperty("prepStmtCacheSize", "250");
            config.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
            config.addDataSourceProperty("autoReconnect", "true");
            config.addDataSourceProperty("leakDetectionThreshold", "true");
            config.addDataSourceProperty("verifyServerCertificate", "false");
            config.addDataSourceProperty("useSSL", "false");
            config.setMaximumPoolSize(10);
            config.setConnectionTimeout(250L);
            config.setLeakDetectionThreshold(60000L);
            this.dataSource = new HikariDataSource(config);
            try (Connection connection = this.dataSource.getConnection();
                 Statement statement = connection.createStatement();){
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS player_metrics (id BIGINT AUTO_INCREMENT PRIMARY KEY,playerId VARCHAR(36) NOT NULL,playerName VARCHAR(255) NOT NULL,key_type VARCHAR(50) NOT NULL,period VARCHAR(20) NOT NULL,value BIGINT NOT NULL DEFAULT 0,last_updated TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,UNIQUE KEY unique_player_metric (playerId, key_type, period)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS player_rewards (id BIGINT PRIMARY KEY AUTO_INCREMENT,playerId TEXT NOT NULL,playerName TEXT NOT NULL,data TEXT NOT NULL);");
                statement.execute("SET SESSION innodb_flush_log_at_trx_commit = 2");
                statement.execute("SET SESSION sql_log_bin = 0");
                statement.execute("SET SESSION foreign_key_checks = 0");
                statement.execute("SET SESSION unique_checks = 0");
                statement.execute("SET SESSION autocommit = 0");
            }
            catch (SQLException e) {
                this.leaderBoard.getLogger().warning("Error on create table player_metrics: " + e.getMessage());
            }
            this.playerRepository = new PlayerRepositoryMySQL(this.dataSource);
            this.topRepository = new TopRepositoryMySQL(this.dataSource);
            this.leaderBoard.getLogger().info("Connected to MySQL database correctly.");
        }
        catch (Exception exception) {
            this.leaderBoard.getLogger().warning("Error on connect to MySQL database.");
        }
    }

    @Override
    public void createIndexes() {
        try (Connection connection = this.dataSource.getConnection();
             Statement stmt = connection.createStatement();){
            stmt.execute("CREATE INDEX IF NOT EXISTS idx_key_period_value ON player_metrics (key_type, period, value DESC)");
            stmt.execute("CREATE INDEX IF NOT EXISTS idx_player_key_period ON player_metrics (playerId, key_type, period)");
            stmt.execute("CREATE INDEX IF NOT EXISTS idx_period_updated ON player_metrics (period, last_updated)");
            stmt.execute("CREATE INDEX IF NOT EXISTS idx_player_name ON player_metrics (playerName)");
        }
        catch (SQLException e) {
            this.leaderBoard.getLogger().info("Failed to create indexes");
        }
    }

    @Override
    public void close() {
        this.dataSource.close();
    }

    @Override
    public PlayerRepository getPlayerRepository() {
        return this.playerRepository;
    }

    @Override
    public TopRepository getTopRepository() {
        return this.topRepository;
    }
}

