/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.XLeaderBoards.database.types;

import io.github.InsiderAnh.XLeaderBoards.XLeaderBoard;
import io.github.InsiderAnh.XLeaderBoards.database.repositories.DatabaseConnection;
import io.github.InsiderAnh.XLeaderBoards.database.repositories.PlayerRepository;
import io.github.InsiderAnh.XLeaderBoards.database.repositories.TopRepository;
import io.github.InsiderAnh.XLeaderBoards.database.types.sql.PlayerRepositorySQL;
import io.github.InsiderAnh.XLeaderBoards.database.types.sql.TopRepositorySQL;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;

public class SQLConnection
implements DatabaseConnection {
    private final XLeaderBoard leaderBoard = XLeaderBoard.getInstance();
    private PlayerRepository playerRepository;
    private TopRepository topRepository;
    private Connection connection;

    @Override
    public void connect() {
        try {
            File dbFile = new File(this.leaderBoard.getDataFolder(), this.leaderBoard.getConfig().getString("databases.h2.database") + ".db");
            if (!dbFile.exists()) {
                dbFile.createNewFile();
            }
            Class.forName("org.sqlite.JDBC");
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + dbFile);
            try (Statement statement = this.connection.createStatement();){
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS player_metrics (id INTEGER PRIMARY KEY AUTOINCREMENT,playerId TEXT NOT NULL,playerName TEXT NOT NULL,key_type TEXT NOT NULL,period TEXT NOT NULL,value INTEGER NOT NULL DEFAULT 0,last_updated DATETIME DEFAULT CURRENT_TIMESTAMP,created_at DATETIME DEFAULT CURRENT_TIMESTAMP,UNIQUE(playerId, key_type, period));");
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS player_rewards (id INTEGER PRIMARY KEY AUTOINCREMENT,playerId TEXT NOT NULL,playerName TEXT NOT NULL,data TEXT NOT NULL);");
                statement.executeUpdate("CREATE TRIGGER IF NOT EXISTS update_last_updated AFTER UPDATE ON player_metrics FOR EACH ROW BEGIN UPDATE player_metrics SET last_updated = CURRENT_TIMESTAMP WHERE id = NEW.id; END;");
            }
            try (Statement stmt = this.connection.createStatement();){
                stmt.execute("PRAGMA journal_mode = WAL");
                stmt.execute("PRAGMA synchronous = NORMAL");
                stmt.execute("PRAGMA cache_size = 10000");
                stmt.execute("PRAGMA temp_store = MEMORY");
            }
            this.playerRepository = new PlayerRepositorySQL(this.connection);
            this.topRepository = new TopRepositorySQL(this.connection);
            this.leaderBoard.getLogger().info("Connected to SQLite database correctly.");
        }
        catch (Exception exception) {
            this.leaderBoard.getLogger().warning("Error on connect to SQLite database " + exception.getMessage());
        }
    }

    @Override
    public void createIndexes() {
        try (Statement stmt = this.connection.createStatement();){
            stmt.execute("CREATE INDEX IF NOT EXISTS idx_key_period_value ON player_metrics (key_type, period, value DESC)");
            stmt.execute("CREATE INDEX IF NOT EXISTS idx_player_key_period ON player_metrics (playerId, key_type, period)");
            stmt.execute("CREATE INDEX IF NOT EXISTS idx_period_updated ON player_metrics (period, last_updated)");
            stmt.execute("CREATE INDEX IF NOT EXISTS idx_player_name ON player_metrics (playerName)");
            stmt.execute("CREATE INDEX IF NOT EXISTS idx_player_rewards_playerId ON player_rewards(playerId);");
        }
        catch (SQLException e) {
            this.leaderBoard.getLogger().info("Failed to create indexes");
        }
    }

    @Override
    public void close() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                this.leaderBoard.getLogger().warning("Error on close SQLite connection: " + e.getMessage());
            }
        }
    }

    @Override
    public PlayerRepository getPlayerRepository() {
        return this.playerRepository;
    }

    @Override
    public TopRepository getTopRepository() {
        return this.topRepository;
    }
}

