/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.XLeaderBoards.managers;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.github.InsiderAnh.XLeaderBoards.XLeaderBoard;
import io.github.InsiderAnh.XLeaderBoards.hooks.tasks.TaskCanceller;
import io.github.InsiderAnh.XLeaderBoards.libs.bson.Document;
import io.github.InsiderAnh.XLeaderBoards.settings.InsiderConfig;
import io.github.InsiderAnh.XLeaderBoards.tops.Ranking;
import io.github.InsiderAnh.XLeaderBoards.tops.TopData;
import io.github.InsiderAnh.XLeaderBoards.tops.TopDate;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class TopManager {
    private final XLeaderBoard plugin = XLeaderBoard.getInstance();
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy kk:mm:ss");
    private final HashMap<String, TopData> topData = new HashMap();
    private final HashMap<String, Document> tops = new HashMap();
    private InsiderConfig topsConfig;
    private TopDate topDate;
    private ListeningExecutorService topExecutor;
    private TaskCanceller updateTask;

    public void load() {
        if (this.updateTask != null) {
            this.updateTask.cancel();
        }
        if (this.topsConfig == null) {
            this.topsConfig = new InsiderConfig(this.plugin, "tops", false, false);
        } else {
            this.topsConfig.reload();
        }
        try {
            long nextDaily = this.topsConfig.getLongOrDefault("topDate.nextDaily", 0L);
            long nextWeekly = this.topsConfig.getLongOrDefault("topDate.nextWeekly", 0L);
            long nextMonthly = this.topsConfig.getLongOrDefault("topDate.nextMonthly", 0L);
            long nextDailyTop = this.topsConfig.getLongOrDefault("topDate.nextDailyTop", 0L);
            long nextWeeklyTop = this.topsConfig.getLongOrDefault("topDate.nextWeeklyTop", 0L);
            long nextMonthlyTop = this.topsConfig.getLongOrDefault("topDate.nextMonthlyTop", 0L);
            long nextPermanentTop = this.topsConfig.getLongOrDefault("topDate.nextPermanentTop", 0L);
            long lastDailyReset = this.topsConfig.getLongOrDefault("topDate.lastDailyReset", 0L);
            long lastWeeklyReset = this.topsConfig.getLongOrDefault("topDate.lastWeeklyReset", 0L);
            long lastMonthlyReset = this.topsConfig.getLongOrDefault("topDate.lastMonthlyReset", 0L);
            this.topDate = new TopDate(lastDailyReset, lastWeeklyReset, lastMonthlyReset, nextDaily, nextWeekly, nextMonthly, nextDailyTop, nextWeeklyTop, nextMonthlyTop, nextPermanentTop);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            try {
                long topTime = this.dateFormat.parse("06/09/2024 17:00:00").getTime();
                this.topDate = new TopDate(topTime, topTime, topTime, topTime, topTime, topTime, topTime, topTime, topTime, topTime);
            }
            catch (Exception exception1) {
                exception1.printStackTrace();
                this.topDate = new TopDate(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
            }
        }
        if (this.plugin.getConfig().isSet("tops")) {
            for (String key : this.plugin.getConfig().getConfigurationSection("tops").getKeys(false)) {
                TopData data = new TopData(key, this.plugin.getConfig().getString("tops." + key + ".placeholder"), this.plugin.getConfig().getString("tops." + key + ".name"));
                this.topData.put(key, data);
            }
        }
        this.topExecutor = MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(2, 2, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1024)));
        this.updateTask = this.plugin.getStellarTaskHook(() -> {
            this.updateTops();
            this.update();
        }).runTaskTimerAsynchronously(10L, this.plugin.getConfigManager().getTicksBetweenUpdates());
    }

    public void updateTops() {
        this.plugin.getPlayerManager().forceSave();
        int maxCachedTopEntries = this.plugin.getConfigManager().getMaxCachedTopEntries();
        this.topExecutor.execute(() -> {
            for (TopData data : this.topData.values()) {
                String topName = data.getName();
                this.updateTop("daily_" + topName, "data.daily." + topName, maxCachedTopEntries);
                this.updateTop("weekly_" + topName, "data.weekly." + topName, maxCachedTopEntries);
                this.updateTop("monthly_" + topName, "data.monthly." + topName, maxCachedTopEntries);
                this.updateTop("permanent_" + topName, "data.permanent." + topName, maxCachedTopEntries);
            }
        });
    }

    public void updateTop(String key, String path, int entries) {
        this.getTops().put(key, this.getTop(path, entries));
    }

    public void updateDailyRankings() {
        LinkedList<Ranking> rankings = new LinkedList<Ranking>();
        this.fillDailyRankings(rankings);
        ListeningExecutorService rankingExecutor = MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(1, 2, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1024)));
        if (this.plugin.getConfigManager().isSaveTopOnUpdate()) {
            rankingExecutor.execute(() -> this.plugin.getPlayerManager().forceSaveSync());
        }
        for (Ranking ranking : rankings) {
            rankingExecutor.execute(() -> {
                this.updateRanking("tops", ranking.getSortKey(), ranking.getKeyword());
                this.updateTop("daily_" + ranking.getTopKey(), "data.daily." + ranking.getTopKey(), this.plugin.getConfigManager().getMaxCachedTopEntries());
            });
        }
        rankingExecutor.execute(() -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.isOnline()) continue;
                this.plugin.getPlayerManager().loadPlayer(player);
            }
        });
        rankingExecutor.shutdown();
    }

    public void updateWeeklyRankings() {
        LinkedList<Ranking> rankings = new LinkedList<Ranking>();
        this.fillWeeklyRankings(rankings);
        ListeningExecutorService rankingExecutor = MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(1, 2, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1024)));
        if (this.plugin.getConfigManager().isSaveTopOnUpdate()) {
            rankingExecutor.execute(() -> this.plugin.getPlayerManager().forceSaveSync());
        }
        for (Ranking ranking : rankings) {
            rankingExecutor.execute(() -> {
                this.updateRanking("tops", ranking.getSortKey(), ranking.getKeyword());
                this.updateTop("weekly_" + ranking.getTopKey(), "data.weekly." + ranking.getTopKey(), this.plugin.getConfigManager().getMaxCachedTopEntries());
            });
        }
        rankingExecutor.execute(() -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.isOnline()) continue;
                this.plugin.getPlayerManager().loadPlayer(player);
            }
        });
        rankingExecutor.shutdown();
    }

    public void updateMonthlyRankings() {
        LinkedList<Ranking> rankings = new LinkedList<Ranking>();
        this.fillMonthlyRankings(rankings);
        ListeningExecutorService rankingExecutor = MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(1, 2, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1024)));
        if (this.plugin.getConfigManager().isSaveTopOnUpdate()) {
            rankingExecutor.execute(() -> this.plugin.getPlayerManager().forceSaveSync());
        }
        for (Ranking ranking : rankings) {
            rankingExecutor.execute(() -> {
                this.updateRanking("tops", ranking.getSortKey(), ranking.getKeyword());
                this.updateTop("monthly_" + ranking.getTopKey(), "data.monthly." + ranking.getTopKey(), this.plugin.getConfigManager().getMaxCachedTopEntries());
            });
        }
        rankingExecutor.execute(() -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.isOnline()) continue;
                this.plugin.getPlayerManager().loadPlayer(player);
            }
        });
        rankingExecutor.shutdown();
    }

    public void updatePermanentRankings() {
        LinkedList<Ranking> rankings = new LinkedList<Ranking>();
        this.fillPermanentRankings(rankings);
        ListeningExecutorService rankingExecutor = MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(2, 2, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1024)));
        for (Ranking ranking : rankings) {
            rankingExecutor.execute(() -> {
                this.updateRanking("tops", ranking.getSortKey(), ranking.getKeyword());
                this.updateTop("permanent_" + ranking.getTopKey(), "data.permanent." + ranking.getTopKey(), this.plugin.getConfigManager().getMaxCachedTopEntries());
            });
        }
        rankingExecutor.execute(() -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.isOnline()) continue;
                this.plugin.getPlayerManager().loadPlayerRanking(player);
            }
        });
        rankingExecutor.shutdown();
    }

    void fillDailyRankings(LinkedList<Ranking> rankings) {
        for (TopData data : this.topData.values()) {
            String topName = data.getName();
            rankings.add(new Ranking("data.daily." + topName, "data.ranking.daily_" + topName, "daily", topName));
        }
    }

    void fillWeeklyRankings(LinkedList<Ranking> rankings) {
        for (TopData data : this.topData.values()) {
            String topName = data.getName();
            rankings.add(new Ranking("data.weekly." + topName, "data.ranking.weekly_" + topName, "weekly", topName));
        }
    }

    void fillMonthlyRankings(LinkedList<Ranking> rankings) {
        for (TopData data : this.topData.values()) {
            String topName = data.getName();
            rankings.add(new Ranking("data.monthly." + topName, "data.ranking.monthly_" + topName, "monthly", topName));
        }
    }

    void fillPermanentRankings(LinkedList<Ranking> rankings) {
        for (TopData data : this.topData.values()) {
            String topName = data.getName();
            rankings.add(new Ranking("data.permanent." + topName, "data.ranking.permanent_" + topName, "permanent", topName));
        }
    }

    public Document getTop(String pathData, int entries) {
        return this.plugin.getLeaderDatabase().getTopRepository().getTop(pathData, entries);
    }

    private void updateRanking(String database, String sortKey, String keyword) {
        this.plugin.getLeaderDatabase().getTopRepository().updateRanking(database, sortKey, keyword);
    }

    public void resetDateTop(String key, String top, boolean giveReward) {
        if (giveReward) {
            for (TopData data : this.topData.values()) {
                this.plugin.getRewardManager().checkTopRewards(data.getName(), this.getTops().get(top + "_" + data.getName()));
            }
        }
        this.plugin.getLeaderDatabase().getTopRepository().resetDateTop(key, top, this.topDate);
    }

    public void forceResetTop(String key, String top, boolean giveReward) {
        this.resetDateTop(key, top, giveReward);
        switch (top) {
            case "daily": {
                this.updateDailyRankings();
                break;
            }
            case "weekly": {
                this.updateWeeklyRankings();
                break;
            }
            case "monthly": {
                this.updateMonthlyRankings();
            }
        }
    }

    public void update() {
        this.checkAndUpdateReset("daily", 1, 5, this.topDate.getNextDaily(), () -> {
            this.saveDateTop();
            this.resetDateTop("data.daily", "daily", true);
        });
        this.checkAndUpdateReset("weekly", 7, 5, this.topDate.getNextWeekly(), () -> {
            this.saveDateTop();
            this.resetDateTop("data.weekly", "weekly", true);
        });
        this.checkAndUpdateReset("monthly", 1, 2, this.topDate.getNextMonthly(), () -> {
            this.saveDateTop();
            this.resetDateTop("data.monthly", "monthly", true);
        });
        this.checkAndUpdateTop("daily", this.plugin.getConfigManager().getDailyMinutes(), 12, this.topDate.getNextDailyTop(), this::updateDailyRankings);
        this.checkAndUpdateTop("weekly", this.plugin.getConfigManager().getWeeklyMinutes(), 12, this.topDate.getNextWeeklyTop(), this::updateWeeklyRankings);
        this.checkAndUpdateTop("monthly", this.plugin.getConfigManager().getMonthlyHours(), 11, this.topDate.getNextMonthlyTop(), this::updateMonthlyRankings);
        this.checkAndUpdateTop("permanent", this.plugin.getConfigManager().getPermanentHours(), 11, this.topDate.getNextPermanentTop(), this::updatePermanentRankings);
    }

    private void checkAndUpdateReset(String period, int amount, int calendarField, long nextResetTime, Runnable task) {
        if (nextResetTime < System.currentTimeMillis()) {
            this.updateLastReset(period);
            Calendar calendar = this.dateFormat.getCalendar();
            calendar.setTime(new Date());
            try {
                calendar.add(calendarField, amount);
                Date nextResetDate = this.dateFormat.parse(calendar.get(5) + "/" + (calendar.get(2) + 1) + "/" + calendar.get(1) + " 17:00:00");
                this.setNextReset(period, nextResetDate.getTime());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.topExecutor.execute(task);
        }
    }

    private void checkAndUpdateTop(String period, int amount, int calendarField, long nextTopTime, Runnable rankingTask) {
        if (nextTopTime < System.currentTimeMillis()) {
            Calendar calendar = this.dateFormat.getCalendar();
            calendar.setTime(new Date());
            try {
                calendar.add(calendarField, amount);
                Date nextTopDate = this.dateFormat.parse(calendar.get(5) + "/" + (calendar.get(2) + 1) + "/" + calendar.get(1) + " " + calendar.get(11) + ":" + calendar.get(12) + ":00");
                this.setNextTop(period, nextTopDate.getTime());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.topExecutor.execute(() -> {
                this.saveDateTop();
                rankingTask.run();
            });
        }
    }

    private void updateLastReset(String period) {
        switch (period) {
            case "daily": {
                this.topDate.setLastDailyReset(this.topDate.getNextDaily());
                break;
            }
            case "weekly": {
                this.topDate.setLastWeeklyReset(this.topDate.getNextWeekly());
                break;
            }
            case "monthly": {
                this.topDate.setLastMonthlyReset(this.topDate.getNextMonthly());
            }
        }
    }

    private void setNextReset(String period, long time) {
        switch (period) {
            case "daily": {
                this.topDate.setNextDaily(time);
                break;
            }
            case "weekly": {
                this.topDate.setNextWeekly(time);
                break;
            }
            case "monthly": {
                this.topDate.setNextMonthly(time);
            }
        }
    }

    private void setNextTop(String period, long time) {
        switch (period) {
            case "daily": {
                this.topDate.setNextDailyTop(time);
                break;
            }
            case "weekly": {
                this.topDate.setNextWeeklyTop(time);
                break;
            }
            case "monthly": {
                this.topDate.setNextMonthlyTop(time);
                break;
            }
            case "permanent": {
                this.topDate.setNextPermanentTop(time);
            }
        }
    }

    public void saveDateTop() {
        this.topsConfig.set("topDate.nextDaily", this.topDate.getNextDaily());
        this.topsConfig.set("topDate.nextWeekly", this.topDate.getNextWeekly());
        this.topsConfig.set("topDate.nextMonthly", this.topDate.getNextMonthly());
        this.topsConfig.set("topDate.nextDailyTop", this.topDate.getNextDailyTop());
        this.topsConfig.set("topDate.nextWeeklyTop", this.topDate.getNextWeeklyTop());
        this.topsConfig.set("topDate.nextMonthlyTop", this.topDate.getNextMonthlyTop());
        this.topsConfig.set("topDate.nextPermanentTop", this.topDate.getNextPermanentTop());
        this.topsConfig.set("topDate.lastDailyReset", this.topDate.getLastDailyReset());
        this.topsConfig.set("topDate.lastWeeklyReset", this.topDate.getLastWeeklyReset());
        this.topsConfig.set("topDate.lastMonthlyReset", this.topDate.getLastMonthlyReset());
        this.topsConfig.save();
    }

    @Generated
    public HashMap<String, TopData> getTopData() {
        return this.topData;
    }

    @Generated
    public HashMap<String, Document> getTops() {
        return this.tops;
    }

    @Generated
    public TopDate getTopDate() {
        return this.topDate;
    }
}

