/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.XLeaderBoards.database.types.sql;

import io.github.InsiderAnh.XLeaderBoards.XLeaderBoard;
import io.github.InsiderAnh.XLeaderBoards.database.repositories.TopRepository;
import io.github.InsiderAnh.XLeaderBoards.libs.bson.Document;
import io.github.InsiderAnh.XLeaderBoards.tops.TopDate;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicInteger;

public class TopRepositorySQL
implements TopRepository {
    private final XLeaderBoard leaderBoard = XLeaderBoard.getInstance();
    private final Connection connection;

    public TopRepositorySQL(Connection connection) {
        this.connection = connection;
    }

    @Override
    public Document getTop(String pathData, int entries) {
        Document totalTop = new Document();
        AtomicInteger index = new AtomicInteger(1);
        String[] pathParts = pathData.split("\\.");
        if (pathParts.length < 3) {
            return totalTop;
        }
        String period = pathParts[1];
        String keyType = pathParts[2];
        String query = "SELECT playerId, playerName, value FROM player_metrics WHERE period = ? AND key_type = ? AND value > 0 ORDER BY value DESC LIMIT ?";
        try (PreparedStatement stmt = this.connection.prepareStatement(query);){
            stmt.setString(1, period);
            stmt.setString(2, keyType);
            stmt.setInt(3, entries);
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    Document document = new Document();
                    document.put("uuid", (Object)rs.getString("playerId"));
                    document.put("name", (Object)rs.getString("playerName"));
                    document.put("amount", (Object)rs.getLong("value"));
                    totalTop.put(String.valueOf(index.getAndIncrement()), (Object)document);
                }
            }
        }
        catch (SQLException e) {
            this.leaderBoard.getLogger().info("Error on getTop: " + e.getMessage());
        }
        return totalTop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRanking(String database, String sortKey, String keyword) {
        long start = System.currentTimeMillis();
        String[] pathParts = sortKey.split("\\.");
        if (pathParts.length < 3) {
            return;
        }
        String replaced = keyword.replace("data.ranking.", "");
        String period = pathParts[1];
        String keyType = pathParts[2];
        String selectQuery = "SELECT playerId, playerName FROM player_metrics WHERE period = ? AND key_type = ? AND value > 0 ORDER BY value DESC";
        try {
            this.connection.setAutoCommit(false);
            String insertOrUpdate = "INSERT OR REPLACE INTO player_metrics (playerId, playerName, key_type, period, value) VALUES (?, ?, ?, 'ranking', ?)";
            try (PreparedStatement selectStmt = this.connection.prepareStatement(selectQuery);
                 PreparedStatement updateStmt = this.connection.prepareStatement(insertOrUpdate);){
                selectStmt.setString(1, period);
                selectStmt.setString(2, keyType);
                try (ResultSet rs = selectStmt.executeQuery();){
                    int rank = 0;
                    int batchCount = 0;
                    int BATCH_SIZE = 1000;
                    while (rs.next()) {
                        ++rank;
                        String playerId = rs.getString("playerId");
                        String playerName = rs.getString("playerName");
                        updateStmt.setString(1, playerId);
                        updateStmt.setString(2, playerName);
                        updateStmt.setString(3, replaced);
                        updateStmt.setLong(4, rank);
                        updateStmt.addBatch();
                        if (++batchCount != 1000) continue;
                        updateStmt.executeBatch();
                        batchCount = 0;
                    }
                    if (batchCount > 0) {
                        updateStmt.executeBatch();
                    }
                    this.connection.commit();
                    long end = System.currentTimeMillis();
                    this.leaderBoard.sendDebugMessage("Updated ranking " + sortKey + " in keyword " + keyword + " in " + (end - start) + "ms, total ranking " + rank + " in database " + database);
                }
            }
            catch (SQLException e) {
                this.connection.rollback();
                this.leaderBoard.getLogger().info("Error on updateRanking: " + e.getMessage());
            }
            finally {
                this.connection.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            this.leaderBoard.getLogger().info("Error on updateRanking: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetDateTop(String timeType, String topName, TopDate topDate) {
        try {
            this.connection.setAutoCommit(false);
            try {
                int deletedRankingRows;
                String[] periodsToDelete;
                switch (topName) {
                    case "daily": {
                        periodsToDelete = new String[]{"daily", "daily_registry"};
                        break;
                    }
                    case "weekly": {
                        periodsToDelete = new String[]{"weekly", "weekly_registry"};
                        break;
                    }
                    case "monthly": {
                        periodsToDelete = new String[]{"monthly", "monthly_registry"};
                        break;
                    }
                    default: {
                        periodsToDelete = new String[]{topName};
                    }
                }
                int totalDeleted = 0;
                for (String periodToDelete : periodsToDelete) {
                    String deletePeriod = "DELETE FROM player_metrics WHERE period = ?";
                    try (PreparedStatement deletePeriodStmt = this.connection.prepareStatement(deletePeriod);){
                        deletePeriodStmt.setString(1, periodToDelete);
                        int deletedRows = deletePeriodStmt.executeUpdate();
                        totalDeleted += deletedRows;
                        this.leaderBoard.sendDebugMessage("Deleted " + deletedRows + " entries for period '" + periodToDelete + "'");
                    }
                }
                String deleteRanking = "DELETE FROM player_metrics WHERE period = 'ranking' AND key_type LIKE ?";
                try (PreparedStatement deleteRankingStmt = this.connection.prepareStatement(deleteRanking);){
                    deleteRankingStmt.setString(1, topName + "_%");
                    deletedRankingRows = deleteRankingStmt.executeUpdate();
                    this.leaderBoard.sendDebugMessage("Deleted " + deletedRankingRows + " ranking entries for period starting with '" + topName + "_'");
                }
                this.leaderBoard.sendDebugMessage("Total deleted entries: " + (totalDeleted += deletedRankingRows));
                String insertOrUpdate = "INSERT OR REPLACE INTO player_metrics (playerId, playerName, key_type, period, value) VALUES (?, ?, ?, ?, ?)";
                String selectPlayers = "SELECT DISTINCT playerId, playerName FROM player_metrics";
                try (PreparedStatement selectStmt = this.connection.prepareStatement(selectPlayers);
                     PreparedStatement updateStmt = this.connection.prepareStatement(insertOrUpdate);
                     ResultSet rs = selectStmt.executeQuery();){
                    int batchCount = 0;
                    int BATCH_SIZE = 1000;
                    long currentTime = System.currentTimeMillis();
                    String resetPeriod = "";
                    long nextReset = 0L;
                    switch (topName) {
                        case "daily": {
                            resetPeriod = "next_daily_reset";
                            nextReset = topDate.getNextDaily();
                            break;
                        }
                        case "weekly": {
                            resetPeriod = "next_weekly_reset";
                            nextReset = topDate.getNextWeekly();
                            break;
                        }
                        case "monthly": {
                            resetPeriod = "next_monthly_reset";
                            nextReset = topDate.getNextMonthly();
                        }
                    }
                    while (rs.next()) {
                        String playerId = rs.getString("playerId");
                        String playerName = rs.getString("playerName");
                        updateStmt.setString(1, playerId);
                        updateStmt.setString(2, playerName);
                        updateStmt.setString(3, "reset_time");
                        updateStmt.setString(4, "last_" + topName + "_reset");
                        updateStmt.setLong(5, currentTime);
                        updateStmt.addBatch();
                        updateStmt.setString(1, playerId);
                        updateStmt.setString(2, playerName);
                        updateStmt.setString(3, "reset_time");
                        updateStmt.setString(4, resetPeriod);
                        updateStmt.setLong(5, nextReset);
                        updateStmt.addBatch();
                        if ((batchCount += 2) < 1000) continue;
                        updateStmt.executeBatch();
                        batchCount = 0;
                    }
                    if (batchCount > 0) {
                        updateStmt.executeBatch();
                    }
                }
                this.connection.commit();
                this.leaderBoard.sendDebugMessage("Successfully reset ALL keys for period '" + topName + "' and related registries and rankings - total entries deleted: " + totalDeleted);
            }
            catch (SQLException e) {
                this.connection.rollback();
                this.leaderBoard.sendDebugMessage("Error on resetDateTop: " + e.getMessage());
            }
            finally {
                this.connection.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

