/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.XLeaderBoards.libs.mongodb.internal.connection;

import io.github.InsiderAnh.XLeaderBoards.libs.bson.io.BsonOutput;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.assertions.Assertions;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.internal.connection.LegacyMessage;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.internal.connection.MessageSettings;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.internal.connection.OpCode;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.internal.connection.RequestMessage;
import java.util.List;

class KillCursorsMessage
extends LegacyMessage {
    private final List<Long> cursors;

    KillCursorsMessage(List<Long> cursors) {
        super(OpCode.OP_KILL_CURSORS, MessageSettings.builder().build());
        this.cursors = Assertions.notNull("cursors", cursors);
    }

    @Override
    protected RequestMessage.EncodingMetadata encodeMessageBodyWithMetadata(BsonOutput bsonOutput) {
        this.writeKillCursorsPrologue(this.cursors.size(), bsonOutput);
        for (Long cur : this.cursors) {
            bsonOutput.writeInt64(cur);
        }
        return new RequestMessage.EncodingMetadata(bsonOutput.getPosition());
    }

    private void writeKillCursorsPrologue(int numCursors, BsonOutput bsonOutput) {
        bsonOutput.writeInt32(0);
        bsonOutput.writeInt32(numCursors);
    }
}

