/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.XLeaderBoards.libs.mongodb.internal.operation;

import io.github.InsiderAnh.XLeaderBoards.libs.bson.BsonDocument;
import io.github.InsiderAnh.XLeaderBoards.libs.bson.BsonString;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.MongoException;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.MongoWriteConcernException;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.ServerAddress;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.WriteConcern;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.WriteConcernResult;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.bulk.WriteConcernError;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.connection.ConnectionDescription;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.internal.connection.ProtocolHelper;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.internal.operation.ServerVersionHelper;

public final class WriteConcernHelper {
    public static void appendWriteConcernToCommand(WriteConcern writeConcern, BsonDocument commandDocument, ConnectionDescription description) {
        if (writeConcern != null && !writeConcern.isServerDefault() && ServerVersionHelper.serverIsAtLeastVersionThreeDotFour(description)) {
            commandDocument.put("writeConcern", writeConcern.asDocument());
        }
    }

    public static void throwOnWriteConcernError(BsonDocument result, ServerAddress serverAddress) {
        if (WriteConcernHelper.hasWriteConcernError(result)) {
            WriteConcernHelper.throwOnSpecialException(result, serverAddress);
            throw WriteConcernHelper.createWriteConcernException(result, serverAddress);
        }
    }

    public static void throwOnSpecialException(BsonDocument result, ServerAddress serverAddress) {
        MongoException specialException = ProtocolHelper.createSpecialException(result, serverAddress, "errmsg");
        if (specialException != null) {
            throw specialException;
        }
    }

    public static boolean hasWriteConcernError(BsonDocument result) {
        return result.containsKey("writeConcernError");
    }

    public static MongoWriteConcernException createWriteConcernException(BsonDocument result, ServerAddress serverAddress) {
        return new MongoWriteConcernException(WriteConcernHelper.createWriteConcernError(result.getDocument("writeConcernError")), WriteConcernResult.acknowledged(0, false, null), serverAddress);
    }

    public static WriteConcernError createWriteConcernError(BsonDocument writeConcernErrorDocument) {
        return new WriteConcernError(writeConcernErrorDocument.getNumber("code").intValue(), writeConcernErrorDocument.getString("codeName", new BsonString("")).getValue(), writeConcernErrorDocument.getString("errmsg").getValue(), writeConcernErrorDocument.getDocument("errInfo", new BsonDocument()));
    }

    private WriteConcernHelper() {
    }
}

