/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.XLeaderBoards.placeholders;

import io.github.InsiderAnh.XLeaderBoards.XLeaderBoard;
import io.github.InsiderAnh.XLeaderBoards.api.LeaderSession;
import io.github.InsiderAnh.XLeaderBoards.data.PlayerRanking;
import io.github.InsiderAnh.XLeaderBoards.data.PlayerTopper;
import io.github.InsiderAnh.XLeaderBoards.libs.bson.Document;
import io.github.InsiderAnh.XLeaderBoards.tops.TopDate;
import io.github.InsiderAnh.XLeaderBoards.utils.LeaderUtils;
import io.github.InsiderAnh.XLeaderBoards.utils.TimeFormatter;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TopPlaceholders
extends PlaceholderExpansion {
    private final XLeaderBoard plugin = XLeaderBoard.getInstance();

    @NotNull
    public String getIdentifier() {
        return "xleaderboard";
    }

    @NotNull
    public String getAuthor() {
        return "InsiderAnh";
    }

    @NotNull
    public String getVersion() {
        return "1.0.0";
    }

    public boolean persist() {
        return true;
    }

    @Nullable
    public String onPlaceholderRequest(Player player, @NotNull String placeholder) {
        if (placeholder.equals("time")) {
            return this.handleTimePlaceholder(player);
        }
        if (placeholder.startsWith("amount_")) {
            return this.handleAmountPlaceholder(player, placeholder);
        }
        if (placeholder.startsWith("ranking_")) {
            return this.handleRankingPlaceholder(player, placeholder);
        }
        if (placeholder.startsWith("top_")) {
            return this.handleTopPlaceholder(player, placeholder);
        }
        if (placeholder.startsWith("reset_cooldown_")) {
            return this.handleResetCooldownPlaceholder(player, placeholder);
        }
        if (placeholder.startsWith("update_cooldown_")) {
            return this.handleUpdateCooldownPlaceholder(player, placeholder);
        }
        return null;
    }

    private String handleUpdateCooldownPlaceholder(Player player, String placeholder) {
        TopDate topDate = this.plugin.getTopManager().getTopDate();
        if (topDate == null) {
            return "";
        }
        String timeType = this.resolveTimeType(player, placeholder.replace("update_cooldown_", ""));
        if (timeType == null) {
            return "";
        }
        switch (timeType) {
            case "daily": {
                return TimeFormatter.millisToFormattedTime(topDate.getNextDailyTop() - System.currentTimeMillis(), this.plugin);
            }
            case "weekly": {
                return TimeFormatter.millisToFormattedTime(topDate.getNextWeeklyTop() - System.currentTimeMillis(), this.plugin);
            }
            case "monthly": {
                return TimeFormatter.millisToFormattedTime(topDate.getNextMonthlyTop() - System.currentTimeMillis(), this.plugin);
            }
        }
        return TimeFormatter.millisToFormattedTime(topDate.getNextPermanentTop() - System.currentTimeMillis(), this.plugin);
    }

    private String handleResetCooldownPlaceholder(Player player, String placeholder) {
        TopDate topDate = this.plugin.getTopManager().getTopDate();
        if (topDate == null) {
            return "";
        }
        String timeType = this.resolveTimeType(player, placeholder.replace("reset_cooldown_", ""));
        if (timeType == null) {
            return "";
        }
        switch (timeType) {
            case "daily": {
                return TimeFormatter.millisToFormattedTime(topDate.getNextDaily() - System.currentTimeMillis(), this.plugin);
            }
            case "weekly": {
                return TimeFormatter.millisToFormattedTime(topDate.getNextWeekly() - System.currentTimeMillis(), this.plugin);
            }
        }
        return TimeFormatter.millisToFormattedTime(topDate.getNextMonthly() - System.currentTimeMillis(), this.plugin);
    }

    private String handleTimePlaceholder(Player player) {
        LeaderSession leaderSession = LeaderSession.get(player.getUniqueId());
        if (leaderSession != null) {
            return this.plugin.getLang().getString("tops.hologram." + leaderSession.getTopTime());
        }
        return "";
    }

    private String handleAmountPlaceholder(Player player, String placeholder) {
        PlayerTopper playerTopper = this.plugin.getPlayerManager().getPlayerTopper(player.getUniqueId());
        PlaceholderData data = this.parsePlaceholderData(player, placeholder, "amount_");
        if (data == null) {
            return "0";
        }
        return this.getAmountByTimeType(playerTopper, data.timeType, data.topName);
    }

    private String handleRankingPlaceholder(Player player, String placeholder) {
        PlayerTopper playerTopper = this.plugin.getPlayerManager().getPlayerTopper(player.getUniqueId());
        PlayerRanking playerRanking = this.plugin.getPlayerManager().getPlayerRanking(player.getUniqueId());
        if (playerTopper == null) {
            return this.plugin.getLang().getString("tops.noRanking");
        }
        PlaceholderData data = this.parsePlaceholderData(player, placeholder, "ranking_");
        if (data == null) {
            return this.plugin.getLang().getString("tops.noRanking");
        }
        String totalPlaceholder = data.timeType + "_" + data.topName;
        long ranking = playerRanking.getRanking(totalPlaceholder);
        if (ranking < 0L) {
            return this.plugin.getLang().getString("tops.noRanking");
        }
        return String.valueOf(ranking);
    }

    private String handleTopPlaceholder(Player player, String placeholder) {
        String[] parts = placeholder.replaceFirst("top_", "").split(";", 4);
        if (parts.length != 4) {
            return null;
        }
        TopPlaceholderData topData = this.parseTopPlaceholderData(player, parts);
        Document document = this.plugin.getTopManager().getTops().get(topData.timeType + "_" + topData.topName);
        if (document == null) {
            return "No exists " + topData.timeType + " " + topData.topName;
        }
        Document topDocument = (Document)document.get(String.valueOf(topData.index));
        return this.processTopDataType(topDocument, topData.dataType, topData.index);
    }

    private PlaceholderData parsePlaceholderData(Player player, String placeholder, String prefix) {
        String[] parts = placeholder.replaceFirst(prefix, "").split("_", 2);
        if (parts.length != 2) {
            return null;
        }
        String timeType = this.resolveTimeType(player, parts[0]);
        return new PlaceholderData(timeType, parts[1]);
    }

    private TopPlaceholderData parseTopPlaceholderData(Player player, String[] parts) {
        String topName = parts[0];
        String timeType = this.resolveTimeType(player, parts[1]);
        String dataType = parts[2];
        int index = Integer.parseInt(parts[3]);
        return new TopPlaceholderData(topName, timeType, dataType, index);
    }

    private String resolveTimeType(Player player, String timeType) {
        LeaderSession leaderSession;
        if ("placeholder".equals(timeType) && (leaderSession = LeaderSession.get(player.getUniqueId())) != null) {
            return leaderSession.getTopTime();
        }
        return timeType;
    }

    private String getAmountByTimeType(PlayerTopper playerTopper, String timeType, String topName) {
        if (playerTopper == null) {
            return "0";
        }
        switch (timeType) {
            case "daily": {
                return LeaderUtils.formatNumber(playerTopper.getDaily().getOrDefault(topName, 0.0));
            }
            case "weekly": {
                return LeaderUtils.formatNumber(playerTopper.getWeekly().getOrDefault(topName, 0.0));
            }
            case "monthly": {
                return LeaderUtils.formatNumber(playerTopper.getMonthly().getOrDefault(topName, 0.0));
            }
            case "permanent": {
                return LeaderUtils.formatNumber(playerTopper.getPermanent().getOrDefault(topName, 0.0));
            }
        }
        return "0";
    }

    private String processTopDataType(Document topDocument, String dataType, int index) {
        switch (dataType) {
            case "top_line": {
                String topLine = this.plugin.getLang().getString("tops.topLine");
                if (topLine == null) {
                    return "";
                }
                String topName = topDocument == null ? this.plugin.getLang().getString("tops.loading") : topDocument.getString("name");
                String value = topDocument == null ? "0" : this.formatTopValue(topDocument);
                return topLine.replace("<name>", topName).replace("<value>", value).replace("<#>", String.valueOf(index));
            }
            case "top_name": {
                if (topDocument == null) {
                    return this.plugin.getLang().getString("tops.loading");
                }
                return topDocument.getString("name");
            }
            case "top_value": {
                if (topDocument == null) {
                    return this.plugin.getLang().getString("tops.noTop");
                }
                return this.formatTopValue(topDocument);
            }
            case "top_uuid": {
                if (topDocument == null) {
                    return "3e0195dc-a963-4ede-98bd-b4ab63dfa48a";
                }
                return topDocument.getString("uuid");
            }
        }
        return null;
    }

    private String formatTopValue(Document topDocument) {
        Object amount = topDocument.get("amount");
        if (amount instanceof Double) {
            return LeaderUtils.formatNumber(topDocument.getDouble("amount"));
        }
        if (amount instanceof Integer) {
            return String.valueOf(topDocument.getInteger("amount"));
        }
        if (amount instanceof Long) {
            return String.valueOf(topDocument.getLong("amount"));
        }
        return "0";
    }

    private static class PlaceholderData {
        final String timeType;
        final String topName;

        PlaceholderData(String timeType, String topName) {
            this.timeType = timeType;
            this.topName = topName;
        }
    }

    private static class TopPlaceholderData {
        final String topName;
        final String timeType;
        final String dataType;
        final int index;

        TopPlaceholderData(String topName, String timeType, String dataType, int index) {
            this.topName = topName;
            this.timeType = timeType;
            this.dataType = dataType;
            this.index = index;
        }
    }
}

