/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.XLeaderBoards.database;

import io.github.InsiderAnh.XLeaderBoards.XLeaderBoard;
import io.github.InsiderAnh.XLeaderBoards.database.repositories.DatabaseConnection;
import io.github.InsiderAnh.XLeaderBoards.database.repositories.PlayerRepository;
import io.github.InsiderAnh.XLeaderBoards.database.repositories.TopRepository;
import io.github.InsiderAnh.XLeaderBoards.database.types.MongoConnection;
import io.github.InsiderAnh.XLeaderBoards.database.types.MySQLConnection;
import io.github.InsiderAnh.XLeaderBoards.database.types.SQLConnection;

public class LeaderDatabase {
    private final XLeaderBoard plugin = XLeaderBoard.getInstance();
    private DatabaseConnection databaseConnection;

    public void connect() {
        String databaseType = this.plugin.getConfig().getString("databases.databaseType", "h2");
        this.databaseConnection = databaseType.equalsIgnoreCase("mysql") ? new MySQLConnection() : (databaseType.equalsIgnoreCase("mongodb") ? new MongoConnection() : new SQLConnection());
        this.databaseConnection.connect();
        this.databaseConnection.createIndexes();
    }

    public void close() {
        this.databaseConnection.close();
    }

    public PlayerRepository getPlayerRepository() {
        return this.databaseConnection.getPlayerRepository();
    }

    public TopRepository getTopRepository() {
        return this.databaseConnection.getTopRepository();
    }
}

