/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.XLeaderBoards.database.types.mongo;

import io.github.InsiderAnh.XLeaderBoards.XLeaderBoard;
import io.github.InsiderAnh.XLeaderBoards.data.PlayerRanking;
import io.github.InsiderAnh.XLeaderBoards.data.PlayerTopper;
import io.github.InsiderAnh.XLeaderBoards.database.repositories.PlayerRepository;
import io.github.InsiderAnh.XLeaderBoards.libs.bson.Document;
import io.github.InsiderAnh.XLeaderBoards.libs.bson.conversions.Bson;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.client.MongoCollection;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.client.MongoDatabase;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.client.model.UpdateOptions;
import io.github.InsiderAnh.XLeaderBoards.utils.GsonUtils;
import lombok.Generated;
import org.bukkit.entity.Player;

public class PlayerRepositoryMongo
implements PlayerRepository {
    private final XLeaderBoard plugin = XLeaderBoard.getInstance();
    private final MongoCollection<Document> tops;
    private final MongoCollection<Document> topsRanking;

    public PlayerRepositoryMongo(MongoDatabase database) {
        String databaseId = this.plugin.getConfig().getString("databaseId");
        this.tops = database.getCollection(databaseId);
        this.topsRanking = database.getCollection(databaseId + "_ranking");
    }

    @Override
    public PlayerTopper loadPlayer(Player player) {
        PlayerTopper playerTopper;
        Document topDocument = (Document)this.tops.find(new Document("uuid", player.getUniqueId().toString())).first();
        if (topDocument == null) {
            playerTopper = new PlayerTopper();
            this.savePlayer(player, playerTopper);
        } else {
            Document data = (Document)topDocument.get("data");
            playerTopper = (PlayerTopper)this.parseJsonString(data.toJson(GsonUtils.getWriterSettings()), PlayerTopper.class);
        }
        return playerTopper;
    }

    @Override
    public PlayerRanking loadPlayerRanking(Player player) {
        PlayerRanking playerRanking;
        Document topRanking = (Document)this.topsRanking.find(new Document("uuid", player.getUniqueId().toString())).first();
        if (topRanking == null) {
            playerRanking = new PlayerRanking();
            this.savePlayer(player, playerRanking);
        } else {
            Document data = (Document)topRanking.get("data");
            playerRanking = (PlayerRanking)this.parseJsonString(data.toJson(GsonUtils.getWriterSettings()), PlayerRanking.class);
        }
        return playerRanking;
    }

    @Override
    public void saveSyncPlayer(Player player, PlayerTopper playerTopper) {
        Document newPlayer = new Document();
        newPlayer.put("uuid", (Object)player.getUniqueId().toString());
        newPlayer.put("name", (Object)player.getName());
        newPlayer.put("data", (Object)this.toDocument(playerTopper));
        newPlayer.put("lastEdited", (Object)System.currentTimeMillis());
        this.tops.updateOne((Bson)new Document("uuid", player.getUniqueId().toString()), (Bson)new Document("$set", newPlayer), new UpdateOptions().upsert(true));
    }

    @Override
    public void savePlayer(Player player, PlayerTopper playerTopper) {
        Document newPlayer = new Document();
        newPlayer.put("uuid", (Object)player.getUniqueId().toString());
        newPlayer.put("name", (Object)player.getName());
        newPlayer.put("data", (Object)this.toDocument(playerTopper));
        newPlayer.put("lastEdited", (Object)System.currentTimeMillis());
        this.plugin.getExecutor().execute(() -> this.tops.updateOne((Bson)new Document("uuid", player.getUniqueId().toString()), (Bson)new Document("$set", newPlayer), new UpdateOptions().upsert(true)));
    }

    @Override
    public void savePlayer(Player player, PlayerRanking playerRanking) {
        Document newPlayer = new Document();
        newPlayer.put("uuid", (Object)player.getUniqueId().toString());
        newPlayer.put("name", (Object)player.getName());
        newPlayer.put("data", (Object)this.toDocument(playerRanking));
        newPlayer.put("lastEdited", (Object)System.currentTimeMillis());
        this.plugin.getExecutor().execute(() -> this.topsRanking.updateOne((Bson)new Document("uuid", player.getUniqueId().toString()), (Bson)new Document("$set", newPlayer), new UpdateOptions().upsert(true)));
    }

    public Document toDocument(Object b) {
        return Document.parse(GsonUtils.getGson().toJson(b));
    }

    public Object parseJsonString(String jsonObject, Class<?> classOfT) {
        return GsonUtils.getGson().fromJson(jsonObject, classOfT);
    }

    @Generated
    public MongoCollection<Document> getTops() {
        return this.tops;
    }

    @Generated
    public MongoCollection<Document> getTopsRanking() {
        return this.topsRanking;
    }
}

