/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.XLeaderBoards.libs.mongodb.operation;

import io.github.InsiderAnh.XLeaderBoards.libs.bson.BsonDocument;
import io.github.InsiderAnh.XLeaderBoards.libs.bson.BsonString;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.ExplainVerbosity;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.MongoInternalException;

final class ExplainHelper {
    static BsonDocument asExplainCommand(BsonDocument command, ExplainVerbosity explainVerbosity) {
        return new BsonDocument("explain", command).append("verbosity", ExplainHelper.getVerbosityAsString(explainVerbosity));
    }

    private static BsonString getVerbosityAsString(ExplainVerbosity explainVerbosity) {
        switch (explainVerbosity) {
            case QUERY_PLANNER: {
                return new BsonString("queryPlanner");
            }
            case EXECUTION_STATS: {
                return new BsonString("executionStats");
            }
            case ALL_PLANS_EXECUTIONS: {
                return new BsonString("allPlansExecution");
            }
        }
        throw new MongoInternalException(String.format("Unsupported explain verbosity %s", new Object[]{explainVerbosity}));
    }

    private ExplainHelper() {
    }
}

