/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.XLeaderBoards.managers;

import io.github.InsiderAnh.XLeaderBoards.XLeaderBoard;
import io.github.InsiderAnh.XLeaderBoards.data.PlayerRanking;
import io.github.InsiderAnh.XLeaderBoards.data.PlayerTopper;
import io.github.InsiderAnh.XLeaderBoards.tops.TopData;
import java.util.HashMap;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class PlayerManager {
    private final XLeaderBoard plugin = XLeaderBoard.getInstance();
    private final HashMap<UUID, PlayerTopper> players = new HashMap();
    private final HashMap<UUID, PlayerRanking> playersRanking = new HashMap();

    public PlayerTopper loadPlayer(Player player) {
        PlayerTopper playerTopper = this.plugin.getLeaderDatabase().getPlayerRepository().loadPlayer(player);
        PlayerRanking playerRanking = this.plugin.getLeaderDatabase().getPlayerRepository().loadPlayerRanking(player);
        this.players.put(player.getUniqueId(), playerTopper);
        this.playersRanking.put(player.getUniqueId(), playerRanking);
        return playerTopper;
    }

    public void loadPlayerRanking(Player player) {
        PlayerRanking playerRanking = this.plugin.getLeaderDatabase().getPlayerRepository().loadPlayerRanking(player);
        this.playersRanking.put(player.getUniqueId(), playerRanking);
    }

    public void savePlayer(Player player) {
        this.savePlayer(player, this.getPlayerTopper(player.getUniqueId()));
    }

    private void saveSyncPlayer(Player player, PlayerTopper playerTopper) {
        if (playerTopper == null) {
            return;
        }
        this.plugin.getLeaderDatabase().getPlayerRepository().saveSyncPlayer(player, playerTopper);
    }

    private void savePlayer(Player player, PlayerTopper playerTopper) {
        if (playerTopper == null) {
            return;
        }
        this.plugin.getLeaderDatabase().getPlayerRepository().savePlayer(player, playerTopper);
    }

    private void savePlayer(Player player, PlayerRanking playerRanking) {
        if (playerRanking == null) {
            return;
        }
        this.plugin.getLeaderDatabase().getPlayerRepository().savePlayer(player, playerRanking);
    }

    public PlayerTopper getPlayerTopper(UUID uuid) {
        return this.players.get(uuid);
    }

    public PlayerRanking getPlayerRanking(UUID uuid) {
        return this.playersRanking.get(uuid);
    }

    public void forceSave() {
        this.plugin.getExecutor().execute(() -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                PlayerTopper playerTopper;
                if (!player.isOnline() || (playerTopper = this.getPlayerTopper(player.getUniqueId())) == null) continue;
                this.plugin.getTopListener().checkTop(player, playerTopper);
                for (TopData topData : this.plugin.getTopManager().getTopData().values()) {
                    String topName = topData.getName();
                    String placeholder = topData.getPlaceholder();
                    double amount = this.plugin.getTopListener().getParsedAmount(player, placeholder, topName);
                    playerTopper.getDaily().put(topName, this.plugin.getTopListener().getDailyOrRegistry(playerTopper, topName, amount));
                    playerTopper.getWeekly().put(topName, this.plugin.getTopListener().getWeeklyOrRegistry(playerTopper, topName, amount));
                    playerTopper.getMonthly().put(topName, this.plugin.getTopListener().getMonthlyOrRegistry(playerTopper, topName, amount));
                    playerTopper.getPermanent().put(topName, amount);
                }
                this.saveSyncPlayer(player, playerTopper);
            }
            this.plugin.sendDebugMessage("Force updated tops in " + Bukkit.getOnlinePlayers().size() + " players.");
        });
    }

    @Generated
    public HashMap<UUID, PlayerTopper> getPlayers() {
        return this.players;
    }

    @Generated
    public HashMap<UUID, PlayerRanking> getPlayersRanking() {
        return this.playersRanking;
    }
}

