/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.XLeaderBoards.database.types.mysql;

import io.github.InsiderAnh.XLeaderBoards.XLeaderBoard;
import io.github.InsiderAnh.XLeaderBoards.data.PlayerRanking;
import io.github.InsiderAnh.XLeaderBoards.data.PlayerTopper;
import io.github.InsiderAnh.XLeaderBoards.database.repositories.PlayerRepository;
import io.github.InsiderAnh.XLeaderBoards.libs.hikaricp.HikariDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;

public class PlayerRepositoryMySQL
implements PlayerRepository {
    private final XLeaderBoard leaderBoard = XLeaderBoard.getInstance();
    private final HikariDataSource dataSource;

    public PlayerRepositoryMySQL(HikariDataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public PlayerTopper loadPlayer(Player player) {
        PlayerTopper playerTopper = new PlayerTopper();
        String query = "SELECT key_type, period, value FROM player_metrics WHERE playerId = ?";
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement stmt = connection.prepareStatement(query);){
            stmt.setString(1, player.getUniqueId().toString());
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    String keyType = rs.getString("key_type");
                    String period = rs.getString("period");
                    double value = rs.getDouble("value");
                    switch (period.toLowerCase()) {
                        case "daily_registry": {
                            playerTopper.getDailyRegistry().put(keyType, value);
                            break;
                        }
                        case "weekly_registry": {
                            playerTopper.getWeeklyRegistry().put(keyType, value);
                            break;
                        }
                        case "monthly_registry": {
                            playerTopper.getMonthlyRegistry().put(keyType, value);
                            break;
                        }
                        case "daily": {
                            playerTopper.getDaily().put(keyType, value);
                            break;
                        }
                        case "weekly": {
                            playerTopper.getWeekly().put(keyType, value);
                            break;
                        }
                        case "monthly": {
                            playerTopper.getMonthly().put(keyType, value);
                            break;
                        }
                        case "permanent": {
                            playerTopper.getPermanent().put(keyType, value);
                            break;
                        }
                        case "next_daily_reset": {
                            playerTopper.setNextDailyReset((long)value);
                            break;
                        }
                        case "next_weekly_reset": {
                            playerTopper.setNextWeeklyReset((long)value);
                            break;
                        }
                        case "next_monthly_reset": {
                            playerTopper.setNextMonthlyReset((long)value);
                            break;
                        }
                    }
                }
            }
        }
        catch (SQLException e) {
            this.leaderBoard.getLogger().info("Error on loadPlayer: " + e.getMessage());
        }
        return playerTopper;
    }

    @Override
    public PlayerRanking loadPlayerRanking(Player player) {
        PlayerRanking playerRanking = new PlayerRanking();
        String query = "SELECT key_type, value FROM player_metrics WHERE playerId = ? AND period = 'ranking'";
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement stmt = connection.prepareStatement(query);){
            stmt.setString(1, player.getUniqueId().toString());
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    String keyType = rs.getString("key_type");
                    long value = rs.getLong("value");
                    playerRanking.getRanking().put(keyType, value);
                }
            }
        }
        catch (SQLException e) {
            this.leaderBoard.getLogger().info("Error on loadPlayerRanking: " + e.getMessage());
        }
        return playerRanking;
    }

    @Override
    public void savePlayer(Player player, PlayerTopper playerTopper) {
        String insertOrUpdate = "INSERT INTO player_metrics (playerId, playerName, key_type, period, value) VALUES (?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE value = VALUES(value), last_updated = CURRENT_TIMESTAMP";
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement stmt = connection.prepareStatement(insertOrUpdate);){
            String playerId = player.getUniqueId().toString();
            String playerName = player.getName();
            this.saveHashMap(stmt, playerId, playerName, playerTopper.getDailyRegistry(), "daily_registry");
            this.saveHashMap(stmt, playerId, playerName, playerTopper.getWeeklyRegistry(), "weekly_registry");
            this.saveHashMap(stmt, playerId, playerName, playerTopper.getMonthlyRegistry(), "monthly_registry");
            this.saveHashMap(stmt, playerId, playerName, playerTopper.getDaily(), "daily");
            this.saveHashMap(stmt, playerId, playerName, playerTopper.getWeekly(), "weekly");
            this.saveHashMap(stmt, playerId, playerName, playerTopper.getMonthly(), "monthly");
            this.saveHashMap(stmt, playerId, playerName, playerTopper.getPermanent(), "permanent");
            if (playerTopper.getNextDailyReset() > 0L) {
                this.saveMetric(stmt, playerId, playerName, "reset_time", "next_daily_reset", playerTopper.getNextDailyReset());
            }
            if (playerTopper.getNextWeeklyReset() > 0L) {
                this.saveMetric(stmt, playerId, playerName, "reset_time", "next_weekly_reset", playerTopper.getNextWeeklyReset());
            }
            if (playerTopper.getNextMonthlyReset() > 0L) {
                this.saveMetric(stmt, playerId, playerName, "reset_time", "next_monthly_reset", playerTopper.getNextMonthlyReset());
            }
        }
        catch (SQLException e) {
            this.leaderBoard.getLogger().info("Error on savePlayer: " + e.getMessage());
        }
    }

    @Override
    public void savePlayer(Player player, PlayerRanking playerRanking) {
        String insertOrUpdate = "INSERT INTO player_metrics (playerId, playerName, key_type, period, value) VALUES (?, ?, ?, 'ranking', ?) ON DUPLICATE KEY UPDATE value = VALUES(value), last_updated = CURRENT_TIMESTAMP";
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement stmt = connection.prepareStatement(insertOrUpdate);){
            String playerId = player.getUniqueId().toString();
            String playerName = player.getName();
            stmt.setString(1, playerId);
            stmt.setString(2, playerName);
            for (Map.Entry<String, Long> entry : playerRanking.getRanking().entrySet()) {
                stmt.setString(3, entry.getKey());
                stmt.setLong(4, entry.getValue());
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            this.leaderBoard.getLogger().info("Error on savePlayer: " + e.getMessage());
        }
    }

    @Override
    public void saveSyncPlayer(Player player, PlayerTopper playerTopper) {
        this.savePlayer(player, playerTopper);
    }

    private void saveHashMap(PreparedStatement stmt, String playerId, String playerName, HashMap<String, Double> map, String period) throws SQLException {
        stmt.setString(1, playerId);
        stmt.setString(2, playerName);
        stmt.setString(4, period);
        for (Map.Entry<String, Double> entry : map.entrySet()) {
            stmt.setString(3, entry.getKey());
            stmt.setLong(5, entry.getValue().longValue());
            stmt.addBatch();
        }
    }

    private void saveMetric(PreparedStatement stmt, String playerId, String playerName, String keyType, String period, long value) throws SQLException {
        stmt.setString(1, playerId);
        stmt.setString(2, playerName);
        stmt.setString(3, keyType);
        stmt.setString(4, period);
        stmt.setLong(5, value);
        stmt.addBatch();
    }
}

