/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.XLeaderBoards.libs.mongodb.client.internal;

import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.ClientSessionOptions;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.MongoClientException;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.MongoException;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.MongoExecutionTimeoutException;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.MongoInternalException;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.ReadConcern;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.TransactionOptions;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.WriteConcern;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.assertions.Assertions;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.client.ClientSession;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.client.TransactionBody;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.client.internal.ClientSessionClock;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.client.internal.MongoClientDelegate;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.internal.session.BaseClientSessionImpl;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.internal.session.ServerSessionPool;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.operation.AbortTransactionOperation;
import io.github.InsiderAnh.XLeaderBoards.libs.mongodb.operation.CommitTransactionOperation;
import java.util.concurrent.TimeUnit;

final class ClientSessionImpl
extends BaseClientSessionImpl
implements ClientSession {
    private static final int MAX_RETRY_TIME_LIMIT_MS = 120000;
    private final MongoClientDelegate delegate;
    private TransactionState transactionState = TransactionState.NONE;
    private boolean messageSentInCurrentTransaction;
    private boolean commitInProgress;
    private TransactionOptions transactionOptions;

    ClientSessionImpl(ServerSessionPool serverSessionPool, Object originator, ClientSessionOptions options, MongoClientDelegate delegate) {
        super(serverSessionPool, originator, options);
        this.delegate = delegate;
    }

    @Override
    public boolean hasActiveTransaction() {
        return this.transactionState == TransactionState.IN || this.transactionState == TransactionState.COMMITTED && this.commitInProgress;
    }

    @Override
    public boolean notifyMessageSent() {
        if (this.hasActiveTransaction()) {
            boolean firstMessageInCurrentTransaction = !this.messageSentInCurrentTransaction;
            this.messageSentInCurrentTransaction = true;
            return firstMessageInCurrentTransaction;
        }
        if (this.transactionState == TransactionState.COMMITTED || this.transactionState == TransactionState.ABORTED) {
            this.cleanupTransaction(TransactionState.NONE);
        }
        return false;
    }

    @Override
    public TransactionOptions getTransactionOptions() {
        Assertions.isTrue("in transaction", this.transactionState == TransactionState.IN || this.transactionState == TransactionState.COMMITTED);
        return this.transactionOptions;
    }

    @Override
    public void startTransaction() {
        this.startTransaction(TransactionOptions.builder().build());
    }

    @Override
    public void startTransaction(TransactionOptions transactionOptions) {
        Assertions.notNull("transactionOptions", transactionOptions);
        if (this.transactionState == TransactionState.IN) {
            throw new IllegalStateException("Transaction already in progress");
        }
        if (this.transactionState == TransactionState.COMMITTED) {
            this.cleanupTransaction(TransactionState.IN);
        } else {
            this.transactionState = TransactionState.IN;
        }
        this.getServerSession().advanceTransactionNumber();
        this.transactionOptions = TransactionOptions.merge(transactionOptions, this.getOptions().getDefaultTransactionOptions());
        WriteConcern writeConcern = this.transactionOptions.getWriteConcern();
        if (writeConcern == null) {
            throw new MongoInternalException("Invariant violated.  Transaction options write concern can not be null");
        }
        if (!writeConcern.isAcknowledged()) {
            throw new MongoClientException("Transactions do not support unacknowledged write concern");
        }
        this.setPinnedServerAddress(null);
    }

    @Override
    public void commitTransaction() {
        if (this.transactionState == TransactionState.ABORTED) {
            throw new IllegalStateException("Cannot call commitTransaction after calling abortTransaction");
        }
        if (this.transactionState == TransactionState.NONE) {
            throw new IllegalStateException("There is no transaction started");
        }
        try {
            if (this.messageSentInCurrentTransaction) {
                ReadConcern readConcern = this.transactionOptions.getReadConcern();
                if (readConcern == null) {
                    throw new MongoInternalException("Invariant violated.  Transaction options read concern can not be null");
                }
                this.commitInProgress = true;
                this.delegate.getOperationExecutor().execute(new CommitTransactionOperation(this.transactionOptions.getWriteConcern(), this.transactionState == TransactionState.COMMITTED).recoveryToken(this.getRecoveryToken()).maxCommitTime(this.transactionOptions.getMaxCommitTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS), readConcern, this);
            }
        }
        catch (MongoException e) {
            this.unpinServerAddressOnError(e);
            throw e;
        }
        finally {
            this.transactionState = TransactionState.COMMITTED;
            this.commitInProgress = false;
        }
    }

    @Override
    public void abortTransaction() {
        if (this.transactionState == TransactionState.ABORTED) {
            throw new IllegalStateException("Cannot call abortTransaction twice");
        }
        if (this.transactionState == TransactionState.COMMITTED) {
            throw new IllegalStateException("Cannot call abortTransaction after calling commitTransaction");
        }
        if (this.transactionState == TransactionState.NONE) {
            throw new IllegalStateException("There is no transaction started");
        }
        try {
            if (this.messageSentInCurrentTransaction) {
                ReadConcern readConcern = this.transactionOptions.getReadConcern();
                if (readConcern == null) {
                    throw new MongoInternalException("Invariant violated.  Transaction options read concern can not be null");
                }
                this.delegate.getOperationExecutor().execute(new AbortTransactionOperation(this.transactionOptions.getWriteConcern()).recoveryToken(this.getRecoveryToken()), readConcern, this);
            }
        }
        catch (Exception e) {
            if (e instanceof MongoException) {
                this.unpinServerAddressOnError((MongoException)e);
            }
        }
        finally {
            this.cleanupTransaction(TransactionState.ABORTED);
        }
    }

    private void unpinServerAddressOnError(MongoException e) {
        if (e.hasErrorLabel("TransientTransactionError") || e.hasErrorLabel("UnknownTransactionCommitResult")) {
            this.setPinnedServerAddress(null);
        }
    }

    @Override
    public <T> T withTransaction(TransactionBody<T> transactionBody) {
        return this.withTransaction(transactionBody, TransactionOptions.builder().build());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <T> T withTransaction(TransactionBody<T> transactionBody, TransactionOptions options) {
        Assertions.notNull("transactionBody", transactionBody);
        long startTime = ClientSessionClock.INSTANCE.now();
        block4: while (true) {
            T retVal;
            try {
                this.startTransaction(options);
                retVal = transactionBody.execute();
            }
            catch (RuntimeException e) {
                if (this.transactionState == TransactionState.IN) {
                    this.abortTransaction();
                }
                if (e instanceof MongoException && ((MongoException)e).hasErrorLabel("TransientTransactionError") && ClientSessionClock.INSTANCE.now() - startTime < 120000L) continue;
                throw e;
            }
            if (this.transactionState != TransactionState.IN) return retVal;
            while (true) {
                try {
                    this.commitTransaction();
                    return retVal;
                }
                catch (MongoException e) {
                    this.unpinServerAddressOnError(e);
                    if (ClientSessionClock.INSTANCE.now() - startTime >= 120000L) throw e;
                    this.applyMajorityWriteConcernToTransactionOptions();
                    if (!(e instanceof MongoExecutionTimeoutException) && e.hasErrorLabel("UnknownTransactionCommitResult")) continue;
                    if (!e.hasErrorLabel("TransientTransactionError")) throw e;
                    continue block4;
                }
                break;
            }
            break;
        }
    }

    private void applyMajorityWriteConcernToTransactionOptions() {
        WriteConcern writeConcern;
        this.transactionOptions = this.transactionOptions != null ? ((writeConcern = this.transactionOptions.getWriteConcern()) != null ? TransactionOptions.merge(TransactionOptions.builder().writeConcern(writeConcern.withW("majority")).build(), this.transactionOptions) : TransactionOptions.merge(TransactionOptions.builder().writeConcern(WriteConcern.MAJORITY).build(), this.transactionOptions)) : TransactionOptions.builder().writeConcern(WriteConcern.MAJORITY).build();
    }

    @Override
    public void close() {
        try {
            if (this.transactionState == TransactionState.IN) {
                this.abortTransaction();
            }
        }
        finally {
            super.close();
        }
    }

    private void cleanupTransaction(TransactionState nextState) {
        this.messageSentInCurrentTransaction = false;
        this.transactionOptions = null;
        this.transactionState = nextState;
    }

    private static enum TransactionState {
        NONE,
        IN,
        COMMITTED,
        ABORTED;

    }
}

