/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.XLeaderBoards.listeners;

import io.github.InsiderAnh.XLeaderBoards.XLeaderBoard;
import io.github.InsiderAnh.XLeaderBoards.data.PlayerRanking;
import io.github.InsiderAnh.XLeaderBoards.data.PlayerTopper;
import io.github.InsiderAnh.XLeaderBoards.tops.TopData;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class TopListener
implements Listener {
    private final XLeaderBoard plugin = XLeaderBoard.getInstance();

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.plugin.getExecutor().execute(() -> {
            if (!player.isOnline()) {
                return;
            }
            PlayerTopper playerTopper = this.plugin.getPlayerManager().loadPlayer(player);
            PlayerRanking playerRanking = this.plugin.getPlayerManager().getPlayerRanking(player.getUniqueId());
            this.plugin.getLogger().info("Topper " + player.getName() + " " + playerTopper.toString());
            this.plugin.getLogger().info("Ranking " + player.getName() + " " + playerRanking.toString());
            this.checkTop(player, playerTopper);
            for (TopData topData : this.plugin.getTopManager().getTopData().values()) {
                String topName = topData.getName();
                String placeholder = topData.getPlaceholder();
                double amount = this.getParsedAmount(player, placeholder, topName);
                playerTopper.getDaily().put(topName, this.getDailyOrRegistry(playerTopper, topName, amount));
                playerTopper.getWeekly().put(topName, this.getWeeklyOrRegistry(playerTopper, topName, amount));
                playerTopper.getMonthly().put(topName, this.getMonthlyOrRegistry(playerTopper, topName, amount));
                playerTopper.getPermanent().put(topName, amount);
                this.plugin.sendDebugMessage(player.getName() + " top: " + topName + " amount: " + amount);
            }
        });
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.plugin.getPlayerManager().savePlayer(player);
    }

    public double getDailyOrRegistry(PlayerTopper playerTop, String key, double amount) {
        return Math.max(amount - playerTop.getDailyRegistry().computeIfAbsent(key, k -> amount), 0.0);
    }

    public double getWeeklyOrRegistry(PlayerTopper playerTop, String key, double amount) {
        return Math.max(amount - playerTop.getWeeklyRegistry().computeIfAbsent(key, k -> amount), 0.0);
    }

    public double getMonthlyOrRegistry(PlayerTopper playerTop, String key, double amount) {
        return Math.max(amount - playerTop.getMonthlyRegistry().computeIfAbsent(key, k -> amount), 0.0);
    }

    public void checkTop(Player player, PlayerTopper playerTopper) {
        if (this.plugin.getTopManager().getTopDate() == null) {
            return;
        }
        long daily = this.plugin.getTopManager().getTopDate().getNextDaily();
        long weekly = this.plugin.getTopManager().getTopDate().getNextWeekly();
        long monthly = this.plugin.getTopManager().getTopDate().getNextMonthly();
        HashMap<String, TopData> topDataMap = this.plugin.getTopManager().getTopData();
        if (playerTopper.getDailyRegistry().isEmpty() || playerTopper.getWeeklyRegistry().isEmpty() || playerTopper.getMonthlyRegistry().isEmpty()) {
            this.populateRegistry(player, playerTopper, topDataMap);
            return;
        }
        boolean save = false;
        if (playerTopper.getNextDailyReset() <= daily) {
            this.resetRegistry(player, playerTopper.getDaily(), playerTopper.getDailyRegistry(), topDataMap);
            playerTopper.setNextDailyReset(daily + TimeUnit.DAYS.toMillis(1L));
            save = true;
        }
        if (playerTopper.getNextWeeklyReset() <= weekly) {
            this.resetRegistry(player, playerTopper.getWeekly(), playerTopper.getWeeklyRegistry(), topDataMap);
            playerTopper.setNextWeeklyReset(weekly + TimeUnit.DAYS.toMillis(7L));
            save = true;
        }
        if (playerTopper.getNextMonthlyReset() <= monthly) {
            this.resetRegistry(player, playerTopper.getMonthly(), playerTopper.getMonthlyRegistry(), topDataMap);
            playerTopper.setNextMonthlyReset(monthly + TimeUnit.DAYS.toMillis(30L));
            save = true;
        }
        if (save) {
            this.plugin.getPlayerManager().savePlayer(player);
        }
    }

    private void populateRegistry(Player player, PlayerTopper playerTopper, Map<String, TopData> topDataMap) {
        for (TopData topData : topDataMap.values()) {
            String topName = topData.getName();
            String placeholder = topData.getPlaceholder();
            double amount = this.getParsedAmount(player, placeholder, topName);
            playerTopper.getDailyRegistry().put(topName, amount);
            playerTopper.getWeeklyRegistry().put(topName, amount);
            playerTopper.getMonthlyRegistry().put(topName, amount);
        }
    }

    private void resetRegistry(Player player, Map<String, Double> registry, Map<String, Double> backupRegistry, Map<String, TopData> topDataMap) {
        registry.clear();
        for (TopData topData : topDataMap.values()) {
            String topName = topData.getName();
            String placeholder = topData.getPlaceholder();
            double amount = this.getParsedAmount(player, placeholder, topName);
            backupRegistry.put(topName, amount);
        }
    }

    public double getParsedAmount(Player player, String placeholder, String topName) {
        double amount;
        try {
            amount = Math.max(Double.parseDouble(PlaceholderAPI.setPlaceholders((Player)player, (String)placeholder)), 0.0);
        }
        catch (Exception exception) {
            this.plugin.sendDebugMessage("An error has occurred while parsing the placeholder " + placeholder + " for " + player.getName() + " in " + topName);
            return 0.0;
        }
        return amount;
    }
}

