/*
 * Decompiled with CFR 0.152.
 */
package blasty.manHunt.Manhunt;

import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class CreateTrackingCompass {
    private final JavaPlugin plugin;

    public CreateTrackingCompass(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public ItemStack createCompass() {
        ItemStack compass = new ItemStack(Material.COMPASS);
        compass.setAmount(1);
        ItemMeta meta = compass.getItemMeta();
        if (meta != null) {
            meta.setCustomModelData(Integer.valueOf(1));
            meta.setDisplayName(String.valueOf(ChatColor.RED) + "Player Tracker");
            meta.setFireResistant(true);
            meta.setUnbreakable(true);
            meta.setHideTooltip(true);
            compass.setItemMeta(meta);
        }
        return compass;
    }

    public BukkitTask startTrackingCompass(final Player hunter, final Player runner) {
        BukkitRunnable runnable = new BukkitRunnable(this){

            public void run() {
                if (!hunter.isOnline() || !runner.isOnline()) {
                    this.cancel();
                    return;
                }
                ItemStack item = hunter.getInventory().getItemInMainHand();
                if (item == null || item.getType() != Material.COMPASS) {
                    return;
                }
                ItemMeta meta = item.getItemMeta();
                if (meta == null) {
                    return;
                }
                if (meta.hasCustomModelData() && meta.getCustomModelData() == 1) {
                    hunter.setCompassTarget(runner.getLocation());
                }
            }
        };
        return runnable.runTaskTimer((Plugin)this.plugin, 0L, 40L);
    }
}

